function out = export_dialog(pixelSize,searchPath)


%Function is executed when user pressed "Export tracks". Creates a user
%interface where the user can choose how the data should be exported and
%returns the selection to TrackIt as soon as the "Ok" button is clicked.

if nargin == 0
    pixelSize = 0;
    searchPath = pwd;
end

%Create user interface
ui = createExportDialog;

%Initialize a export filename suggestion
suggFileName = [datestr(now,'yymmdd'), '_trackedPar.mat'];

%Initialize return value
out = struct('nBrightFrames',NaN,'itmExpTime',NaN,'itmDarkTime',NaN,'pixelSize',NaN,...
    'destination','','fileFormatMat',NaN,'filesPerMovie',NaN,'periodicIllumination',NaN,...
    'additionalExport',NaN,'combatibility',NaN);

%Wait for ui to close
uiwait(ui.d);

    function ui = createExportDialog()
        ui.d = figure('Position',[300 300 550 300],'Name','Export options','Menubar','none');
        
        bgSize = [.3 .21];
        
        ui.bgFileFormat = uibuttongroup('Parent',ui.d,'Title','Export file format',...
            'Position',[.025 .75 bgSize(1) bgSize(2)+.03]);
        
        ui.rbMat	= uicontrol(ui.bgFileFormat,...
            'Units','normalized',...
            'Position',[.01 .5 .4 .4],...
            'Style','radiobutton',...
            'String','.mat',...
            'Callback',@RbFileFormatCB);
        
        ui.rbCsv = uicontrol(ui.bgFileFormat,...
            'Units','normalized',...
            'Position',[.01 .05 .4 .4],...
            'Style','radiobutton',...
            'String','.csv',...
            'Callback',@RbFileFormatCB);
        
        ui.txtCombatibility = uicontrol(ui.bgFileFormat,...
            'Units','normalized',...
            'Position',[.45 .45 .45 .4],...
            'Style','text',...
            'String','Combatibility');
        
        ui.rbCombatibility = uicontrol(ui.bgFileFormat,...
            'Units','normalized',...
            'Position',[.45 .1 .45 .4],...
            'Style','popupmenu',...
            'String',{'Spot-On (structure array)', 'vbSPT (cell array)'});
        
        
        ui.bgIllumination = uibuttongroup('Parent',ui.d,'Title','Illumination pattern',...
            'Position',[.025 .52 bgSize]);
        
        ui.rbPeriodic	= uicontrol(ui.bgIllumination,...
            'Units','normalized',...
            'Position',[.01 .5 .9 .4],...
            'Style','radiobutton',...
            'String','Continuous',...
            'Callback',@RbIlluminationPatternCB);
        
        ui.rbInterlaced = uicontrol(ui.bgIllumination,...
            'Units','normalized',...
            'Position',[.01 .0 .9 .4],...
            'Style','radiobutton',...
            'String','Interlaced (ITM)',...
            'Callback',@RbIlluminationPatternCB);
        
        ui.bgFilesPerMovie = uibuttongroup('Parent',ui.d,'Title','Amount of files',...
            'Position',[.025 .13 bgSize(1) bgSize(2)+.16]);
        
        ui.rbOneFilePerMovie	= uicontrol(ui.bgFilesPerMovie,...
            'Units','normalized',...
            'Position',[.01 .75 .9 .3],...
            'Style','radiobutton',...
            'String','One per movie',...
            'Callback',@RbFilesPerMovieCB);
        
        ui.rbOneFilePerCycleTime	= uicontrol(ui.bgFilesPerMovie,...
            'Units','normalized',...
            'Position',[.01 .5 .9 .3],...
            'Style','radiobutton',...
            'String','One per cycle time',...
            'Callback',@RbFilesPerMovieCB);
        
        ui.rbAllInOneFile = uicontrol(ui.bgFilesPerMovie,...
            'Units','normalized',...
            'Position',[.01 .25 .9 .3],...
            'Style','radiobutton',...
            'String','All tracks in one file',...
            'Callback',@RbFilesPerMovieCB);
        
        ui.rbOneFilePerRegion = uicontrol(ui.bgFilesPerMovie,...
            'Units','normalized',...
            'Position',[.01 .0 .9 .3],...
            'Style','radiobutton',...
            'String','One per sub-region',...
            'Visible', 'on',...
            'Callback',@RbFilesPerMovieCB);
        
        
        txtHorPos = 180;
        editHorPos = 300;
        txtSpaceVert = 35;
        txtvertPos = 80;
        editSizeVert = 20;
        
        
        ui.txtDestination = uicontrol('Parent',ui.d,...
            'Style','Text',...
            'Position',[txtHorPos 260 230 15],...
            'HorizontalAlignment','Left',...
            'String','Destination folder:');
        
        ui.editDestination = uicontrol('Parent',ui.d,...
            'Style','Edit',...
            'Position',[txtHorPos 230 360 20],...
            'HorizontalAlignment','Left',...
            'String',searchPath);
        
        ui.btnDestination = uicontrol('Parent',ui.d,...
            'Style','pushbutton',...
            'Position',[txtHorPos+300 255 60 20],...
            'HorizontalAlignment','Left',...
            'String','Search','Callback',@DestinationCB);
        
        ui.txtPixelSize = uicontrol('Parent',ui.d,...
            'Style','text',...
            'HorizontalAlignment','Left',...
            'Position',[txtHorPos txtvertPos+txtSpaceVert*3 100 editSizeVert],...
            'String',['Pixelsize (',char(hex2dec('B5')), 'm):']);
        
        ui.editPixelSize = uicontrol('Parent',ui.d,...
            'Style','edit',...
            'Position',[editHorPos txtvertPos+txtSpaceVert*3 50 editSizeVert],...
            'String',pixelSize);
        
        
        ui.txtCycleTime = uicontrol('Parent',ui.d,...
            'Style','Text',...
            'HorizontalAlignment','Left',...
            'Position',[txtHorPos txtvertPos+txtSpaceVert*2 120 editSizeVert],...
            'Visible','off',...
            'String','Exposure time (ms):');
        
        ui.editCycleTime = uicontrol('Parent',ui.d,...
            'Style','edit',...
            'Position',[editHorPos txtvertPos+txtSpaceVert*2 50 editSizeVert],...
            'Visible','off',...
            'String','50');
        
        ui.txtBrightFrames = uicontrol('Parent',ui.d,...
            'Style','Text',...
            'HorizontalAlignment','Left',...
            'Position',[txtHorPos txtvertPos+txtSpaceVert*1 100 editSizeVert],...
            'Visible','off',...
            'String','# bright frames:');
        
        ui.editBrightFrames = uicontrol('Parent',ui.d,...
            'Style','edit',...
            'Position',[editHorPos txtvertPos+txtSpaceVert*1 50 editSizeVert],...
            'Visible','off',...
            'String','2');
        
        ui.txtDarkTime = uicontrol('Parent',ui.d,...
            'Style','Text',...
            'HorizontalAlignment','Left',...
            'Position',[txtHorPos txtvertPos 100 editSizeVert],...
            'Visible','off',...
            'String','Dark time (ms):');
        
        ui.editDarkTime = uicontrol('Parent',ui.d,...
            'Style','edit',...
            'Position',[editHorPos txtvertPos 50 editSizeVert],...
            'Visible','off',...
            'String','');
        
        ui.tableAdditionalExport = uitable(ui.d,...
            'Position',[375 20 165 200],...
            'ColumnName',{},...
            'ColumnWidth',{20,125,25},...
            'RowName',{},...
            'Data',{false,'Settings';false,'ROI';false,'ROI size';...
            false,'Track lengths';...
            false,'Jump distances';false,'Jump angles';
            false,'#detections';false,'#tracks';...
            false,'#non-linked spots'
            false,'sub-region results'},...
            'ColumnEditable',[true,false]);
        
        
        ui.btnOK = uicontrol('Parent',ui.d,...
            'Position',[txtHorPos 10 100 25],...
            'String','Ok',...
            'Callback',@okCB);
        
    end

    function RbFileFormatCB(~,~)
        %User switched between .mat and .csv or between "Spot-on" and "vbSPT" format
        
        [pathName,fileName,extension] = fileparts(ui.editDestination.String);

        if ui.rbCsv.Value
            ui.rbCombatibility.String = {'Spot-On (structure array)'};
            ui.rbCombatibility.Value = 1;
            if ~isempty(extension)
                ui.editDestination.String = fullfile(pathName,[fileName,'.csv']);
            else
                suggFileName = [datestr(now,'yymmdd'), '_trackedPar.csv'];
            end
            ui.tableAdditionalExport.Visible = 'off';
        elseif ui.rbMat.Value
            ui.rbCombatibility.String = {'Spot-On (structure array)', 'vbSPT (cell array)'};
            if ~isempty(extension)
                ui.editDestination.String = fullfile(pathName,[fileName, '.mat']);
            else
                suggFileName = [datestr(now,'yymmdd'), '_trackedPar.mat'];
            end
            ui.tableAdditionalExport.Visible = 'on';
        end
        
    end

    function RbIlluminationPatternCB(src,~)
        %User switch illumination between "Periodic" and "ITM"
        
        switch src.String
            case 'Continuous'
                ui.txtCycleTime.Visible = 'off';
                ui.editCycleTime.Visible = 'off';
                ui.txtBrightFrames.Visible = 'off';
                ui.editBrightFrames.Visible = 'off';
                ui.txtDarkTime.Visible = 'off';
                ui.editDarkTime.Visible = 'off';
            case 'Interlaced (ITM)'
                ui.txtCycleTime.Visible = 'on';
                ui.editCycleTime.Visible = 'on';
                ui.txtBrightFrames.Visible = 'on';
                ui.editBrightFrames.Visible = 'on';
                ui.txtDarkTime.Visible = 'on';
                ui.editDarkTime.Visible = 'on';
        end
    end

    function DestinationCB(~,~)
        %User clicked "search" button
        
        if ui.rbOneFilePerMovie.Value || ui.rbOneFilePerCycleTime.Value || ui.rbOneFilePerRegion.Value
            pathName = uigetdir(searchPath,'Choose a Folder for saving analysis results');
            
            if pathName == 0
                return
            end
            
            ui.editDestination.String = pathName;
            searchPath = pathName;
        elseif ui.rbAllInOneFile.Value
            if ui.rbMat.Value
                format = '.mat';
            elseif ui.rbCsv.Value
                format = '.csv';
            end
            
            [fileName, pathName] = uiputfile(['*',format],'Choose filename for saving analysis results in .mat file',fullfile(searchPath,[datestr(now,'yymmdd'), '_trackedPar', format]));
            
            if pathName == 0
                return
            end
            
            suggFileName = fileName;
            searchPath = pathName;
            ui.editDestination.String = fullfile(pathName,fileName);
            
        end
        
        
    end

    function RbFilesPerMovieCB(~,~)
        %User switched radiobutton in the "amount of files" panel
        
        if ui.rbOneFilePerMovie.Value || ui.rbOneFilePerCycleTime.Value
            ui.txtDestination.String = 'Destination folder:';
            ui.editDestination.String = searchPath;
        elseif ui.rbAllInOneFile.Value
            ui.txtDestination.String = 'Destination file:';
            ui.editDestination.String = fullfile(searchPath,suggFileName);
        elseif ui.rbOneFilePerRegion.Value
            ui.txtDestination.String = 'Destination folder:';
            ui.editDestination.String = searchPath;            
        end
                
        
    end

    function okCB(~,~)
        %User pressed "ok" button
        
        ui.editPixelSize.BackgroundColor = [.94 .94 .94];
        ui.editDestination.BackgroundColor = [.94 .94 .94];
        ui.editDarkTime.BackgroundColor = [.94 .94 .94];
        ui.editCycleTime.BackgroundColor = [.94 .94 .94];
        ui.editBrightFrames.BackgroundColor = [.94 .94 .94];
        
        if str2double(ui.editPixelSize.String) == 0 || isempty(ui.editPixelSize.String)
            ui.editPixelSize.BackgroundColor = 'r';
        elseif isempty(ui.editDestination.String)
            ui.editDestination.BackgroundColor = 'r';
        elseif isempty(ui.editDarkTime.String) && ~ui.rbPeriodic.Value
            ui.editDarkTime.BackgroundColor = 'r';
        elseif isempty(ui.editCycleTime.String) && ~ui.rbPeriodic.Value
            ui.editCycleTime.BackgroundColor = 'r';
        elseif isempty(ui.editBrightFrames.String)&& ~ui.rbPeriodic.Value
            ui.editBrightFrames.BackgroundColor = 'r';
        else
            out.nBrightFrames = str2double(ui.editBrightFrames.String);
            out.itmExpTime = str2double(ui.editCycleTime.String);
            out.itmDarkTime = str2double(ui.editDarkTime.String);
            out.pixelSize = str2double(ui.editPixelSize.String);
            out.destination = ui.editDestination.String;
            
            out.fileFormatMat = ui.rbMat.Value;
            out.filesPerMovie = find([ui.rbOneFilePerMovie.Value ui.rbOneFilePerCycleTime.Value ui.rbAllInOneFile.Value ui.rbOneFilePerRegion.Value]);
            out.periodicIllumination = ui.rbPeriodic.Value;
            out.additionalExport = ui.tableAdditionalExport.Data;
            out.combatibility = ui.rbCombatibility.Value;
            delete(gcf);
        end
        
    end
end
