function colorMap = custom_colormap(nColors)
%%Combines standard matlab colors with colorbrewer maps from
%%https://colorbrewer2.org to create a colormap with more colors.


%Standard matlab line colors
matColors = colormap(lines(7));

%set1 colormap
set1 = [ 228	26	28;...
    55	126	184;...
    77	175	74;...
    152	78	163;...
    255	127	0;...
    255	255	51;...
    166	86	40;...
    247	129	191;...
    153	153	153]./255;

%accent colormap
accent = [127	201	127;...
    190	174	212;...
    253	192	134;...
    255	255	153;...
    56	108	176;...
    240	2	127;...
    191	91	23;...
    102	102	102]./255;

%dark2 colormap
dark2 = [27	158	119;...
    217	95	2;...
    117	112	179;...
    231	41	138;...
    102	166	30;...
    230	171	2;...
    166	118	29;...
    102	102	102]./255;

%Set3 colormap
set3 = [141	211	199;...
    255	255	179;...
    190	186	218;...
    251	128	114;...
    128	177	211;...
    253	180	98;...
    179	222	105;...
    252	205	229;...
    217	217	217;...
    188	128	189;...
    204	235	197;...
    255	237	111]./255;

%Paired colormap
paired = [166	206	227;...
    31	120	180;...
    178	223	138;...
    51	160	44;...
    251	154	153;...
    227	26	28;...
    253	191	111;...
    255	127	0;...
    202	178	214;...
    106	61	154;...
    255	255	153;...
    177	89	40]./255;


colorMap = [matColors; accent; set1; set3; dark2; paired];


if nColors > size(colorMap,1)
    colorMap = [colorMap; distinguishable_colors(nColors-size(colorMap,1),{'w'})];
end

colorMap = colorMap(1:nColors,:);

end