@parameters
default,lread,1
if lread then begin
  restore,'bb_VAR'+str(ivar)+'.sav'
  lread=0
  ;
  ;  This routine reads the integrated ivar file 'bb_VAR'+str(ivar)+'.sav'
  ;  specified in parameters.pro. It can take a lot of time.
  ;
  nz=n_elements(z)
  bb_plane_z=reform(bb[*,*,0,*])
  ;stop
  ;
  ; save plane
  ;
  help, bb_plane_z
  save,file='bb_plane_z_VAR'+str(ivar)+'.sav',t,x,y,bb_plane_z
  ;
  print,'Slow operation to follow (15-30 min)! Press .c to continue...'
  ;stop
  bb_int_z=total(bb,3)/nz
  save,file='bb_int_z_VAR'+str(ivar)+'.sav',t,x,y,bb_int_z
  ;
  ;  compute complex B squared, (B_x+iB_y)^2
  ;
  bb2=complex(bb[*,*,*,0],bb[*,*,*,1])^2
  ;
  print,'Slow operation to follow (~15 min)! Press .c to continue...'
  ;stop
  ;
  bb2_int_z=total(bb2,3)/nz
  save,file='bb2_int_z_VAR'+str(ivar)+'.sav',t,x,y,bb2_int_z
  ;
endif
;
;help, bb_plane_z, bb_int_z
END
