;$Id: pspec_lor_posneg_single.pro,v 1.1 2019/02/16 13:53:19 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=12,yoffset=3
  !p.charthick=4 & !p.thick=4 & !x.thick=4 & !y.thick=4
end
;
!p.charsize=1.6
!x.margin=[9.6,.5]
!y.margin=[3.2,.5]
!p.multi=0
;
dir1='576k4Pm001a2'& eps1=1.49e-04
dir2='576k4Pm005a'& eps1=1.49e-04
dir3='576k4Pm02a' & eps2=1.37e-04
dir4='576k4Pm5a'  & eps3=1.49e-04
dir5='576k4Pm20a' & eps4=1.37e-04
dir6='576k4Pm100a' & eps5=1.26e-04
dir7='1152k4Pm500a' & eps6=1.26e-04
dir8='1152k4Pm2000b' & eps7=1.26e-04
;
PrM=[.01,.05,.2,5,20,100,500,2000]
dirs=[dir1,dir2,dir3,dir4,dir5,dir6,dir7,dir8]
ndir=n_elements(dirs)
pos=fltarr(ndir)
neg=fltarr(ndir)
;
;  read table from 
;
file='~/tex/mhd/LSeps_vs_Prandtl/idl/pepsKM_ssdy.dat'
a=rtable(file,head=1,14)
urms=reform(a[3,*])
kf=4.
;
!x.range=[.007,3400]
!y.range=[7e-5,1.2]
for idir=0,ndir-1 do begin
  restore,'../'+dirs[idir]+'/mean_spec.sav'
  pos[idir]=+total(mspec2L(where(mspec2L gt 0.)))/(kf*urms[idir]^3)
  neg[idir]=-total(mspec2L(where(mspec2L lt 0.)))/(kf*urms[idir]^3)
endfor
;
!x.title='!6Pr!d!8M!6!n'
!y.title='!8T!6!d+!n  and  !8T!6!d-!n  [!7q!6!d0!n!8k!6!df!n!8u!6!s!u3!n!r!drms!n]'
plot_oo,PrM,pos,ps=-1,/nodata
oplot,PrM,pos,ps=-1,col=122
oplot,PrM,neg,ps=-1,col=55
xyouts,1e3,1.3e-4,'!6(b)',siz=siz
xyouts,.03,1e-1,'!8T!6!d-!n',siz=siz,col=55
xyouts,.03,5e-4,'!8T!6!d+!n',siz=siz,col=122
;
print,'$mv idl.ps ~/tex/mhd/LSeps_vs_Prandtl/fig/pspec_lor_posneg.ps'
END
