;$Id: pspec_lor_posneg.pro,v 1.16 2019/05/21 04:15:27 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=6,yoffset=3
  !p.charthick=1.9 & !p.thick=1.9 & !x.thick=1.9 & !y.thick=1.9
end
;
!p.charsize=.7
!x.margin=[9.6,.2]
!y.margin=[3.2,.2]
!p.multi=[0,2,1]
!x.range=[.007,3400]
siz=1.0
kf=4.    ;(value used in DNS)
kf00=10. ;(value used in LES in Mm^{-1}, corresponding to maximum in T(k))
;
;  1st panel
;
dir1='576k4Pm001a2'& eps1=1.49e-04
dir2='576k4Pm005a'& eps1=1.49e-04
dir3='576k4Pm02a' & eps2=1.37e-04
dir4='576k4Pm5a'  & eps3=1.49e-04
dir5='576k4Pm20a' & eps4=1.37e-04
dir6='576k4Pm100a' & eps5=1.26e-04
dir7='1152k4Pm500a' & eps6=1.26e-04
dir8='1152k4Pm2000b' & eps7=1.26e-04
;
knu=[1500.,640.,450.,170.,65.,21.,20.,8.]
PrM=[.01,.05,.2,5,20,100,500,2000]
dirs=[dir1,dir2,dir3,dir4,dir5,dir6,dir7,dir8]
ndir=n_elements(dirs)
pos=fltarr(ndir)
neg=fltarr(ndir)
;
;  read table from 
;
file='~/tex/mhd/LSeps_vs_Prandtl/idl/pepsKM_ssdy.dat'
a=rtable(file,head=2,14)
urms=reform(a[3,*])
;
yr=[7e-5,2.0]
yr=[7e-5,1.5]
for idir=0,ndir-1 do begin
  restore,'../'+dirs[idir]+'/mean_spec.sav'
  pos[idir]=+total(mspec2L(where(mspec2L gt 0.)))/(kf*urms[idir]^3)
  neg[idir]=-total(mspec2L(where(mspec2L lt 0.)))/(kf*urms[idir]^3)
endfor
;
!x.title='!6'
!y.title='!8T!s!du!n!r!6!u+!n  and  !8T!s!du!n!r!6!u-!n  [!8k!6!df!n!7q!6!d0!n!8u!6!s!u3!n!r!drms!n]'
plot_oo,PrM,pos,yr=yr,ps=-1,/nodata
oplot,PrM,pos,ps=-2,col=122
oplot,PrM,neg,ps=-1,col=55
xyouts,9e2,1.3e-4,'!6(a)',siz=siz
xyouts,.02,1.3e-1,'!8T!s!du!n!r!6!u-!n',siz=siz,col=55
xyouts,.02,5.5e-4,'!8T!s!du!n!r!6!u+!n',siz=siz,col=122
;
urms0=1e5
rho0=3e-6
print,'Rempel (old): rho0*urms0^3=', rho0*urms0^3
kf0=kf00/1e8  ;(in cgs)
rho0urms0=14e9
TT0=kf*rho0*urms0^3
TT0=rho0urms0*kf0
TT0=[12e9,9e9,6e9]*kf0
TTp=[0e-5,67.,104]/TT0
TTm=[152.,179.,154.]/TT0
PrM0=[.088,1.77,54.6]
oplot,PrM0,TTp,ps=-2,col=122,li=2
oplot,PrM0,TTm,ps=-1,col=55,li=2
;xyouts,.30,.80,'!6LES',siz=siz
;xyouts,.03,.01,'!6DNS',siz=siz
xx=40. & dx=180.
legend,xx,dx,4.0e-3,2,' LES',/log,siz=siz
legend,xx,dx,1.4e-3,0,' DNS',/log,siz=siz
;
;  other panel
;
!x.title='!6Pr!d!8M!6!n'
!y.title='!8k!6!d*!n/!8k!6!df!n'
file='crossover.dat'
a=rtable(file,2,head=1)
PrM=reform(a[0,*])
kst=reform(a[1,*])
yr=[.8,200.]
yr=[.2,200.]
plot_oo,PrM,kst/kf,ps=1,yr=yr
loadct,6
circ_sym,.9,0
oplot,PrM,.1*knu/kf,col=122,ps=8
;xx=[.2,940.] & oplot,xx,25./xx^.5/kf,col=122
xyouts,8.,.3,siz=siz,'!8k!d!7m!6!n/10!8k!6!d1!n',col=122
loadct,5
;
;  Rempel data
;
kmax=2*!pi/.004 ;(4km res)
kfk10=[kmax,123.,63.]
oplot,PrM0,kfk10/kf00,ps=-1,li=2
;
xx=[.008,.2] & oplot,xx,14./xx^.6/kf
xx=[200.,2400.] & oplot,xx,25./xx^.25/kf,li=1
xx=[.12,240.] & oplot,xx,25./xx^.25/kf
xyouts,.01,21/kf,'!9A!6Pr!s!8!dM!6!n!r!u-3/5!n',siz=siz
xyouts,.2,10/kf,'!9A!6Pr!s!8!dM!6!n!r!u-1/4!n',siz=siz
xyouts,9e2,120,'!6(b)',siz=siz
xx=30. & dx=180. & ds=dx*.4
legend,xx,dx,40.,2,' LES',/log,siz=siz
legend,xx,dx,22.,1,' DNS',/log,siz=siz
legend,xx,ds,22.,0,'    ',/log,siz=siz
xyouts,.2,120.,siz=siz,'?'
;
print,'$mv idl.ps ~/tex/mhd/LSeps_vs_Prandtl/fig/pspec_lor_posneg.ps'
!p.multi=0
END
