;$Id: pspec_lor_kin5_sat2.pro,v 1.3 2019/04/10 17:42:25 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=12,yoffset=3
  !p.charthick=1.7 & !p.thick=1.7 & !x.thick=1.7 & !y.thick=1.7
end
;
;  This routine is to be run in directory: 576k4Pm20kin6_tra_single
;
power,'_kin','_mag',k=k,spec1=spec1,spec2=spec2,i=n,tt=t,/noplot
;power,'hel_kin','hel_mag',k=k,spec1=spec1h,spec2=spec2h,i=n,tt=t,/noplot
power,'_EMF','hel_EMF',k=k,spec1=spec1E,spec2=spec2E,i=n,tt=t,/noplot
power,'_Tra','hel_Tra',k=k,spec1=spec1T,spec2=spec2T,i=n,tt=t,/noplot
power,'_Lor','hel_Lor',k=k,spec1=spec1L,spec2=spec2L,i=n,tt=t,/noplot
;
kf=4.
siz=.8
siz2=1.
ssiz=0.5
ssi2=0.3
xouts=40.
!p.charsize=.8
!x.margin=[8.3,.5]
!y.margin=[3.2,.2]
!x.range=[1,288]/kf
!p.multi=[0,2,2]
ii=[95,100,105,110,115]
ii=[0,10,20,30,40,50,67]
ii=[0,20,41]
ii=[0,20,40,60,75,84]
ii=[5,5] & s=1e-5
ii=[0,1,10,20,40,60,81] & s=1e-6
ii=[5,20,32,40,45,50,55,81] & s=1e-0
nn=n_elements(ii)
thick=fltarr(nn)+1.
thick[nn-1]=7.
urms=0.07
;
;  Panel 1
;
!y.range=[2e-14,4e-0]
!x.title='!6'
!y.title='!8E!di!n!6(!8k!6)!6  [!7q!6!d0!n!8u!6!s!u2!n!r!drms!n/!8k!6!df!n]'
plot_oo,li=2,k/kf,k,/nodata ;/eps1^.66667*k^1.6667
for j=0,n_elements(ii)-1 do begin
  i=ii(j)
  print,t[i]
  oplot,k/kf,spec1(*,i)*kf/urms^2,thick=thick[j],col=55,li=2
  oplot,k/kf,spec2(*,i)*kf/urms^2,thick=thick[j],col=122
  wait,.005
endfor
xyouts,xouts,2e-1,'!6(a)',siz=siz2
xyouts,siz=siz2,12,1e-2,'!8i!6=M',col=122
xyouts,siz=siz2,7.5,7e-12,'!8i!6=K',col=55
;
;  Panel 2
;
!y.range=[2e-23,4e+0]
!y.title='!8T!du!n!6(!8k!6)!6  [!7q!6!d0!n!8u!6!s!u3!n!r!drms!n]'
plot_oo,li=2,k/kf,k,/nodata ;/eps1^.66667*k^1.6667
for j=0,n_elements(ii)-1 do begin
  i=ii(j)
  print,t[i]
  oplot,k/kf,abs(spec2L(*,i))/urms^3,thick=thick[j]
  circ_sym,0.4,1
  oplot,k/kf,spec2L(*,i)/urms^3,ps=8,col=122
  circ_sym,0.6,0
  oplot,k/kf,-spec2L(*,i)/urms^3,ps=8,col=55
endfor
xyouts,xouts,5e-2,'!6(b)',siz=siz2
xx=.4 & dx=.6
circ_sym,ssi2,1 & legend,xx,dx,2e-19*s,0,/log,siz=siz2,' !8T!du!n!6(!8k!6)>0',ps=8,col=122
circ_sym,ssiz,0 & legend,xx,dx,1e-21*s,0,/log,siz=siz2,' !8T!du!n!6(!8k!6)<0',ps=8,col=55
;
;  Panel 3
;
!y.range=[2e-17,4e-2]
!x.title='!8k!6/!8k!6!df!n'
!y.title='!8T!d!6Str!n(!8k!6)!6  [!7q!6!d0!n!8u!6!s!u3!n!r!drms!n]'
plot_oo,li=2,k/kf,k,/nodata ;/eps1^.66667*k^1.6667
for j=0,n_elements(ii)-1 do begin
  i=ii(j)
  print,t[i]
  oplot,k/kf,abs(spec2T(*,i))/urms^3,thick=thick[j]
  circ_sym,0.4,1
  oplot,k/kf,-spec2T(*,i)/urms^3,ps=8,col=122
  circ_sym,0.6,0
  oplot,k/kf,+spec2T(*,i)/urms^3,ps=8,col=55
endfor
xyouts,xouts,2.5e-3,'!6(c)',siz=siz2
xx=1. & dx=1.0
circ_sym,ssi2,1 & legend,xx,dx,6e-15*s,0,/log,siz=siz2,' !8T!d!6Str!n(!8k!6)>0',ps=8,col=122
circ_sym,ssiz,0 & legend,xx,dx,2e-16*s,0,/log,siz=siz2,' !8T!d!6Str!n(!8k!6)<0',ps=8,col=55
;
;  Panel 4
;
!y.range=[2e-17,4e-2]
!y.title='!8T!d!6Adv!n(!8k!6)!6  [!7q!6!d0!n!8u!6!s!u3!n!r!drms!n]'
plot_oo,li=2,k/kf,k,/nodata ;/eps1^.66667*k^1.6667
for j=0,n_elements(ii)-1 do begin
  i=ii(j)
  print,t[i]
  oplot,k/kf,abs(spec1T(*,i))/urms^3,thick=thick[j]
  circ_sym,0.4,1
  oplot,k/kf,-spec1T(*,i)/urms^3,ps=8,col=122
  circ_sym,0.6,0
  oplot,k/kf,+spec1T(*,i)/urms^3,ps=8,col=55
  ;oplot,k/kf,abs(spec2T(*,i))/urms^3,thick=thick[j],li=2
endfor
xyouts,xouts,2.4e-3,'!6(d)',siz=siz2
xx=.6 & dx=.5
circ_sym,ssi2,1 & legend,xx,dx,6e-15*s,0,/log,siz=siz2,' !8T!d!6Adv!n(!8k!6)>0',ps=8,col=122
circ_sym,ssiz,0 & legend,xx,dx,2e-16*s,0,/log,siz=siz2,' !8T!d!6Adv!n(!8k!6)<0',ps=8,col=55
;
print,"$mv idl.ps ~/tex/mhd/LSeps_vs_Prandtl/fig/pspec_lor_kin.ps"
END
