;$Id: pspec_lor.pro,v 1.10 2019/05/21 10:30:00 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=20,yoffset=3
  !p.charthick=1.7 & !p.thick=1.7 & !x.thick=1.7 & !y.thick=1.7
end
;
;  mv idl.ps ~/tex/mhd/LSeps_vs_Prandtl/fig/pspec_lor.ps
;
kf=4.
siz=.9
ssiz=0.5
ssi2=0.3
!p.charsize=1.5
!x.margin=[7.8,.3]
!y.margin=[3.2,-.3]
!x.range=[1,288]/kf
!p.multi=[0,2,8]
yt1='!8E!di!n!6(!8k!6)!6  [!7q!6!d0!n!8u!6!s!u2!n!r!drms!n/!8k!6!df!n]'
yt2='!8T!du!n!6(!8k!6)!6  [!7q!6!d0!n!8u!6!s!u3!n!r!drms!n]'
xouts=1.2
youts1=1.2e-1
youts1=8e-2
youts1b=1e-7
youts=4e-1
thick0=3.
;
;dir1='256b'  & eps1=1.56e-04
;dir1='256a'  & eps1=1.71e-04
;dir1='256_Pm01a'  & eps1=1.45e-04
;dir1='256_Pm005a'  & eps1=1.46e-04 ;(redundant)
;dir1='512_Pm01a'  & eps1=1.49e-04
;dir2='512_Pm002a' & eps2=1.37e-04
;dir3='512_Pm001a' & eps3=1.26e-04
;
dir1='576k4Pm001a2'& eps1=1.49e-04
dir2='576k4Pm005a'& eps1=1.49e-04
dir3='576k4Pm02a' & eps2=1.37e-04
dir4='576k4Pm5a'  & eps3=1.49e-04
dir5='576k4Pm20a' & eps4=1.37e-04
dir6='576k4Pm100a' & eps5=1.26e-04
;dir6='576k4Pm500a' & eps6=1.26e-04
;dir6='576k4Pm500b' & eps6=1.26e-04
dir7='1152k4Pm500a' & eps6=1.26e-04
;dir7='576k4Pm2000a' & eps7=1.26e-04
;dir7='576k4Pm2000b' & eps7=1.26e-04
dir8='1152k4Pm2000b' & eps7=1.26e-04
;
dir=[dir1,dir2,dir3,dir4,dir5,dir6,dir7,dir8]
label=['0.01','0.05','0.2','5','20','100','500','2000']
ndir=n_elements(dir)
;
;  read table from 
;
file='~/tex/mhd/LSeps_vs_Prandtl/idl/pepsKM_ssdy.dat'
a=rtable(file,head=2,14)
urms=reform(a[3,*])
;
icount=0
for idir=0,ndir-1 do begin
  if idir eq ndir-1 then !x.title='!8k!6/!8k!6!df!n' else !x.title='!6'
  restore,'../'+dir[idir]+'/mean_spec.sav'
  ;
  ;  left-hand side
  ;
  xx1=[3,20]
  !y.range=[2e-6,2e-0]
  !y.range=[2e-7,2e-0]
  !y.range=[2e-8,2e-0]
  if idir eq 3 then !y.title=yt1 else !y.title='!6'
  plot_oo,li=2,k/kf,k,/nodata ;/eps1^.66667*k^1.6667
  oplot,k/kf,mspec1*kf/urms[idir]^2,col=55,li=2,thick=thick0
  oplot,k/kf,mspec2*kf/urms[idir]^2,col=122,thick=thick0
  xyouts,xouts/kf,youts1,'('+lowercase(icount)+')',siz=siz
  xyouts,xouts/kf,youts1b,'!6Pr!d!8M!6!n='+label[idir],siz=siz
  if idir eq 0 then begin
    xx=66./kf & dx=37./kf
    circ_sym,ssi2,1 & legend,xx,dx,1e-1,0,/log,siz=siz,' !8E!6!dM!n(!8k!6)',col=122
    circ_sym,ssiz,0 & legend,xx,dx,4e-3,2,/log,siz=siz,' !8E!6!dK!n(!8k!6)',col=55
  endif
  if idir eq 2 then begin
    oplot,xx1,1e-2/xx1^1.6667
    xyouts,5.,2e-6,siz=siz,'!9A!8k!6!u-5/3!n'
  endif
  if idir eq 7 then begin
    oplot,xx1,5e-2/xx1^4.2
    xyouts,3.,5e-7,siz=siz,'!9A!8k!6!u-4.2!n'
  endif
  icount=icount+1
  ;
  ;  right-hand side
  ;
  !y.range=[5e-7,8e-0]
  if idir eq 3 then !y.title=yt2 else !y.title='!6'
  plot_oo,li=2,k/kf,k,/nodata ;/eps1^.66667*k^1.6667
  oplot,k/kf,abs(mspec2L)/urms[idir]^3 ;/eps1^.66667*k^1.6667
  circ_sym,ssi2,1 & oplot,k/kf,+mspec2L/urms[idir]^3,ps=8,col=122
  circ_sym,ssiz,0 & oplot,k/kf,-mspec2L/urms[idir]^3,ps=8,col=55
  xyouts,xouts/kf,youts,'('+lowercase(icount)+')',siz=siz
  print,total(mspec2L>0)/urms[idir]^3,total(-mspec2L>0)/urms[idir]^3
  if idir eq 0. then begin
    xx=63./kf & dx=25./kf
    circ_sym,ssi2,1 & legend,xx,dx,5e-1,0,/log,siz=siz,' !8T!6(!8k!6)>0',ps=8,col=122
    circ_sym,ssiz,0 & legend,xx,dx,2e-2,0,/log,siz=siz,' !8T!6(!8k!6)<0',ps=8,col=55
  endif
  icount=icount+1
endfor
;
print,"$mv idl.ps ~/tex/mhd/LSeps_vs_Prandtl/fig/pspec_lor.ps"
END
