;$Id: pspec2.pro,v 1.9 2012/08/30 19:17:06 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=14,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
;  mv idl.ps ~/tex/mhd/ssdyn/fig/pspec2.ps
;
;  plot kinetic and magnetic spectra separately
;
!p.charsize=1.7
!x.margin=[8.8,.5]
!y.margin=[3.2,1.5]
!x.range=[1,256]
!y.range=[1e-3,4.]
!x.title='!8k!6/!8k!6!d1!n'
!y.title='!8E!6(!8k!6) !7e!6!s!dT!n!r!u-2/3!n !8k!6!u5/3!n'
!p.multi=0
col1=122 & th1=5
col2=55  & th2=8
siz=1.6
;
dir1='512_Pm01a'  & eps1=1.49e-04
dir2='512_Pm002a' & eps2=1.37e-04
dir3='512_Pm001a' & eps3=1.10e-04
dir4='512_Pm002b' & eps4=1.42e-04
;
; kinetic energy spectra
;
restore,'../'+dir1+'/mean_spec.sav'
plot_oo,k,mspec1/eps1^.66667*k^1.6667,li=2
;
restore,'../'+dir2+'/mean_spec.sav'
oplot,k,mspec1/eps2^.66667*k^1.6667,li=0
;
restore,'../'+dir3+'/mean_spec.sav'
oplot,k,mspec1/eps3^.66667*k^1.6667,li=1,col=col2,thick=th2
;
restore,'../'+dir4+'/mean_spec.sav'
oplot,k,mspec1/eps4^.66667*k^1.6667,li=4,col=col1,thick=th1
;
; magnetic energy spectra
;
restore,'../'+dir1+'/mean_spec.sav'
oplot,k,mspec2/eps1^.66667*k^1.6667,li=2
;
restore,'../'+dir2+'/mean_spec.sav'
oplot,k,mspec2/eps2^.66667*k^1.6667,li=0
;
restore,'../'+dir3+'/mean_spec.sav'
oplot,k,mspec2/eps3^.66667*k^1.6667,li=1,col=col2,thick=th2
;
restore,'../'+dir4+'/mean_spec.sav'
oplot,k,mspec2/eps4^.66667*k^1.6667,li=4,col=col1,thick=th1
;
xyouts,1.3,.75,'!8E!dK!n!6(!8k!6)',siz=siz
xyouts,1.3,.10,'!8E!dM!n!6(!8k!6)',siz=siz
;
xx=3.8 & dx=4
legend,xx,dx,10^(-1.9),2,'!6Pr!d!8M!n!6=0.05',siz=siz
legend,xx,dx,10^(-2.2),0,'!6Pr!d!8M!n!6=0.02',siz=siz
legend,xx,dx,10^(-2.5),3,'!6Pr!d!8M!n!6=0.02, Re!d!8M!n!6=220',siz=siz,col=col1
legend,xx,dx,10^(-2.8),1,'!6Pr!d!8M!n!6=0.01',siz=siz,col=col2,thick=th2
;
;xx=[30.,60.] & oplot,xx,5e2/xx^2
xx=[30.,50.] & oplot,xx,3e2/xx^2
xx=[6.,16.] & oplot,xx,.05*xx^.66667
END
