$Id: ppower_last.pro,v 1.2 2019/02/07 14:06:34 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=14,ysize=24,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
;  mv idl.ps ~/tex/mhd/LSeps_vs_Prandtl/fig/ppower_last.ps
;
!p.charsize=2.7
!x.margin=[7.8,.5]
!y.margin=[3.2,.2]
;
power,'_kin','_mag',k=k,spec1=spec1,spec2=spec2,i=n,tt=t,/noplot
power,'_EMF','hel_EMF',k=k,spec1=spec1E,spec2=spec2E,i=n,tt=t,/noplot
power,'_Lor','hel_Lor',k=k,spec1=spec1L,spec2=spec2L,i=n,tt=t,/noplot
;
;  correction factor because of factor 0.5 in fortran code
;
spec1E=spec1E*2.
;
;  $Id: ppower_last.pro,v 1.2 2019/02/07 14:06:34 brandenb Exp $
;
;  This routine is used to view all power spectra
;  that were written during the run (controlled by dspec)
;  The plot range yr is set to a default value.
;  The time interval of plotting is "w" (default value)
;
;   5-oct-02/axel: written
;
spawn,'if (! -f parameters.pro) touch parameters.pro'
@parameters
xr=[1,max(k)]
nt=n_elements(t)
it=nt-1
yr=[3e-14,3e-2]
default,yr,[3e-12,3e-2]
!p.multi=[0,1,4]
!x.title='!6'
circ_sym,0.8,1
;
yr=[3e-14,3e-2]
!y.title='!9!!!8u!dk!n!9!!!6!u2!n  and  !9!!!8B!dk!n!9!!!6!u2!n'
plot_oo,k,spec1(*,it),xr=xr,yr=yr,tit='!8t!6='+str(t(it)),/nodata
oplot,k,spec1(*,it),col=55
oplot,k,spec2(*,it),col=122
;
yr=[3e-14,3e-4]
!y.title='!8u!dk!n !9.!6 (!8J!9X!8B!6)!s!d!8k!6!n!r!u*!n'
plot_oo,k,k,xr=xr,yr=yr,/nodata
oplot,k,abs(spec2L(*,it)),li=0
oplot,k,abs(spec2L(*,it-1)),li=1
oplot,k,abs(spec2L(*,it-2)),li=2
oplot,k,spec2L(*,it),ps=8,col=122
oplot,k,-spec2L(*,it),ps=8,col=55
print,total(spec2L(*,it))
;
!y.title='!8B!dk!n !9.!6 (!8u!9X!8J!6)!s!d!8k!6!n!r!u*!n'
plot_oo,k,k,xr=xr,yr=yr,/nodata
oplot,k,abs(spec1E(*,it)),col=188,li=0
oplot,k,spec1E(*,it),ps=8,col=122
oplot,k,-spec1E(*,it),ps=8,col=55
print,total(spec1E(*,it))
;
!x.title='!8k!6/!8k!6!d1!n'
!y.title='!6-!8J!dk!n !9.!6 (!8u!9X!8B!6)!s!d!8k!6!n!r!u*!n'
plot_oo,k,k,xr=xr,yr=yr,/nodata
oplot,k,abs(spec2E(*,it)),col=188,li=0
oplot,k,-spec2E(*,it),ps=8,col=122
oplot,k,+spec2E(*,it),ps=8,col=55
print,total(-spec2E(*,it))
;
END
