power,'_kin','_mag',k=k,spec1=spec1,spec2=spec2,i=n,tt=t,/noplot
;power,'hel_kin','hel_mag',k=k,spec1=spec1h,spec2=spec2h,i=n,tt=t,/noplot
;power,'_EMF','hel_EMF',k=k,spec1=spec1L,spec2=spec2L,i=n,tt=t,/noplot
;power,'_EMF','hel_EMF',k=k,spec1=spec1E,spec2=spec2E,i=n,tt=t,/noplot
;power,'_Tra','hel_Tra',k=k,spec1=spec1T,spec2=spec2T,i=n,tt=t,/noplot
;power,'_Lor','hel_Lor',k=k,spec1=spec1L,spec2=spec2L,i=n,tt=t,/noplot
;
;  $Id: ppower_all.pro,v 1.23 2022/09/05 03:47:58 brandenb Exp $
;
;  This routine is used to view all power spectra
;  that were written during the run (controlled by dspec)
;  The plot range yr is set to a default value.
;  The time interval of plotting is "w" (default value)
;
;   5-oct-02/axel: written
;
spawn,'if (! -f param.pro) touch parameters.pro'
@parameters
xr=[1,max(k)]
istride=1
default,w,.02
default,t1,.0
default,iover,0
default,lam,.024
default,off,1e-17
default,istride,1
default,yr,[3e-12,3e-2]
ampl15=3e-10 & ampl4=1e-13
ampl15=3e-6 & ampl4=1e-8
;
good=where(t ge t1 and t le t2)
i1=min(good)
i2=max(good)
;
circ_sym,0.8,1
for i=i1,i2,istride do begin
  if iover eq 0 or i eq 0 then begin
    plot_oo,k,spec1(*,i),xr=xr,yr=yr,tit='t='+str(t(i)),/nodata
  endif
  oplot,k,spec1(*,i),col=55
  oplot,k,spec2(*,i),col=122
  oplot,k,spec2(*,i)*(exp(-2*(t[i]-t[i1])*lam))[0],col=155
  oplot,k,k*0+off
  ;oplot,k,spec1L(*,i),col=55
  ;oplot,k,-spec1L(*,i),col=55,thick=8
; oplot,k,abs(spec1L(*,i)),col=188,li=0
; oplot,k,spec1L(*,i),ps=8,col=122
; oplot,k,-spec1L(*,i),ps=8,col=55
; oplot,k,abs(spec2L(*,i)),col=155,li=0
; oplot,k,spec2L(*,i),ps=8,col=122
; oplot,k,-spec2L(*,i),ps=8,col=55
  ;
  ;oplot,k,abs(spec1T(*,i)),col=188,li=0
  ;oplot,k,spec1T(*,i),ps=8,col=122
  ;oplot,k,-spec1T(*,i),ps=8,col=55
; oplot,k,abs(spec2T(*,i)),col=122,li=0
; oplot,k,spec2T(*,i),ps=8,col=122
; oplot,k,-spec2T(*,i),ps=8,col=55
  ;
; oplot,k,abs(spec1h(*,i))/(2.*k),li=2
; oplot,k,abs(spec2h(*,i))*k/2.,li=2,col=122
  kk=[20,180] & oplot,kk,.02/kk^1.66667
  kkk=grange(20.,200.,100)
  kk=[20,180] & oplot,kkk,200./kkk^6
  kk=[1,20] & oplot,kk,.03*ampl15*kk^2.,col=188
  kk=[1,20] & oplot,kk,.1*ampl15*kk^1.5,col=188
  kk=[1,20] & oplot,kk,.003*ampl15*kk^2.,col=188
  kk=[1,20] & oplot,kk,.01*ampl15*kk^1.5,col=188
  kk=[1,20] & oplot,kk,.001*ampl15*kk^2;,col=188
  ;kk=[1,5] & oplot,kk,ampl4*kk^4,col=55
  print,i,t(i)
  wait,w
end
;
print,'E_K (white), E_M (red), E_T (yellow)'
;
; averages
;
pc_read_kf,kf
ngood=n_elements(good)
nk=n_elements(k)
comp=spread(exp(-2*t[i1:i2]*lam),[0],[nk])
mspec1=total(spec1(*,i1:i2),2)/ngood
mspec2=total(comp*spec2(*,i1:i2),2)/ngood
;mspec1h=total(spec1h(*,i1:i2),2)/ngood
;mspec2h=total(comp*spec2h(*,i1:i2),2)/ngood
;mspec1L=total(comp*spec1L(*,i1:i2),2)/ngood
;mspec2L=total(comp*spec2L(*,i1:i2),2)/ngood
;
;  compute mean epsK and epsM
;
pc_read_ts,o=ts
good=where(ts.t ge t1)
epsK=mean(ts.epsK(good))
epsM=mean(ts.epsM(good))
;
pc_read_param,o=param,/param2
eta=param.eta
nu=param.nu
;
;save,file='mean_spec.sav',k,kf,epsK,epsM,nu,eta,mspec1,mspec2,mspec1h,mspec2h;,mspec1L,mspec2L
save,file='mean_spec.sav',k,kf,mspec1,mspec2
spawn,'cvs add -kb mean_spec.sav'
;
END
