;$Id: pkaz_all.pro,v 1.6 2022/09/18 15:07:07 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=12,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
!p.charsize=1.7
!x.margin=[7.3,.3]
!y.margin=[3.2,.3]
;
kf=1.54
fact=sqrt(4.*!pi)
fact2=sqrt(3./8.)
xrfit=[3d-2,14.]*fact*fact2
yrfit=[2d-10,1e-1]
!x.title='!8k!6/!8k!s!7!dg!n!6!r!uKA!n'
!y.title='!8E!6!dM!n(!8k!6) / !13E!6!dM!n'
;
dir='D512_Pm100a'
lamtilde=.076 & Ma=.096 & eta=5e-5 & s=1. & sk=1.
restore,'../'+dir+'/mean_spec.sav'
gam=lamtilde*Ma*kf
ketaKA=sqrt(4./15.*gam/eta)
;ketaKAc=sqrt(.1*gam/eta)
plot_oo,k[1:*]/ketaKA,mspec2[1:*]/total(mspec2),xr=xrfit,yr=yrfit
print,ketaKA,ketaKA/1.68,sk,gam
;
dir='D512_Pm40a'
lamtilde=.090 & Ma=.113 & eta=5e-5 & s=1.05 & sk=1.
restore,'../'+dir+'/mean_spec.sav'
gam=lamtilde*Ma*kf
ketaKA=sqrt(4./15.*gam/eta)
ketaKAc=sqrt(.1*gam/eta)
oplot,k[1:*]/ketaKA,s*mspec2[1:*]/total(mspec2),col=55
print,ketaKA,ketaKA/1.68,sk,gam
;
dir='D512_Pm20a'
lamtilde=.110 & Ma=.120 & eta=5e-5 & s=1.3 & sk=1.05
restore,'../'+dir+'/mean_spec.sav'
gam=lamtilde*Ma*kf
ketaKA=sqrt(4./15.*gam/eta)
ketaKA2=sk*sqrt(4./15.*gam/eta)
oplot,k[1:*]/ketaKA2,s*mspec2[1:*]/total(mspec2),col=155
print,ketaKA,ketaKA/1.68,sk,gam
;
dir='D512_Pm10a'
lamtilde=.135 & Ma=.127 & eta=5e-5 & s=1.7 & sk=1.1
restore,'../'+dir+'/mean_spec.sav'
gam=lamtilde*Ma*kf
ketaKA=sqrt(4./15.*gam/eta)
ketaKA2=sk*sqrt(4./15.*gam/eta)
oplot,k[1:*]/ketaKA2,s*mspec2[1:*]/total(mspec2),col=122
print,ketaKA,ketaKA/1.68,sk,gam
;
dir='D512_Pm4a'
lamtilde=.159 & Ma=.130 & eta=5e-5 & s=2.5 & sk=1.3
restore,'../'+dir+'/mean_spec.sav'
gam=lamtilde*Ma*kf
ketaKA=sqrt(4./15.*gam/eta)
ketaKA2=sk*sqrt(4./15.*gam/eta)
;oplot,k[1:*]/ketaKA2,s*mspec2[1:*]/total(mspec2),col=188
print,ketaKA,ketaKA/1.68,sk,gam
;
amplfit=.2 & s=1.68
kk=grange(xrfit[0],xrfit[1],100,/log)
oplot,fact2*fact*kk,amplfit*kk^1.5*beselk(s*kk),li=1
snew=s/(fact2*fact) & print,'snew=',snew
;
siz=1.6 & s=7.0
xx=fact*.1 & dx=xx & yy=4e-5
legend,xx,dx,yy,0,'!6Pr!dM!n=100',siz=siz
legend,xx,dx,yy/s,0,'!6Pr!dM!n=40',siz=siz,col=55
legend,xx,dx,yy/s^2,0,'!6Pr!dM!n=20',siz=siz,col=155
legend,xx,dx,yy/s^3,0,'!6Pr!dM!n=10',siz=siz,col=122
;
print,"$mv idl.ps ~/GitHub/Axel/keta/fig/pkaz_all.eps"
END
