;$Id: peps.pro,v 1.5 2022/06/19 02:41:24 brandenb Exp $
;
;  calculate dissipation rates
;
pc_read_ts,obj=ts
tt=ts.t
urms=ts.urms
brms=ts.brms
uJxBm=-ts.uJxBm
nt=n_elements(tt)
;
pc_read_param,obj=param,/param2
eta=param.eta
nu=param.nu
cwd,Run
;
spawn,'touch parameters.pro'
@parameters
;
;  setting defaults
;
default,kf,4.
default,t1,0.
default,t1b,0.
default,t2,9e9
default,filename_epsKM,'pepsKM_ssdy.dat'
;
good=where(tt ge t1b and tt le t2)
good2=where(tt le t2)
urms0=mean(urms(good))
brms0=mean(brms(good))
uJxBm0=mean(uJxBm(good))
it1=min(good)
it2=nt-1
;
s=urms0*kf
;
epsK=ts.epsK
epsM=ts.epsM
epsT=epsK+epsM
epsKT=epsK/epsT
epsMT=epsM/epsT
;
!p.multi=[0,3,2]
!p.charsize=2
;
;  individual and total dissipation rates
;
plot,tt,epsK,yr=minmax(epsK(good2))
pc_error_range,tt(good),epsK(good),mean=epsKm,error=epsKe,/oplot
;
plot,tt,epsM,yr=minmax(epsM(good2))
pc_error_range,tt(good),epsM(good),mean=epsMm,error=epsMe,/oplot
;
plot,tt,epsT,yr=minmax(epsT(good2))
pc_error_range,tt(good),epsT(good),mean=epsTm,error=epsTe,/oplot
;
;  ratios
;
plot,tt,epsKT,yr=minmax(epsKT(good2))
pc_error_range,tt(good),epsKT(good),mean=epsKTm,error=epsKTe,/oplot
;
plot,tt,epsMT,yr=minmax(epsMT(good2))
pc_error_range,tt(good),epsMT(good),mean=epsMTm,error=epsMTe,/oplot
;
plot,tt,brms,yr=minmax(brms(good2))
;plot,tt,urms,yr=minmax(urms(good2))
;pc_error_range,tt(good),epsMT(good),mean=epsMTm,error=epsMTe,/oplot
;
knu=(epsKm/nu^3)^.25
keta=(epsMm/eta^3)^.25
print,'knu,keta=',knu,keta
;
Rm=urms0/(eta*kf)
delt=s*(tt(it2)-tt(it1))
print,'Rm,delt=',Rm,delt
;
; open output file
;
dirname='~/tex/mhd/alpha_lopm/idl/'
dirname='~/tex/procs/tatry10/idl/'
dirname='~/tex/mhd/eps_vs_Prandtl/idl/'
dirname='~/tex/mhd/LSeps_vs_Prandtl/idl/'
;
fo='(2e8.1,e8.1,2f7.3,6e9.2,f7.1,f7.1,e9.2,2x,a)'
openw,1,'../'+filename_epsKM
print,nu,eta,urms0
;printf,1,nu,eta,nu/eta,urms0,brms0,epsTm,epsTe,epsKTm,epsKTe,epsMTm,epsMTe,knu,keta,Run,fo=fo
printf,1,nu,eta,nu/eta,urms0,brms0,epsTm,epsTe,epsKTm,epsKTe,epsMTm,epsMTe,knu,keta,uJxBm0,Run,fo=fo
close,1
;
print,'cat ../'+filename_epsKM+' >> '+dirname+filename_epsKM
spawn,'cat ../'+filename_epsKM+' >> '+dirname+filename_epsKM
;
print,'gt ',dirname
print,'vi ',filename_epsKM
!p.multi=0
END
