;$Id: pdiss.pro,v 1.6 2011/09/26 07:16:40 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=18,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
;  mv idl.ps ~/tex/mhd/ssdyn/fig/pdiss.ps
;  mv idl.ps ~/tex/mhd/ssdyn/fig/pdiss_512_Pm001a.ps
;
;  to be executed in directories 512_Pm002a and 512_Pm001a.
;
!p.charsize=3.3
!x.margin=[8.8,.5]
!y.margin=[3.2,.2]
!p.multi=[0,1,3]
!x.title='!6'
!x.range=0
!y.range=0
;
@parameters
pc_read_kf,kf
pc_read_ts,o=ts
pc_read_param,o=param,/param2
tt=ts.t
;
;  parameters
;
nu=param.nu
eta=param.eta
;
default,t1,0.
good=where(tt ge t1)
tgood=tt(good)
;
BBeq=ts.brms/ts.urms
pc_error_range,tt(good),ts.urms(good),mean=urmsm,err=urmse
pc_error_range,tt(good),ts.brms(good),mean=brmsm,err=brmse
pc_error_range,tt(good),BBeq(good),mean=BBeqm,err=BBeqe
;
;  ratios
;
epsK=ts.epsK
epsM=ts.epsM
epsT=epsK+epsM
epsKT=epsK/epsT
epsMT=epsM/epsT
;
epsKm=mean(epsK)
epsMm=mean(epsM)
;
knu=nint((epsKm/nu^3)^.25)
keta=nint((epsMm/eta^3)^.25)
;
urms1D=urmsm/sqrt(3.)
ell=3.*!pi/(4.*kf)
eps0=urms1D^3/ell
eps0max=max(eps0)
;
pc_error_range,tt(good),epsMT(good),mean=epsMTm,err=epsMTe
pc_error_range,tt(good),epsKT(good),mean=epsKTm,err=epsKTe
pc_error_range,tt(good),epsT(good)/eps0,mean=epsTm,err=epsTe
;
;  Reynolds and Prandtl numbers
;
Pm=nu/eta
Re=nint(urmsm/(nu*kf))
Rm=nint(urmsm/(eta*kf))
ttt=tt*urmsm*kf
;
!y.title='!8U!6!drms!n/!8c!6!ds!n'
plot,ttt,ts.urms,yst=3
;
!y.title='!6<!8B!6!u2!n>/!8B!6!s!u2!n!r!deq!n'
plot_io,ttt,BBeq^2,li=1
oplot,ttt,ts.brms^2/urmsm^2
;
!x.title='!8t U!6!drms!n!8k!6!df!n!6'
!y.title='!7e!6!dM!n/!7e!6!dK!n'
;plot_io,ttt,ts.epsM/mean(ts.epsK(good)),yr=minmax([ts.epsM/mean(ts.epsK(good)),ts.epsM/ts.epsK]),yr=[1,20]
plot_io,ttt,ts.epsM/mean(ts.epsK(good)),yr=[1,20]
oplot,ttt,ts.epsM/ts.epsK,li=1
;
!p.multi=0
END
