;$Id: pdiag_spec.pro,v 1.29 2022/08/28 08:26:37 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=12,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
!p.charsize=1.7
!x.margin=[9.4,.5]
!y.margin=[3.2,.5]
!x.title='!8k!6/!8k!7!dm!n!6'
!y.title='!6Sp(!8E!6), Sp(!8B!6), and Sp(!8B!dz!n!6)'
!y.title='!6Sp(!8E!6), Sp(!8B!6), and Sp(RM)'
;
default,dust,''
@parameters
restore,dust+'ebk_VAR'+str(ivar)+'.sav'
restore,'bzk_VAR'+str(ivar)+'.sav'
print,'s=',s
restore,'bzcoarse_VAR'+str(ivar)+'.sav'
print,'s=',s
cwd,run
;
!x.range=[1e-3,8.6]
;
if run eq 'D1024_Pm1e_kf120' then begin ;  for Run A
  if ivar eq 3 then begin
    knu1=763.533  ;(for Run A, i.e., D1024_Pm1e_kf120)
    !y.range=[8e-6,2e-1]
  endif else begin
    knu1=718.
    !y.range=[3e-7,6e-2]
  endelse
endif
;
if run eq 'D1024_Pm1d_kf30' then begin ;  for Run B
  if ivar eq 7 then begin
    knu1=388.857 & knu2=328.292  ;(for Run B, i.e., D1024_Pm1d_kf30)
    !y.range=[1e-5,1.7e-1]
  endif else begin
    knu1=388.857 & knu2=328.292  ;(for Run B, i.e., D1024_Pm1d_kf30)
    !y.range=[1e-5,6e-2]
  endelse
endif
;
if run eq 'D1024_Pm10a_kf10' then begin ;  for Run C
  knu1=105.578  ;(for Run C, i.e., D1024_Pm10a_kf10)
  !y.range=[1e-6,5e-2]
endif
;
if run eq 'D1024_Pm30a_kf4' then begin ;  for Run D
  if ivar eq 14 then begin
    knu1=50.
    if dust eq '' then begin
      !y.range=[3e-8,2e0]
    endif else begin
      !y.range=[3e-8,2e0]
    endelse
  endif else begin
    knu1=62.2712  ;(for Run D, i.e., D1024_Pm30a_kf4)
    if dust eq '' then begin
      !y.range=[3e-7,1e-1]
    endif else begin
      !y.range=[2e-6,2e-1]
    endelse
  endelse
endif
;
if run eq 'D1024_Pm1c_kf4' then begin ;  for Run E
  if ivar eq 16 then begin
    knu1=331.
    if dust eq 'DUST_' then begin
      !y.range=[2e-8,1e-0]
    endif else begin
      !y.range=[2e-8,5e-1]
    endelse
  endif else begin
    knu1=460.655 & knu2=460.655  ;(for Run E, i.e., D1024_Pm1c_kf4)
    if dust eq 'DUST_' then begin
      !y.range=[3e-5,1e-1]
    endif else begin
      !y.range=[3e-5,2e-2]
    endelse
  endelse
endif
;
!p.multi=[0,2,1]
!p.multi=0
s=1./total(bzk)
plot_oo,k[1:*]/knu1,s*bzk[1:*]
s=1./total(bzk)
oplot,k[1:*]/knu1,s*bzk[1:*],li=1
s=1./total(Ek+Bk)
;plot_oo,k[1:*],s*Ek[1:*],/nodata
oplot,k/knu1,s*Ek,col=55
oplot,k/knu1,s*Bk,col=122
;xx=[4.,30.] & oplot,xx,1e-3*xx,li=3
;
good1=where((k/knu1) le .14)
good2=where((k/knu1) ge .14)
B2LS=total(Bk(good1)) & E2LS=total(Ek(good1))
B2SS=total(Bk(good2)) & E2SS=total(Ek(good2))
print,'qLS,qSS=',E2LS/B2LS,E2SS/B2SS
;
siz=1.4
;xyouts,8.,1.4e-2,siz=siz,'!9A!8k!6'
;
if run eq 'D1024_Pm1e_kf120' then begin ;  for Run A
  if ivar eq 3 then begin
    xyouts,.030,5e-3,siz=siz,'Sp(RM)'
    xyouts,.003,1.4e-3,siz=siz,'Sp(!8E!6)',col=55
    xyouts,.200,1e-4,siz=siz,'Sp(!8B!6)',col=122
    xx=[.015,.08] & oplot,xx,1e-2*xx,li=3
    xyouts,.04,2e-4,siz=siz,'!9A!8k!6'
    ;
    knu1=718.
    epsK1=0.0072
    kf=120.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm1e_kf120'
    restore,'../'+dir+'/mean_spec.sav'
    oplot,k/knu1,s1*1.22e1*mspec2/k,li=1
    ;
  endif else begin
    xyouts,.025,1e-4,siz=siz,'Sp(RM)'
    xyouts,.0013,3.0e-3,siz=siz,'Sp(!8E!6)',col=55
    xyouts,.0013,5e-5,siz=siz,'Sp(!8B!6)',col=122
    xx=[.004,.025] & oplot,xx,8.7e-2*xx,li=3
    xyouts,.007,1.4e-3,siz=siz,'!9A!8k!6'
    ;xx=[.032,.15] & oplot,xx,7.2e-2*xx^.5,li=3
    ;xyouts,.050,2.2e-2,siz=siz,'!8k!6!u1/2!n'
    xx=[.006,.02] & oplot,xx,1.0e+1*xx^3,li=3
    xyouts,.0097,3.4e-6,siz=siz,'!8k!6!u3!n'
    ;
    knu1=763.533
    epsK1=0.00917672
    kf=120.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm1e_kf120'
    restore,'../'+dir+'/mean_spec_kin.sav'
    oplot,k/knu1,s1*1.6e18*mspec2/k,li=1
    ;
  endelse
endif
;
if run eq 'D1024_Pm1d_kf30' then begin ;  for Run B
  if ivar eq 7 then begin
    xyouts,.003,2e-4,siz=siz,'Sp(RM)'
    xyouts,.004,5.4e-3,siz=siz,'Sp(!8E!6)',col=55
    xyouts,.11,9e-5,siz=siz,'Sp(!8B!6)',col=122
    xx=[.008,.05] & oplot,xx,7e-2*xx,li=3
    xyouts,.02,7e-4,siz=siz,'!9A!8k!6'
    ;
    knu1=328.
    epsK1=0.0015
    kf=30.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm1d_kf30'
    restore,'../'+dir+'/mean_spec.sav'
    oplot,k/knu1,s1*2.8e0*mspec2/k,li=1
    ;
  endif else begin
    xyouts,.010,2e-4,siz=siz,'Sp(RM)'
    xyouts,.900,5.4e-4,siz=siz,'Sp(!8E!6)',col=55
    xyouts,.170,9e-5,siz=siz,'Sp(!8B!6)',col=122
    ;
    knu1=388.857
    epsK1=0.00285827
    kf=30.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm1d_kf30'
    restore,'../'+dir+'/mean_spec_kin.sav'
    oplot,k/knu1,s1*6e20*mspec2/k,li=1
    ;
  endelse
endif
;
if run eq 'D1024_Pm10a_kf10' then begin ;  for Run C
  xyouts,.030,1e-3,siz=siz,'Sp(RM)'
  xyouts,2.00,8.0e-4,siz=siz,'Sp(!8E!6)',col=55
  xyouts,.280,1.0e-4,siz=siz,'Sp(!8B!6)',col=122
  ;
  knu1=105.578
  epsK1=0.000994120
  kf=10.
  s1=kf^1.6667/epsK1^.6667
  dir='D1024_Pm10a_kf10'
  restore,'../'+dir+'/mean_spec_kin.sav'
  oplot,k/knu1,s1*7e21*mspec2/k,li=1
  ;
endif
;
if run eq 'D1024_Pm30a_kf4' then begin ;  for Run D
  if ivar eq 14 then begin
    xyouts,.023,4e-3,siz=siz,'Sp(RM)'
    xyouts,.300,8.0e-4,siz=siz,'Sp(!8E!6)',col=55
    xyouts,.027,3.0e-1,siz=siz,'Sp(!8B!6)',col=122
    ;
    knu1=50.
    epsK1=0.00017
    kf=4.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm30a_kf4'
    restore,'../'+dir+'/mean_spec_sat.sav'
    oplot,k/knu1,s1*2.6e-0*mspec2/k,li=1
    print,s1*1e-2*mspec2/k
    ;
  endif else begin
    xyouts,.023,1e-3,siz=siz,'Sp(RM)'
    if dust eq '' then begin
      xyouts,.700,9.0e-4,siz=siz,'Sp(!8E!6)',col=55
      xyouts,.530,2.0e-5,siz=siz,'Sp(!8B!6)',col=122
    endif else begin
      xyouts,.008,6.4e-3,siz=siz,'Sp(!8E!6)',col=55
      xyouts,.012,4.0e-2,siz=siz,'Sp(!8B!6)',col=122
    endelse
    ;
    knu1=62.2712
    epsK1=0.000406349
    kf=4.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm30a_kf4'
    restore,'../'+dir+'/mean_spec_kin.sav'
    oplot,k/knu1,s1*1e23*mspec2/k,li=1
    ;
  endelse
endif
;
if run eq 'D1024_Pm1c_kf4' then begin ;  for Run E
  if ivar eq 16 then begin
    if dust eq 'DUST_' then begin
      xyouts,.0050,7.0e-3,siz=siz,'Sp(!8E!6)',col=55
      xyouts,.0035,1.5e-1,siz=siz,'Sp(!8B!6)',col=122
    endif else begin
      xyouts,.100,1.8e-4,siz=siz,'Sp(!8E!6)',col=55
      xyouts,.020,3e-4,siz=siz,'Sp(!8B!6)',col=122
    endelse
    xyouts,.100,1.0e-2,siz=siz,'Sp(RM)'
    ;
    knu1=331.
    epsK1=0.000096
    kf=4.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm1c_kf4'
    restore,'../'+dir+'/mean_spec.sav'
    oplot,k/knu1,s1*2.0e0*mspec2/k,li=1
    ;
  endif else begin
    if dust eq 'DUST_' then begin
      xyouts,.080,2.0e-2,siz=siz,'!8k!6!u1/2!n'
      xyouts,.020,1.0e-3,siz=siz,'Sp(!8E!6)',col=55
      xyouts,.0022,9e-3,siz=siz,'Sp(!8B!6)',col=122
    endif else begin
      xyouts,.020,1.0e-2,siz=siz,'!8k!6!u1/2!n'
      xyouts,.003,1.8e-4,siz=siz,'Sp(!8E!6)',col=55
      xyouts,.0026,9e-3,siz=siz,'Sp(!8B!6)',col=122
    endelse
    xyouts,.180,8e-3,siz=siz,'Sp(RM)'
    xx=[.012,.08] & oplot,xx,5.2e-2*xx^.5,li=3
    ;xx=[.021,.05] & oplot,xx,3.6e-2*xx,li=3
    ;xyouts,.040,1.4e-3,siz=siz,'!8k!6!u1/2!n'
    ;
    knu1=460.655
    epsK1=0.000360403
    kf=4.
    s1=kf^1.6667/epsK1^.6667
    dir='D1024_Pm1c_kf4'
    restore,'../'+dir+'/mean_spec_kin.sav'
    oplot,k/knu1,s1*6.5e30*mspec2/k,li=1
    ;
  endelse
endif
;
!p.multi=0
cwd,run
print,'ivar=',ivar
print,"$mv idl.ps ~/GitHub/Axel/Kazantsev-Subinertial/fig/pdiag_spec.eps"
print,"$mv idl.ps ~/GitHub/Axel/Kazantsev-Subinertial/fig/pdiag_spec_"+dust+run+".eps"
print,"$mv idl.ps ~/GitHub/Axel/Kazantsev-Subinertial/fig/pdiag_spec_"+dust+run+"_sat.eps"
END
