@parameters
!p.multi=[0,1,2]
;
pc_read_kf,kf
pc_read_ts,o=ts
pc_read_param,o=param,/param2
t=ts.t
urms=ts.urms
brms=ts.brms
;
good=where(ts.t ge t1 and ts.t le t2)
tgood=ts.t(good)
;
default,manual,0
if not manual then begin
  nu=param.nu
  eta=param.eta
endif
;
knu=(ts.epsK/nu^3)^.25
urmsm=mean(urms(good)^2)^.5
knum=mean(ts.epsK(good)/nu^3)^.25
plot,ts.t,knu,ytit='knu'
epsKm=nu^3*knum^4
oplot,tgood,tgood*0+knum,li=2
;
lam=deriv(t,alog(brms))
lamm=mean(lam(good)) & print,'lam,lam/urms*kf=',lamm,lamm/(urmsm*kf)
Re=urmsm/(nu*kf)
Rm=urmsm/(eta*kf)
Pm=nu/eta
print,'urmsm,Re,Rm,Pm=',urmsm,Re,Rm,Pm
;
plot,t,lam,ytit='gam',yr=[0.,2*lamm]
oplot,tgood,tgood*0+lamm,col=122
;
!p.multi=0
cwd,run
fo="(a,' &', f6.3, ' &', i5, ' &', i5, ' &', f7.2, ' &', f7.3, ' &', f6.1, ' &     \\% ',a)"
print,label,urmsm,Re,Rm,Pm,lamm/(urmsm*kf),knum,run,fo=fo
end


