;$Id: p.pro,v 1.13 2022/07/10 14:19:37 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=18,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
;  mv idl.ps ~/tex/mhd/ssdyn/fig/pspec.ps
;
!p.charsize=1.7
!x.margin=[8.8,.5]
!y.margin=[3.2,.2]
!x.range=0
!y.range=0
!p.multi=[0,1,2]
;
@parameters
pc_read_kf,kf
pc_read_ts,obj=ts
pc_read_dim,obj=dim
pc_read_param,obj=param,/param2
tt=ts.t
;
;  parameters
;
nu=param.nu
eta=param.eta
nx=dim.nx
;
!p.multi=[0,1,2]
;
default,t1,0.
default,t2,1e4
good=where(tt ge t1 and tt le t2)
tgood=tt(good)
;
brms=ts.brms
urms=ts.urms
BBeq=brms/urms
pc_error_range,tt(good),urms(good),mean=urmsm,err=urmse
pc_error_range,tt(good),brms(good),mean=brmsm,err=brmse
pc_error_range,tt(good),BBeq(good),mean=BBeqm,err=BBeqe
;
;  ratios
;
epsK=ts.epsK
epsM=ts.epsM
epsT=epsK+epsM
epsKM=epsK/epsM
epsKT=epsK/epsT
epsMT=epsM/epsT
;
epsKmean=mean(epsK)
epsMmean=mean(epsM)
;
knu=nint((epsKmean/nu^3)^.25)
keta=nint((epsMmean/eta^3)^.25)
;
urms1D=urmsm/sqrt(3.)
ell=3.*!pi/(4.*kf)
eps0=urms1D^3/ell
eps0max=max(eps0)
;
pc_error_range,tt(good),epsMT(good),mean=epsMTm,err=epsMTe
pc_error_range,tt(good),epsKT(good),mean=epsKTm,err=epsKTe
pc_error_range,tt(good),epsKM(good),mean=epsKMm,err=epsKMe
pc_error_range,tt(good),epsT(good)/eps0,mean=epsTm,err=epsTe
;
;  Reynolds and Prandtl numbers
;
Pm=nu/eta
Re=nint(urmsm/(nu*kf))
Rm=nint(urmsm/(eta*kf))
;
plot_io,tt,urms,yr=[1e-2,.3]
oplot,tt,brms,col=122
oplot,tgood,tgood*0+urmsm
oplot,tgood,tgood*0+brmsm,li=2
;
plot_io,tt,epsMT,yr=[.05,2]
oplot,tt,epsKT,li=2
oplot,tgood,tgood*0+epsMTm
oplot,tgood,tgood*0+epsKTm,li=2
;
;  write output to table
;
cwd,run
tend=fix(max(tgood))
delt=fix(max(tgood)-min(tgood))
fo='(2e8.1,i6,i5, 3f6.2, e9.2, 2f6.2, 4f6.2, 2i5,2i5,i4,2x,a)'
openw,1,'tmp.dat'
printf,1,fo=fo,nu,eta,Re,Rm,urmsm,BBeqm,BBeqe,epsTm*eps0,epsTm,epsTe,epsKMm,epsKMe,epsMTm,epsMTe,knu,keta,tend,delt,nx,run
close,1
;
spawn,'cat tmp.dat >> ../idl/eps.dat'
spawn,'cat tmp.dat'
;
save,file='n.sav',tt,brms,urms,epsK,epsM,urmsm,kf,Re,Rm
!p.multi=0
END
