# INDI-README

## Brief summary

iPSC Neurodegenerative Disease Initiative
Researchers have identified more than 50 regions of the genome (called loci) that contain variants that may increase risk for the disease. To develop effective treatments for Alzheimer’s and related dementias, we must identify how individual mutations impact cellular pathways and contribute to Alzheimer’s and related dementias pathology. However, this requires readily available, disease-relevant cellular models of Alzheimer’s and related dementias and phenotypic datasets of the effects of gene mutations on cellular pathways, which are not currently available in the field.

We will create a foundational repository of isogenic induced pluripotent stem cell (iPSC) lines using CRISPR/Cas9-based genetic engineering. Our target goals are 134 variants across 73 AD/ADRD genes, 8 of which are known AD-related genes, 15 are genes linked to Dementia with Lewy Bodies/Parkinson’s Disease, 29 genes are associated with Frontotemporal Dementia/Amyotrophic Lateral Sclerosis, and 21 are genes associated with other neurodegenerative disorders.

For each gene variant, we plan to engineer:

- Heterozygous clones for the disease-associated single nucleotide variant (SNV)
- Homozygous clones for the disease-associated SNV
- Revertant clones
- Gene knockout clones
- Halotag SNV and gene knock-in clones


## Publications

- Ramos et al 2021, Neuron [here](https://pubmed.ncbi.nlm.nih.gov/33831364/)

## Graphical overview

![alt text](https://github.com/NIH-CARD/INDI-README/blob/main/Figures/Ramos%20et%20al%202021.jpg)

## Overview of this code repo

1. iNDI genetics for KOLF2.1 manuscript (https://github.com/NIH-CARD/INDI-README/tree/main/INDI-genetics)
    1. Clinvar analyses INDI lines
    2. Genetic risk score analysis of INDI lines
    3. Genomic alteration analysis of INDI lines
2. NBA Genotyping processing
   1. Analyses for array-based genotyping of iNDI clones

## Contact details

For more information or questions please email:
- Caroline Pantazis (Project manager)
- Mark Cookson (INDI-PI)
- Michael Ward (INDI-PI)




