#Neutrophil_DESeq2.R

Neutrophil_DESeq2 <- function(counts,mdata,covid = NULL,day = NULL,severity = NULL,acuity = NULL,cluster = NULL){
  coldata <- mdata
  if (is.null(covid) == FALSE){
    coldata <- coldata[coldata$COVID %in% covid,]
  }
  if (is.null(day) == FALSE){
    coldata <- coldata[coldata$Day %in% day,]
  }
  if (is.null(severity) == FALSE){
    coldata <- coldata[coldata$severity.max %in% severity,]
  }
  if (is.null(acuity) == FALSE){
    coldata <- coldata[coldata$Acuity.max %in% acuity,]
  }
  if (is.null(cluster) == FALSE){
    coldata <- coldata[coldata$cluster_neuhi %in% cluster,]
  }
  
  Count_select <- Count_filtered[,which(colnames(Count_filtered) %in% coldata$Public.Sample.ID)]
  logTPM_select <- logTPM_filtered[,which(colnames(logTPM_filtered) %in% coldata$Public.Sample.ID)]
  Count_rounded <- round(Count_select)

  coldata$T_NK_factor <- cut_number(as.numeric(coldata$T_NK), n = 5)
  coldata$T_NK_factor <- mapvalues(coldata$T_NK_factor, from = c(levels(coldata$T_NK_factor)[1],levels(coldata$T_NK_factor)[2],levels(coldata$T_NK_factor)[3],levels(coldata$T_NK_factor)[4],levels(coldata$T_NK_factor)[5]), to = c("lowest","low","mid","high","highest"))
  coldata$Monocyte_factor <- cut_number(coldata$Monocyte, n = 5)
  coldata$Monocyte_factor <- mapvalues(coldata$Monocyte_factor, from = c(levels(coldata$Monocyte_factor)[1],levels(coldata$Monocyte_factor)[2],levels(coldata$Monocyte_factor)[3],levels(coldata$Monocyte_factor)[4],levels(coldata$Monocyte_factor)[5]), to = c("lowest","low","mid","high","highest"))
  coldata$Plasmablast_factor <- cut_number(coldata$Plasmablast, n = 5)
  coldata$Plasmablast_factor <- mapvalues(coldata$Plasmablast_factor, from = c(levels(coldata$Plasmablast_factor)[1],levels(coldata$Plasmablast_factor)[2],levels(coldata$Plasmablast_factor)[3],levels(coldata$Plasmablast_factor)[4],levels(coldata$Plasmablast_factor)[5]), to = c("lowest","low","mid","high","highest"))
  if ("IG.score" %in% colnames(coldata)){
    coldata$IG_factor <- cut_number(coldata$IG.score, n = 5)
    coldata$IG_factor <- mapvalues(coldata$IG_factor, from = c(levels(coldata$IG_factor)[1],levels(coldata$IG_factor)[2],levels(coldata$IG_factor)[3],levels(coldata$IG_factor)[4],levels(coldata$IG_factor)[5]), to = c("lowest","low","mid","high","highest"))
  }

  coldata$severity.max <- factor(coldata$severity.max, levels = c("non-severe","severe"))
  coldata$Acuity.max <- factor(coldata$Acuity.max)
  coldata$COVID <- factor(coldata$COVID)
  coldata$Day <- factor(coldata$Day)
  coldata$Trop_72h <- factor(coldata$Trop_72h)
  # coldata$Age <- factor(coldata$Age)
  # coldata$sex <- factor(coldata$sex)
  # coldata$ethnicity <- factor(coldata$ethnicity)
  # coldata$Heart.condition <- factor(coldata$Heart.condition)
  # coldata$Diabetes <- factor(coldata$Diabetes)
  # coldata$HTN <- factor(coldata$HTN)
  # coldata$HLD <- factor(coldata$HLD)
  # coldata$Lung.condition <- factor(coldata$Lung.condition)
  # coldata$Kidney.condition <- factor(coldata$Kidney.condition)
  # coldata$Immuno <- factor(coldata$Immuno)
  coldata$cluster_neuhi <- factor(coldata$cluster_neuhi)

  my_list <- list("coldata" = coldata, "Count_select" = Count_rounded, "logTPM_select" = logTPM_select)
  return(my_list)
}