function ml_citation()
% ML_CITATION Generates bilbiography text and BibTeX entry for MORLAB.
%
% SYNTAX:
%   ML_CITATION()
%
% DESCRIPTION:
%   This function generates the bibliography text and BibTeX entry for the
%   currently used MORLAB version. This is the recommended form of citing
%   this software.
%
% INPUTS:
%   ---
%
% OUTPUTS:
%   ---
% 
% See also ml_version, morlab, ml_morlabopts.

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

fprintf(1, 'Cite this software as:\n');
fprintf(1, '----------------------\n');

fprintf(1, ['P. Benner, J. Saak, and S. W. R. Werner. ' ...
    'MORLAB – Model Order Reduction\nLABoratory (version 6.0), ' ...
    'September 2023.\n' ...
    'See also: https://www.mpi-magdeburg.mpg.de/projects/morlab.\n' ...
    'doi:10.5281/zenodo.7072831\n']);
fprintf(1, '\n');

fprintf(1, 'BibTeX:\n');
fprintf(1, '-------\n');
fprintf(1, ['@MISC{BenSW23,\n' ...
  '  author = {Benner, P. and Saak, J. and Werner, S.~W.~R.},\n' ...
  '  title  = {{MORLAB} -- {Model Order Reduction LABoratory} ' ...
  '(version 6.0)},\n' ...
  '  year   = {2023},\n' ...
  '  month  = sep,\n' ...
  '  doi    = {10.5281/zenodo.7072831},\n' ...
  '  note   = {See also: \\url{https://www.mpi-magdeburg.mpg.de/' ...
  'projects/morlab}}\n' ...
  '}\n']);
fprintf(1, '\n');
