function [] = ml_assert_stdsys(sys)
%ML_ASSERT_STDSYS Checks if a given structure is a standard system.
%
% SYNTAX:
%   ML_ASSERT_STDSYS(sys)
%
% DESCRIPTION:
%   This function checks if a given structure is a standard system with
%   appropriate matrices and dimensions and throws an error if not.
%
% INPUTS:
%   sys - structure, which shall be checked
%
% OUTPUTS:
%   ---
%
% See also ml_assert_descsys, ml_assert_infdescsys.

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

narginchk(1, 1);

assert(isa(sys, 'struct'), ...
    'MORLAB:data', ...
    'The parameter sys has to be a struct!');

assert(isfield(sys, 'A'), ...
    'MORLAB:data', ...
    'The system must have an A matrix!');

n = size(sys.A, 1);

assert(isequal(size(sys.A), [n n]), ...
    'MORLAB:data', ...
    'The matrix A has to be square!');

assert(isfield(sys, 'B'), ...
    'MORLAB:data', ...
    'The system must have an B matrix!');

assert(size(sys.B, 1) == n, ...
    'MORLAB:data', ...
    'The matrix B must have the same number of rows as A!');

assert(isfield(sys, 'C'), ...
    'MORLAB:data', ...
    'The system must have an C matrix!');

assert(size(sys.C, 2) == n, ...
    'MORLAB:data', ...
    'The matrix C must have the same number of columns as A!');
