function [] = ml_assert_nonnegscalar(value, name)
%ML_ASSERT_NONNEGSCALAR Checks if a value is a nonnegative, real scalar.
%
% SYNTAX:
%   ML_ASSERT_NONNEGSCALAR(value)
%   ML_ASSERT_NONNEGSCALAR(value, name)
%
% DESCRIPTION:
%   This function checks if a given value is a real, nonnegative scalar
%   value and throws an error if not.
%
% INPUTS:
%   value - value, which shall be checked
%   name  - character array, used as parameter name in error handling
%
% OUTPUTS:
%   ---
%
% See also ml_assert_nonnegint, ml_assert_scalar.

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

narginchk(1, 2);

if nargin < 2
    name = '';
else
    assert(ischar(name), ...
        'MORLAB:data', ...
        'The name of the parameter must consist of characters.');

    name = [' ' name];
end

ml_assert_scalar(value, name);

assert(value >= 0, ...
    'MORLAB:data', ...
    'The parameter%s must be nonnegative.', ...
    name);
