function [] = ml_assert_descsys(sys)
%ML_ASSERT_DESCSYS Checks if a given structure is a descriptor system.
%
% SYNTAX:
%   ML_ASSERT_DESCSYS(sys)
%
% DESCRIPTION:
%   This function checks if a given structure is a descriptor system with
%   appropriate matrices and dimensions and throws an error if not.
%
% INPUTS:
%   sys - structure, which shall be checked
%
% OUTPUTS:
%   ---
%
% See also ml_assert_infdescsys, ml_assert_stdsys.

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

narginchk(1, 1);

ml_assert_stdsys(sys);

assert(isfield(sys, 'E'), ...
    'MORLAB:data', ...
    'The system must have an E matrix!');

assert(isequal(size(sys.E), size(sys.A)), ...
    'MORLAB:data', ...
    'The matrix E must have the same dimensions as A!');
