Contributing
============

When contributing to this project, please note the following style
conventions that are enforced.


## MORLAB Style Guide
---------------------

In the codes of the toolbox a special naming and formatting style was
applied, which might be useful to know for further developments and use of
the implemented routines.

For the naming of routines one should know:
  * All function names are lower case and concatenated by underscores.
  * All functions start with an `ml_`.
  * All scripts and data files (non-functions) start with a `morlab_`.
  * The system restriction of the function is stated before the name, e.g.,
    `_ct_d_dss_` for continuous-time dense descriptor systems or 
    `_ct_s_foss_` for sparse first-order state-space systems.
  * The names of equation solver routines are made up the following way:
    `ml_<name of equation>_<method>[_<fac>]`, where the underlying method
    is abbreviated, e.g., sgn for sign function iterations or nwt for
    newton iterations. The last term `[_<fac>]` is optional and indicates
    that the solution is computed in factorized forms Z*Z' or L*D*L'.

For variables one should know:
  * For the entries of structs it holds:
      - Simple data types (scalars, matrices, strings, etc.) are written in
        camelCase beginning with an upper case letter.
      - Structs for inputs are all lower case and typically end with
        `opts`.
      - Structs for outputs are camelCase beginning with an `info` in lower
        case and the corresponding computation routine in all upper case.
  * For other variables it holds:
      - Matrices are written camelCase beginning with an upper letter.
      - All other variables are lower case.


## Maintenance Guide
--------------------

Additionally to the basic naming and formatting, there are some other
rules that have to be followed:
  * Parameters of an algorithm that are non-optional should be placed
    explicitly in the function interface, all other parameters are hidden
    inside the opts struct.
  * For checking certain types of input data, the `ml_assert_` functions
    have to be used.
  * The function interfaces should be as much consistent as possible, e.g.,
    all model reduction function to the same system class have the same
    user interface but different parameters hidden in opts.
  * MORLAB has an option constructor that creates an opts struct for every
    possible MORLAB file, i.e., changes in an existing opts struct
    have also to be made in `ml_morlabopts.m` and for every new file
    (function, script, data) there has to be an entry in `ml_morlabopts.m`
    either creating a suitable opts struct or returning the message that
    there are no options for the requested file.


## Test Framework
-----------------

MORLAB has a unit test framework that is used every time something in the
repository changes. Testing of all functions in MORLAB is enforced,
therefore it is mandatory to write a test file for each new contributed
MORLAB function in the following way:
  * The test file of a function with name `ml_<name>.m` is
    `test_ml_<name>.m` (and it has to be placed in the testing folder
    corresponding to the directory with the function to test).
  * The interface of the function has to be tested as well as the
    functional behavior.
  * If there are examples for the tests generated, these examples have to
    be saved into the file `test_data_ml_<name>.mat`. In case of several
    examples, the data is numbered, e.g., test matrices A1, A2, A3, ...
  * The test function has to expect one input argument that is used as
    on-off switch for the output generation and no output argument.
  * If something is going wrong with the tested function, the test function
    has to throw an error.
