## Version 6.0 (2023-09-24)
---------------------------

New core features:
- license change: licensing has changed from previously AGPLv3+ to the
  BSD-2-Clause license
- new additional copyright holder: Jens Saak has been added to the list of
  copyright holders
- new system classes: sparse first-order continuous- and discrete-time
  systems, sparse second-order continuous-time systems
- new model reduction methods:
  - Krylov subspace methods are available for all system classes
  - BRBT, BST, BT, HNA, HINFBT, LQGBT and PRBT are available for sparse
    continuous-time systems
  - Two-step model reduction methods are implemented for sparse system
    classes to use classical dense routines on sparse systems
- new dependency: for any sparse model reduction with MORLAB, M-M.E.S.S.
  version 3.0 is needed
- new top level routines: top level routines automatically determine the
  system structure and use the appropriately tailored subroutine for
  the reduction, the user only needs to determine if the model is discrete
  or continuous and which model reduction method should be used
- new data types: systems can be given as MATLAB's `sparss` and `mechss`
  objects
- Unstructured and structured MOR: model reduction for second-order systems
  now produces first-order reduced-order models by default; the parameter
  opts.OutputModel can be used to generate structure-preserving models
- new optional parameters `StoreGramians` and `StoreBases` allow to save
  intermediate quanteties  such as low-rank Gramian factors basis matrices
  and can be given back to the model reduction functions to quickly redo
  computations

Inferface changes:
- naming scheme of functions has been changed: functions that are tailored
  towards sparse or dense systems now denote that in their name, e.g.,
  `ml_ct_dss_bt` is now `ml_ct_d_dss_bt`
- all continuous-time model reduction methods have now an interface for
  second-order systems
- renaming of projection bases matrices from `T` to `V`
- option structs for dual matrix equation solvers have been renamed by
  removing the `dl` in the name standing for dual
- opts.ImproperTrunc does not allow for vectorization anymore
- warning identifiers has been changed:
  - `MORLAB:eqn_solver` is now `MORLAB:noConvergence`
  - `MORLAB:subroutine` is now `MORLAB:noConvergence`

Minor changes:
- in all documentation `INPUT` and `OUTPUT` to denote input and output
  argument sections have been renamed to `INPUTS` and `OUTPUTS`
- the function addpath has been upgraded for faster toolbox installation
- sign function Riccati solvers are now the default in higher level matrix
  equation routines
- the computation of modified frequency-limited Gramians has been corrected
- a bug in `ml_dt_d_ss_partstab` leading to wrong unstable dimensions has
  been fixed
- performance of sign function Lyapunov solvers has been improved by
  removing unneccessary inverses of mass matrices
- an indexing error in vp balancing for second-order systems has been
  corrected
- several documentation strings have been fixed
- `ml_verson` function has been added to give the current MORLAB version
  and publication date
- `ml_citation` function to generate the bibliography text when citing
  MORLAB directly in MATLAB/Octave

Removed functions:
- ml_dss_bfsr
- ml_dss_format_output
- ml_dss_lti2struct
- ml_dss_sr
- ml_soss_bfsr
- ml_soss_format_output
- ml_soss_lti2struct
- ml_soss_sr
- ml_ss_bfsr
- ml_ss_format_output
- ml_ss_lti2struct
- ml_ss_sr

Removed demos:
- morlab_demo_mor_continuous_descriptor
- morlab_demo_mor_continuous_second_order
- morlab_demo_mor_continuous_standard
- morlab_demo_mor_discrete_descriptor
- morlab_demo_mor_discrete_standard


## Version 5.0 (2019-08-23)
---------------------------

New core features:
- new system classes: discrete-time standard and descriptor systems
- balanced truncation, LQG balanced truncation and modal truncation for
  discrete-time systems
- additive decomposition and partial stabilization for discrete-time
  systems
- new continuous- and discrete-time Riccati equation solvers
- feature-based demos instead of single ones for each MOR function
- adaptive frequency evaluation/visualization methods
- time integration methods
- corrected balancing type scheme for second-order methods
- vectorization of MOR methods to compute several ROMs at the same time
- projection matrices are optional output arguments

Interface changes:
- changed fatorized equation solver output to Z*Z' and L*D*L' formats
- interfaces of matrix equation solvers are now consistent with System
  Control Toolbox solvers
- algebraic Bernoulli equation is now abbreviated cabe
- matrix sign function is generalized to accept matrix pencils
- renaming of lti2struct, sr and bfsr routines by removing the ct_ part
- replaced disk function for stable anti-stable decomposition of descriptor
  systems by matrix sign function
- sigma plot function takes now several systems and optional parameters
- changed info field GADTF to ADTF
- evaluation and visualization routines are now in extra folder evaluation
- changed caredl functions into factorized and completely unfactorized
  versions
- replaced nilpotent discrete Lyapunov solver by dual version, renamed
  corresponding parameter and info output

Minor changes:
- corrected handling of sparse matrices in Sylvester equation solver
- improper balancing can now be turned of by optional parameter
- additional functions for output formatting
- replaced ~ as negation in source codes by not()
- MOR methods with Riccati equations now allow dual Riccati equation solver

Bug fixes:
- proper handling of hold command in frequency plot functions
- corrected ASCII encoding in documentations
- fixed minimal realiaztion computation in HNA methods
- fixed error bound computation in HNA methods
- corrected tolerance checks in descriptor PRBT method


## Version 4.0 (2018-12-06)
---------------------------

New core features:
- new system class: second-order state-space systems
- balanced truncation for second-order systems
- frequency-limited balanced truncation for all supported system classes
- time-limited balanced truncation for all supported system classes
- HTML documentation is provided for all export formats of the toolbox

Interface changes:
- new naming scheme (mor functions and subroutines) for easier adding new
  types of systems
- nilpotent Lyapunov equation solver has been rewritten for the dual
  equation type
- unification of all factored matrix equation solvers to the Z'*Z or L'*D*L
  formulations
- the LQGBT and HINFBT routines use now the dual sign function Riccati
  equation solver as default
- the info structure is restricted to actually happened steps in the
  algorithm

Minor changes:
- generalization of the Sylvester equation solver
- new solver for indefinite factored Riccati equations
- new dual sign function solver for Riccati equations
- new LDL^T sign function solvers for Lyapunov equations
- updated/corrected and downsized documentation in all routines
- now providing stabilized subspace extraction method for descriptor
  systems
- all systems allow use of sparse matrices by the user
- storing more information about nested equation solvers my using cell
  arrays
- new subroutines for row/column compressions of Z'*Z and L'*D*L factorized
  matrices
- new contribution guide
- updated references for all routines
- help morlab or help morlab-[version] shows list of functions

Bug fixes:
- added missing default values for info structure in ml_mt
- corrected wrong named parameters in ml_hna_dss, ml_brbt_dss, ml_prbt_dss
- corrected error bound computation in ml_lqgbt, ml_lqgbt_dss, ml_hinfbt,
  ml_hinfbt_dss
- corrected using of sparse matrices for small examples
- fixed truncation of unstable eigenvalues in ml_mt_dss
- fixed truncation of no eigenvalues in ml_mt_dss


## Version 3.0 (2017-09-01)
---------------------------

Structural changes:
- The toolbox is licensed under AGPLv3 or later.
- A new naming scheme for MORLAB functions is used to avoid overloading of
  foreign object names.
- MORLAB is now independent of SLICOT and can be used without the Control
  System Toolbox, Robust Control Toolbox and the Control Package.
- The code is properly generalized for the use under Otcave.
- The underlying data structure was generalized to descriptor state space
  objects (dss) and structs.
- Every computational subroutine has an optional argument for parameters.
- The subroutines are seperated by folders for better overview and an
  installation function was added.
- Proper documentation of every subroutine was added.
- Demo scripts for all model reduction routines with all assigned
  parameters were added.
- Toolbox internal check functions were added.

Subroutine changes:
- Changes in model reduction routines:
  - generalized version of all previously existing model reduction routines
    following the improper Hankel singular value theory
  - using disk function with double projection for descriptor system case
  - several bug fixes
- Changes in matrix equation solvers:
  - Newton iteration solver for the algebraic Riccati equation with changed
    sign in the quadratic term was replaced by factored version
  - Smith method solver for the discrete-time Lyapunov equation with 0
    spectrum added
  - extension of all solvers to generalized matrix equations
  - several bugfixes
- Changes in matrix functions/subroutines:
  - renewed option set function with documentation opportunity
  - new options function to get empty option structure or documentation
  - subroutines for additive decomposition of the transfer function added
  - sigma plot function now operates on struct inputs


## Version 2.0 (2015)
---------------------

Structural changes:
- The underlying data structure was generalized to Matlab's state space
  object (ss).
- Additional parameters for subroutines can be set by an option struct.
  Therefore, a set function was added.
- For the use of descriptor systems, the Control System Toolbox as well as
  some routines of the SLICOT toolbox are necessary.

Subroutine changes:
- Changes in model reduction routines:
  - balanced stochastic truncation (BST) method added
  - positive-real balanced truncation (PRBT) method added
  - bounded-real balanced truncation (BRBT) method added
  - Hankel-norm approximation (HNA) method added
  - H-infinity balanced truncation (HinfBT) method added
  - balancing-free square root method was added for all balancing related
    model reduction methods
  - generalization of all methods to unstable and descriptor system by
    separation of corresponding eigenvalues
- Changes in matrix equation solvers:
  - Newton iteration solver for the standard algebraic Riccati equation
    with changed sign in the quadratic term added
- Changes in matrix functions/subroutines:
  - methods for partial stabilization of systems based on Lyapunov and
    Bernoulli equations added


## Version 1.0 (2006)
---------------------

The first release of MORLAB contained the following basic implementations:
- Model reduction routines:
  - balanced truncation square root (BTSR) method
  - LQG balanced truncation square root (LQGBT) method
  - Modal Truncation (MT) method
- Matrix equation solvers:
  - Sign function based solver for the standard Lyapunov equation
  - Sign function based solver for the dual standard Lyapunov equations
  - Sign function based solver for the standard Sylvester equation
  - Newton iteration solver for the standard algebraic Riccati equation
- Matrix functions/subroutines:
  - Newton iteration to compute the matrix sign function
  - Disk function iteration to compute deflating subspaces of the unit
    circle
