% MORLAB - Model Order Reduction LABoratory.
% Version 6.0 24-September-2023
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
%
% Meta routines.
%   ml_citation - generates bilbiography text and BibTeX entry for MORLAB
%   ml_version  - version information about MORLAB installation
%
% Demos.
%   morlab_demo_additive_decomposition - MORLAB demo: additive decomposition
%   morlab_demo_equation_solvers       - MORLAB demo: matrix equation solvers
%   morlab_demo_frequency_evaluation   - MORLAB demo: frequency evaluation and visualization
%   morlab_demo_mor_default            - MORLAB demo: model reduction default usage
%   morlab_demo_mor_secondorder        - MORLAB demo: model reduction for second-order systems
%   morlab_demo_morlabopts             - MORLAB demo: option constructor function ml_morlabopts
%   morlab_demo_partial_stabilization  - MORLAB demo: partial stabilization
%   morlab_demo_time_evaluation        - MORLAB demo: time evaluation and visualization
%
% Top level model reduction methods for continuous-time systems.
%   ml_ct_brbt        - continuous-time bounded-real balanced truncation method
%   ml_ct_bst         - continuous-time balanced stochastic truncation method
%   ml_ct_bt          - continuous-time balanced truncation method
%   ml_ct_flbt        - continuous-time frequency-limited balanced truncation method
%   ml_ct_hinfbt      - continuous-time H-infinity balanced truncation method
%   ml_ct_hna         - continuous-time Hankel-norm approximation method
%   ml_ct_krylov      - continuous-time Krylov subspace method
%   ml_ct_lqgbt       - continuous-time LQG balanced truncation method
%   ml_ct_mt          - continuous-time modal truncation method
%   ml_ct_prbt        - continuous-time positive-real balanced truncation method
%   ml_ct_tlbt        - continuous-time time-limited balanced truncation method
%   ml_ct_twostep_mor - continuous-time two-step model reduction method
%
% Top level model reduction methods for discrete-time systems.
%   ml_dt_bt          - discrete-time balanced truncation method
%   ml_dt_krylov      - discrete-time Krylov subspace method
%   ml_dt_lqgbt       - discrete-time LQG balanced truncation method
%   ml_dt_mt          - discrete-time modal truncation method
%   ml_dt_twostep_mor - discrete-time two-step model reduction method
%
% Continuous-time dense model reduction methods.
%   ml_ct_d_dss_brbt    - bounded-real balanced truncation for descriptor systems
%   ml_ct_d_dss_bst     - balanced stochastic truncation for descriptor systems
%   ml_ct_d_dss_bt      - balanced truncation for dense descriptor systems
%   ml_ct_d_dss_flbt    - frequency-limited balanced truncation for desc. systems
%   ml_ct_d_dss_hinfbt  - H-infinity balanced truncation for descriptor systems
%   ml_ct_d_dss_hna     - Hankel-norm approximation for dense, descriptor systems
%   ml_ct_d_dss_krylov  - Krylov subspace method for dense descriptor systems
%   ml_ct_d_dss_lqgbt   - LQG balanced truncation for dese, descriptor systems
%   ml_ct_d_dss_mt      - modal truncation for descriptor systems
%   ml_ct_d_dss_prbt    - positive-real balanced truncation for descriptor systems
%   ml_ct_d_dss_tlbt    - time-limited balanced truncation for descriptor systems
%   ml_ct_d_soss_brbt   - PRBT for dense, continuous second-order systems
%   ml_ct_d_soss_bst    - BST for dense, continuous second-order systems
%   ml_ct_d_soss_bt     - BT for dense, continuous second-order systems
%   ml_ct_d_soss_flbt   - FLBT for dense, continuous second-order systems
%   ml_ct_d_soss_hinfbt - HINFBT for dense, continuous second-order systems
%   ml_ct_d_soss_hna    - HNA for dense, continuous second-order systems
%   ml_ct_d_soss_krylov - Krylov subspace method for dense sec.-ord. systems
%   ml_ct_d_soss_lqgbt  - LQGBT for dense, continuous second-order systems
%   ml_ct_d_soss_mt     - modal trunc. for dense, continuous second-order systems
%   ml_ct_d_soss_prbt   - PRBT for dense, continuous second-order systems
%   ml_ct_d_soss_tlbt   - TLBT for dense, continuous second-order systems
%   ml_ct_d_ss_brbt     - bounded-real balanced truncation for standard systems
%   ml_ct_d_ss_bst      - balanced stochastic truncation for dense, standard systems
%   ml_ct_d_ss_bt       - balanced truncation for dense, continuous standard systems
%   ml_ct_d_ss_flbt     - frequency-limited balanced truncation for standard systems
%   ml_ct_d_ss_hinfbt   - H-infinity balanced truncation for standard systems
%   ml_ct_d_ss_hna      - Hankel-norm approximation for dense, standard systems
%   ml_ct_d_ss_krylov   - Krylov subspace method for standard systems
%   ml_ct_d_ss_lqgbt    - LQG balanced truncation for dense, standard systems
%   ml_ct_d_ss_mt       - modal truncation for continuous-time dense, standard systems
%   ml_ct_d_ss_prbt     - positive-real balanced truncation for standard systems
%   ml_ct_d_ss_tlbt     - time-limited balanced truncation for standard systems
%
% Continuous-time sparse model reduction methods.
%   ml_ct_s_foss_brbt        - BRBT for sparse first-order systems
%   ml_ct_s_foss_bst         - BST for sparse first-order systems
%   ml_ct_s_foss_bt          - balanced truncation for sparse first-order systems
%   ml_ct_s_foss_hinfbt      - HINFBT for sparse first-order systems
%   ml_ct_s_foss_hna         - Hankel-norm approximation for sparse first-order systems
%   ml_ct_s_foss_krylov      - Krylov subspace method for sparse first-order systems
%   ml_ct_s_foss_lqgbt       - LQG balanced truncation for sparse first-order systems
%   ml_ct_s_foss_prbt        - PRBT for sparse first-order systems
%   ml_ct_s_foss_twostep_mor - two-step MOR methods for first-order systems
%   ml_ct_s_soss_brbt        - BRBT for sparse second-order systems
%   ml_ct_s_soss_bst         - BST for sparse second-order systems
%   ml_ct_s_soss_bt          - balanced truncation for sparse second-order systems
%   ml_ct_s_soss_hinfbt      - HINFBT for sparse secend-order systems
%   ml_ct_s_soss_hna         - Hankel-norm approximation for sparse sec.-order systems
%   ml_ct_s_soss_krylov      - Krylov subspace method for sparse sec.-order systems
%   ml_ct_s_soss_lqgbt       - LQG balanced truncation for sparse sec.-order systems
%   ml_ct_s_soss_prbt        - PRBT for sparse second-order systems
%   ml_ct_s_soss_twostep_mor - two-step MOR methods for second-order systems
%
% Discrete-time dense model reduction methods.
%   ml_dt_d_dss_bt     - balanced truncation for dense descriptor systems
%   ml_dt_d_dss_krylov - Krylov subspace method for dense descriptor systems
%   ml_dt_d_dss_lqgbt  - LQG balanced truncation for discrete-time desc. systems
%   ml_dt_d_dss_mt     - modal truncation for descriptor systems
%   ml_dt_d_ss_bt      - balanced truncation for dense, discrete standard systems
%   ml_dt_d_ss_krylov  - Krylov subspace method for standard systems
%   ml_dt_d_ss_lqgbt   - LQG balanced truncation for dense, standard systems
%   ml_dt_d_ss_mt      - modal truncation for dense, standard discrete-time systems
%
% Discrete-time sparse model reduction methods.
%   ml_dt_s_foss_krylov      - Krylov subspace method for sparse first-order systems
%   ml_dt_s_foss_twostep_mor - two-step MOR methods for first-order systems
%
% Matrix Equation Solvers.
%   ml_cabe_sgn           - continuous-time algebraic Bernoulli equation solver
%   ml_care_nwt_fac       - continuous-time Riccati equation solver (fac.)
%   ml_care_nwt_ldl       - continuous-time factorized Riccati equation solver (LDL)
%   ml_caredl_sgn         - continuous-time dual Riccati equation solver
%   ml_caredl_sgn_fac     - continuous-time dual Riccati equation solver (fac.)
%   ml_dare_nwt_fac       - discrete-time Riccati equation solver (fac.)
%   ml_daredl_sda         - discrete-time dual Riccati equation solver
%   ml_daredl_sda_fac     - discrete-time dual Riccati equation solver (fac.)
%   ml_dlyap_smith        - discrete-time Lyapunov equation solver
%   ml_dlyap_smith_fac    - discrete-time Lyapunov equation solver (fac.)
%   ml_dlyap_smith_ldl    - discrete-time Lyapunov equation solver (LDL)
%   ml_dlyapdl_smith      - discrete-time dual Lyapunov equation solver
%   ml_dlyapdl_smith_fac  - discrete-time dual Lyapunov equation solver (fac.)
%   ml_dlyapdl_smith_ldl  - discrete-time dual Lyapunov equation solver (LDL)
%   ml_dsylv_smith        - discrete-time Sylvester equation solver
%   ml_dsylv_smith_fac    - discrete-time Sylvester equation solver (fac.)
%   ml_gdlyap_smith_fac   - nilpotent discrete-time Lyapunov equation solver
%   ml_gdlyapdl_smith_fac - nilpot. discrete-time dual Lyapunov equation solver (fac.)
%   ml_icare_ric_fac      - continuous-time indefinite Riccati equation solver (fac.)
%   ml_lyap_sgn           - continuous-time Lyapunov equation solver
%   ml_lyap_sgn_fac       - continuous-time Lyapunov equation solver (fac.)
%   ml_lyap_sgn_ldl       - continuous-time Lyapunov equation solver (LDL)
%   ml_lyapdl_sgn         - continuous-time dual Lyapunov equation solver
%   ml_lyapdl_sgn_fac     - continuous-time dual Lyapunov equation solver (fac.)
%   ml_lyapdl_sgn_ldl     - continuous-time dual Lyapunov equation solver (LDL)
%   ml_pcare_nwt_fac      - positive continuous-time Riccati equation solver (fac.)
%   ml_sylv_sgn           - continuous-time Sylvester equation solver
%   ml_sylv_sgn_fac       - continuous-time Sylvester equation solver (fac.)
%
% Evaluation.
%   ml_bodemag               - Bode magnitude plots of transfer functions
%   ml_ct_dss_simulate_ie    - implicit Euler first-order integrator
%   ml_ct_dss_simulate_ss11  - single step first-order integrator
%   ml_ct_dss_simulate_ss21  - single step first-order integrator
%   ml_ct_soss_simulate_ie   - implicit Euler second-order integrator
%   ml_ct_soss_simulate_ss22 - single step second-order integrator
%   ml_ct_ss_simulate_ie     - implicit Euler first-order integrator
%   ml_ct_ss_simulate_ss11   - single step first-order integrator
%   ml_ct_ss_simulate_ss21   - single step first-order integrator
%   ml_dt_dss_simulate       - discrete-time simulation of descriptor systems
%   ml_dt_ss_simulate        - discrete-time simulation of standard systems
%   ml_frobeniusplot         - Frobenius plots of transfer functions
%   ml_sigmaplot             - sigma plots of transfer functions
%
% Subroutines.
%   ml_balproj_improper    - compute projection bases for MOR of improper parts
%   ml_balproj_proper      - compute projection bases for MOR of proper parts
%   ml_balproj_soss        - compute projection bases for second-order balancing
%   ml_compress_fac        - SVD-based row/column compression
%   ml_compress_ldl        - LDL^T row/column compression
%   ml_ct_d_dss_adtf       - add. dec. of dense descriptor system transfer functions
%   ml_ct_d_dss_partstab   - stabilizing feedback for descriptor systems
%   ml_ct_d_ss_adtf        - add. dec. of dense standard system transfer functions
%   ml_ct_d_ss_partstab    - stabilizing feedback for standard systems
%   ml_decide_system_type  - analyse system structure and rearrange into struct
%   ml_disk                - inverse free iteration for the matrix disk function
%   ml_domsubproj_proper   - compute projection basis for MOR of proper parts
%   ml_domsubproj_soss     - compute projection basis for MOR of second-order parts
%   ml_dt_d_dss_adtf       - add. dec. of dense descriptor system transfer functions
%   ml_dt_d_dss_partstab   - stabilizing feedback for descriptor systems
%   ml_dt_d_ss_adtf        - add. dec. of dense standard system transfer functions
%   ml_dt_d_ss_partstab    - stabilizing feedback for standard systems
%   ml_extend_cell         - extends the given cell arrays to match in size
%   ml_format_output       - reformat internal representation to final output
%   ml_getqz               - subspace extraction method
%   ml_morlabopts          - option struct generator for MORLAB functions
%   ml_order               - order computation for model reduction method
%   ml_prepare_system_data - densification and implicit projection of matrices
%   ml_projtrunc_improper  - compute reduced improper model via projection
%   ml_projtrunc_proper    - compute reduced proper model via projection
%   ml_projtrunc_soss      - compute reduced second-order model via projection
%   ml_signm               - matrix sign function iteration
%
% Checks.
%   ml_assert_boolean      - checks if a given value is boolean
%   ml_assert_char         - checks if a given value is a char array
%   ml_assert_descsys      - checks if a given structure is a descriptor system
%   ml_assert_infdescsys   - checks if a given struct has inf descriptor matrices
%   ml_assert_integer      - checks if a given value is a real integer
%   ml_assert_nonnegint    - checks if a value is a nonnegative, real integer
%   ml_assert_nonnegintinf - checks if a value is a nonnegative integer or Inf
%   ml_assert_nonnegscalar - checks if a value is a nonnegative, real scalar
%   ml_assert_nonnegvector - checks if a value is a real, nonnegative vector
%   ml_assert_posinteger   - checks if a given value is a positive integer
%   ml_assert_posscalar    - checks if a given value is a positive, real scalar
%   ml_assert_scalar       - checks if a given value is a real scalar
%   ml_assert_sosys        - checks if a given structure is a second-order system
%   ml_assert_stdsys       - checks if a given structure is a standard system
%   ml_assert_vector       - checks if a value is a real, nonnegative vector
%   ml_check_cell_param    - performs an assert on all elements in a cell-array
%   ml_check_cell_vector   - checks input vectors and sets default values
%   ml_check_krylovopts    - checks and sets options for Krylov subspace methods
%   ml_check_messopts      - create default option structures for M-M.E.S.S.
%   ml_field_set_to_value  - checks if a field exists and has a non-empty value
%

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%
