function [check] = ml_field_set_to_value(opts, field)
%ML_FIELD_SET_TO_VALUE Checks if a field exists and has a non-empty value.
%
% SYNTAX:
%   lCheck = ML_FIELD_SET_TO_VALUE(opts, field)
%
% DESCRIPTION:
%   This function checks if a field with the name field exists in the
%   struct opts and if it exists, whether it's empty or not.
%
% INPUTS:
%   opts  - option structure, which shall be tested
%   field - character array, containing the name of the field
%
% OUTPUTS:
%   check - logical value, true if the field exists and isn't empty and
%           otherwise false
%
% See also ml_assert_boolean, ml_assert_scalar.

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

narginchk(2, 2);

check = isfield(opts, field) && not(isempty(opts.(field)));
