function [] = ml_assert_infdescsys(sys)
%ML_ASSERT_INFDESCSYS Checks if a given struct has inf descriptor matrices.
%
% SYNTAX:
%   ML_ASSERT_INFDESCSYS(sys)
%
% DESCRIPTION:
%   This function checks if a given structure contains inf descriptor
%   matrices with appropriate matrices and dimensions and throws an error
%   if not.
%
% INPUTS:
%   sys - structure, which shall be checked
%
% OUTPUTS:
%   ---
%
% See also ml_assert_descsys, ml_assert_stdsys.

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

narginchk(1, 1);

assert(isa(sys, 'struct'), ...
    'MORLAB:data', ...
    'The parameter sys has to be a struct!');

assert(isfield(sys, 'Ainf'), ...
    'MORLAB:data', ...
    'The system must have an Ainf matrix!');

ninf = size(sys.Ainf, 1);

assert(isequal(size(sys.Ainf), [ninf ninf]), ...
    'MORLAB:data', ...
    'The matrix Ainf has to be square!');

assert(isfield(sys, 'Einf'), ...
    'MORLAB:data', ...
    'The system must have an Einf matrix!');

assert(isequal(size(sys.Einf), [ninf ninf]), ...
    'MORLAB:data', ...
    'The matrix Einf must have the same dimensions as Ainf!');

assert(isfield(sys, 'Binf'), ...
    'MORLAB:data', ...
    'The system must have an Binf matrix!');

assert(size(sys.Binf, 1) == ninf, ...
    'MORLAB:data', ...
    'The matrix Binf must have the same number of rows as Ainf!');

assert(isfield(sys, 'Cinf'), ...
    'MORLAB:data', ...
    'The system must have an Cinf matrix!');

assert(size(sys.Cinf, 2) == ninf, ...
    'MORLAB:data', ...
    'The matrix Cinf must have the same number of columns as Ainf!');
