function [] = ml_assert_char(value, name)
%ML_ASSERT_CHAR Checks if a given value is a char array.
%
% SYNTAX:
%   ML_ASSERT_CHAR(value)
%   ML_ASSERT_CHAR(value, name)
%
% DESCRIPTION:
%   This function checks if a given value is a char array and throws an
%   error if not.
%
% INPUTS:
%   value - value, which will be checked
%   name  - character array, used as parameter name in error handling
%
% OUTPUTS:
%   ---
%
% See also ml_assert_integer, ml_assert_boolean.

%
% This file is part of the MORLAB toolbox
% (https://www.mpi-magdeburg.mpg.de/projects/morlab).
% Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)
%

narginchk(1, 2);

if nargin < 2
    name = '';
else
    assert(ischar(name), ...
        'MORLAB:data', ...
        'The name of the parameter must consist of characters.');

    name = [' ' name];
end

assert(ischar(value), ...
    'MORLAB:data', ...
    'The parameter%s must be a char array.', ...
    name);
