MORLAB - Model Order Reduction Laboratory
=========================================

The MORLAB, Model Order Reduction LABoratory, toolbox is a collection of
MATLAB/Octave routines for model order reduction of dynamical systems.
The implementation is based on spectral projection methods, like the matrix
sign function and the matrix disk function, and on iterative low-rank
solvers for large-scale sparse systems.


## Getting Started
------------------

### Dependencies

MATLAB R2018a and above, Octave 6.2.0 and above.

Generally, the implemented functions run fine in plain MATLAB/Octave.
However, to use the ss functionality of the toolbox, the Control
System Toolbox (MATLAB) or Control Package (Octave) is needed.
For using sparss and mechss objects MATLAB version 2020b or later is
needed.
Also, all sparse model reduction methods need the M-M.E.S.S. version 3.0
(https://www.mpi-magdeburg.mpg.de/projects/mess) installed.


### Installation

Change to the MORLAB main folder, containing this file, and run the
`ml_addpath` function. This will add this folder together with all
subfolders to your MATLAB/Octave search path. If you do not want
to do this every time, you need to save the resulting search path.


### Using MORLAB

The toolbox includes several methods for model reduction of linear
dynamical systems in continuous-time standard

      x'(t) = A*x(t) + B*u(t),
       y(t) = C*x(t) + D*u(t),

discrete-time standard

      x(t+1) = A*x(t) + B*u(t),
        y(t) = C*x(t) + D*u(t),

continuous-time descriptor

      Ex'(t) = A*x(t) + B*u(t),
        y(t) = C*x(t) + D*u(t),

discrete-time descriptor

      Ex(t+1) = A*x(t) + B*u(t),
         y(t) = C*x(t) + D*u(t),

or second-order form

      M*x''(t) = -K*x(t) -  E*x'(t) + Bu*u(t),
          y(t) = Cp*x(t) + Cv*x'(t) +  D*u(t).

As a starting point, there are demos for all main features of the toolbox.
In the following, the implemented model reduction procedures are listed.
Note that these are top level routines that automatically determine the
given system type and apply the corresponding model reduction routines;
not all methods are available for all different kinds of systems:

1. Continuous-time systems:
    * Bounded-Real Balanced Truncation (BRBT): `ml_ct_brbt`
    * Balanced Stochastic Truncation (BST): `ml_ct_bst`
    * Balanced Truncation (BT): `ml_ct_bt`
    * Frequency-Limited Balanced Truncation (FLBT): `ml_ct_flbt`
    * H-infinity Balanced Truncation (HINFBT): `ml_ct_hinfbt`
    * Krylov subspace methods: `ml_ct_krylov`
    * Hankel-Norm Approximation (HNA): `ml_ct_hna`
    * Linear-quadratic Gaussian Balanced Truncation (LQGBT): `ml_ct_lqgbt`
    * Modal Truncation (MT): `ml_ct_mt`
    * Positive-Real Balanced Truncation (PRBT): `ml_ct_prbt`
    * Time-Limited Balanced Truncation (TLBT): `ml_ct_tlbt`
    * Two-step model reduction: `ml_ct_twostep_mor`

2. Discrete-time systems:
    * Balanced Truncation (BT): `ml_dt_bt`
    * Krylov subspace methods: `ml_dt_krylov`
    * Linear-Quadratic Gaussian Balanced Truncation (LQGBT): `ml_dt_lqgbt`
    * Modal Truncation (MT): `ml_dt_mt`
    * Two-step model reduction: `ml_dt_twostep_mor`

As stated above, there is a demo script for each of the main features,
which can be used as a starting point. The following demos are available:
* Model reduction methods in MORLAB
  (`morlab_demo_mor_default.m`)
* Model reduction for second-order systems
  (`morlab_demo_mor_secondorder.m`)
* Matrix equation solvers
  (`morlab_demo_equation_solvers.m`)
* Additive decomposition
  (`morlab_demo_additive_decomposition.m`)
* Partial Stabilization
  (`morlab_demo_partial_stabilization.m`)
* Frequency evaluation and visualization
  (`morlab_demo_frequency_evaluation.m`)
* Time evaluation and visualization
  (`morlab_demo_time_evaluation.m`)
* Option Constructor Function ml_morlabopts
  (`morlab_demo_morlabopts.m`)

A complete list of routines with short descriptions can be generated using
`help morlab` or `help morlab-6.0`.


### Contributing to MORLAB

See [CONTRIBUTING.md](CONTRIBUTING.md) for details on how to make
contributions to the software.


## Authors
----------

See [CONTRIBUTORS.md](CONTRIBUTORS.md) for details about the authors of
the toolbox.


## License
----------

Copyright (C) 2006-2023 Peter Benner, Jens Saak, and Steffen W. R. Werner

The software is licensed under BSD-2-Clause License.
See [COPYING](COPYING) for a copy of the license.


## Contact
----------

URL: http://www.mpi-magdeburg.mpg.de/projects/morlab

email: benner@mpi-magdeburg.mpg.de, saak@mpi-magdeburg.mpg.de,
       steffen.werner@vt.edu

orcids: 0000-0003-3362-4103, 0000-0001-5567-9637, 0000-0003-1667-4862


## Citation
-----------

See [CITATION.md](CITATION.md) for details about citing the software or
use the `ml_citation` function.
