# Probing center vortices and deconfinement in SU(2) lattice gauge theory with persistent homology

## Analyis code release

This repository contains the analysis code used to prepare the plots and results included in [Probing center vortices and deconfinement in SU(2) lattice gauge theory with persistent homology][paper].

The analysis code is split into two Jupyter notebooks: 'twist_analysis.ipynb' and 'knn_analysis.ipynb', covering the Sections IV.A and IV.B of the [paper][paper] respectively.

Additionally, the repository contains some saved calculations in 'intermediate_data.zip' that greatly speed up the computations if the original seeds are used. Running all the code with this intermediate data will take less than a minute, and running it without will take several hours.

There is also other useful code including that used to compute the persistent homology of configurations and that used to package the [data][data] into netCDF4 format.

## Requirements

The analysis is written in Python. The code has been tested with:

* Python 3.8 (with requirements as documented in `environment.yml`)
* (Optionally) Conda to manage dependencies

## Setup

### Installation

* Download the repository
* Run

      conda env create -f environment.yml

  to create a new Conda environment including the requisite packages.
  (Alternatively, create a Python environment with the listed packages.)

### Data

* Download the data from [the accompanying data release][data] into the 'data' directory.
* To use the provided saved calculations, unzip 'intermediate_data.zip' into the top directory.

### Running the analysis

* With the software and data downloaded, you should be able to reproduce the full analysis by running

      python knn_analysis_script.py --Nt 4
      python knn_analysis_script.py --Nt 5
      python knn_analysis_script.py --Nt 6
      python twist_analysis_script.py

  Plots and numerical results will be saved in the 'output' directory. Intermediary files not included in the publication, but useful for running the code again quickly, are held in the 'intermediate_data' directory.

  Note that each run of 'python knn_analysis_script.py' will save the html output of the jupyter notebook to 'knn_analysis.html'. Therefore, copy or rename this file after each run if you want to keep this for each Nt.

* Alternatively, the jupyter notebooks 'knn_analysis.ipynb' and 'twist_analysis.ipynb' may be run interactively.

[data]: https://doi.org/10.5281/zenodo.7060073
[paper]: https://arxiv.org/abs/2207.13392
