###------FIPSCODES-----
## @knitr fipscodes

# This will download a list of FIPS codes from online.
fipslist <- read_csv(file="https://www2.census.gov/geo/docs/reference/codes/files/national_county.txt", col_names = FALSE) %>%
  mutate(GEOID = paste0(X2, X3)) %>%
  dplyr::rename(state = X1,
                STATEID = X2,
                CNTYID = X3,
                NAME = X4) %>%
  filter(!STATEID %in% c("60", "66", "69", "72", "74", "78")) # filtering out the outerlying areas.

# Converting the fipslist into a unique list of 2-digit state ID's #
stateid = unlist(list(unique(fipslist$STATEID)))
# Converting the fipslist into a unique list of 5-digit county ID's #
GEOID = unlist(list(unique(fipslist$GEOID)))

# Creating a list of States
statenames <- group_by(fipslist, STATEID, state) %>%
  dplyr::summarise()
# Creating a list of counties
countynames <- group_by(fipslist, GEOID, NAME, state) %>%
  dplyr::summarise()



# toymodel <- c("12086", "13121", "12011")
toymodel <- GEOID
