#ifndef actual_network_H
#define actual_network_H

#include <AMReX_REAL.H>
#include <AMReX_Array.H>

#include <fundamental_constants.H>
#include <network_properties.H>

using namespace amrex;

void actual_network_init();

const std::string network_name = "pynucastro-cxx";

namespace network
{
    extern AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 1, NumSpec> bion;
    extern AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 1, NumSpec> mion;
}

namespace Rates
{

    enum NetworkRates
    {
        k_n__p__weak__wc12 = 1,
        k_be7__li7__weak__electron_capture = 2,
        k_c14__n14__weak__wc12 = 3,
        k_n13__c13__weak__wc12 = 4,
        k_o14__n14__weak__wc12 = 5,
        k_o15__n15__weak__wc12 = 6,
        k_f17__o17__weak__wc12 = 7,
        k_f18__o18__weak__wc12 = 8,
        k_ne18__f18__weak__wc12 = 9,
        k_ne19__f19__weak__wc12 = 10,
        k_na21__ne21__weak__wc12 = 11,
        k_na22__ne22__weak__wc12 = 12,
        k_mg23__na23__weak__wc12 = 13,
        k_al25__mg25__weak__wc12 = 14,
        k_al26__mg26__weak__wc12 = 15,
        k_si31__p31__weak__wc12 = 16,
        k_si32__p32__weak__wc12 = 17,
        k_p29__si29__weak__wc12 = 18,
        k_p30__si30__weak__wc12 = 19,
        k_p32__s32__weak__wc12 = 20,
        k_p33__s33__weak__wc12 = 21,
        k_s35__cl35__weak__wc12 = 22,
        k_cl33__s33__weak__wc12 = 23,
        k_cl34__s34__weak__wc12 = 24,
        k_cl36__ar36__weak__wc12 = 25,
        k_cl36__s36__weak__wc12 = 26,
        k_ar37__cl37__weak__wc12 = 27,
        k_ar39__k39__weak__wc12 = 28,
        k_k37__ar37__weak__wc12 = 29,
        k_k38__ar38__weak__wc12 = 30,
        k_k40__ca40__weak__wc12 = 31,
        k_k40__ar40__weak__wc12 = 32,
        k_ca41__k41__weak__wc12 = 33,
        k_ca45__sc45__weak__wc12 = 34,
        k_ca47__sc47__weak__wc12 = 35,
        k_ca48__sc48__weak__mo03 = 36,
        k_sc43__ca43__weak__wc12 = 37,
        k_sc44__ca44__weak__wc12 = 38,
        k_sc46__ti46__weak__wc12 = 39,
        k_sc47__ti47__weak__wc12 = 40,
        k_sc48__ti48__weak__wc12 = 41,
        k_sc49__ti49__weak__wc12 = 42,
        k_ti44__sc44__weak__wc12 = 43,
        k_ti45__sc45__weak__wc12 = 44,
        k_ti51__v51__weak__wc12 = 45,
        k_v46__ti46__weak__wc12 = 46,
        k_v47__ti47__weak__wc12 = 47,
        k_v48__ti48__weak__wc12 = 48,
        k_v49__ti49__weak__wc12 = 49,
        k_v50__ti50__weak__mo03 = 50,
        k_v52__cr52__weak__wc12 = 51,
        k_cr48__v48__weak__wc12 = 52,
        k_cr49__v49__weak__wc12 = 53,
        k_cr51__v51__weak__wc12 = 54,
        k_mn50__cr50__weak__wc12 = 55,
        k_mn51__cr51__weak__wc12 = 56,
        k_mn52__cr52__weak__wc12 = 57,
        k_mn53__cr53__weak__wc12 = 58,
        k_mn54__cr54__weak__wc12 = 59,
        k_fe52__mn52__weak__wc12 = 60,
        k_fe53__mn53__weak__wc12 = 61,
        k_fe55__mn55__weak__wc12 = 62,
        k_co53__fe53__weak__wc12 = 63,
        k_co54__fe54__weak__wc12 = 64,
        k_co55__fe55__weak__wc12 = 65,
        k_co56__fe56__weak__wc12 = 66,
        k_co57__fe57__weak__wc12 = 67,
        k_co58__fe58__weak__wc12 = 68,
        k_ni56__co56__weak__wc12 = 69,
        k_ni57__co57__weak__wc12 = 70,
        k_ni59__co59__weak__wc12 = 71,
        k_ni63__cu63__weak__wc12 = 72,
        k_cu57__ni57__weak__wc12 = 73,
        k_cu58__ni58__weak__wc12 = 74,
        k_cu59__ni59__weak__wc12 = 75,
        k_cu60__ni60__weak__wc12 = 76,
        k_cu61__ni61__weak__wc12 = 77,
        k_cu62__ni62__weak__wc12 = 78,
        k_cu64__ni64__weak__wc12 = 79,
        k_cu64__zn64__weak__wc12 = 80,
        k_zn59__cu59__weak__wc12 = 81,
        k_zn60__cu60__weak__wc12 = 82,
        k_zn61__cu61__weak__wc12 = 83,
        k_zn62__cu62__weak__wc12 = 84,
        k_zn63__cu63__weak__wc12 = 85,
        k_zn65__cu65__weak__wc12 = 86,
        k_ga62__zn62__weak__wc12 = 87,
        k_ga63__zn63__weak__wc12 = 88,
        k_ga64__zn64__weak__wc12 = 89,
        k_ge63__ga63__weak__wc12 = 90,
        k_ge64__ga64__weak__wc12 = 91,
        k_d__n_p = 92,
        k_he3__p_d = 93,
        k_he4__n_he3 = 94,
        k_he4__d_d = 95,
        k_li6__he4_d = 96,
        k_li7__n_li6 = 97,
        k_be7__p_li6 = 98,
        k_be7__he4_he3 = 99,
        k_b8__p_be7 = 100,
        k_b8__he4_he4__weak__wc12 = 101,
        k_b10__p_be9 = 102,
        k_b10__he4_li6 = 103,
        k_b11__n_b10 = 104,
        k_b11__he4_li7 = 105,
        k_c12__p_b11 = 106,
        k_c13__n_c12 = 107,
        k_c14__n_c13 = 108,
        k_n13__p_c12 = 109,
        k_n14__n_n13 = 110,
        k_n14__p_c13 = 111,
        k_n15__n_n14 = 112,
        k_n15__p_c14 = 113,
        k_o14__p_n13 = 114,
        k_o15__n_o14 = 115,
        k_o15__p_n14 = 116,
        k_o16__n_o15 = 117,
        k_o16__p_n15 = 118,
        k_o16__he4_c12 = 119,
        k_o17__n_o16 = 120,
        k_o18__n_o17 = 121,
        k_o18__he4_c14 = 122,
        k_f17__p_o16 = 123,
        k_f18__n_f17 = 124,
        k_f18__p_o17 = 125,
        k_f18__he4_n14 = 126,
        k_f19__n_f18 = 127,
        k_f19__p_o18 = 128,
        k_f19__he4_n15 = 129,
        k_ne18__p_f17 = 130,
        k_ne18__he4_o14 = 131,
        k_ne19__n_ne18 = 132,
        k_ne19__p_f18 = 133,
        k_ne19__he4_o15 = 134,
        k_ne20__n_ne19 = 135,
        k_ne20__p_f19 = 136,
        k_ne20__he4_o16 = 137,
        k_ne21__n_ne20 = 138,
        k_ne21__he4_o17 = 139,
        k_ne22__n_ne21 = 140,
        k_ne22__he4_o18 = 141,
        k_na21__p_ne20 = 142,
        k_na21__he4_f17 = 143,
        k_na22__n_na21 = 144,
        k_na22__p_ne21 = 145,
        k_na22__he4_f18 = 146,
        k_na23__n_na22 = 147,
        k_na23__p_ne22 = 148,
        k_na23__he4_f19 = 149,
        k_mg23__p_na22 = 150,
        k_mg23__he4_ne19 = 151,
        k_mg24__n_mg23 = 152,
        k_mg24__p_na23 = 153,
        k_mg24__he4_ne20 = 154,
        k_mg25__n_mg24 = 155,
        k_mg25__he4_ne21 = 156,
        k_mg26__n_mg25 = 157,
        k_mg26__he4_ne22 = 158,
        k_al25__p_mg24 = 159,
        k_al25__he4_na21 = 160,
        k_al26__n_al25 = 161,
        k_al26__p_mg25 = 162,
        k_al26__he4_na22 = 163,
        k_al27__n_al26 = 164,
        k_al27__p_mg26 = 165,
        k_al27__he4_na23 = 166,
        k_si28__p_al27 = 167,
        k_si28__he4_mg24 = 168,
        k_si29__n_si28 = 169,
        k_si29__he4_mg25 = 170,
        k_si30__n_si29 = 171,
        k_si30__he4_mg26 = 172,
        k_si31__n_si30 = 173,
        k_si32__n_si31 = 174,
        k_p29__p_si28 = 175,
        k_p29__he4_al25 = 176,
        k_p30__n_p29 = 177,
        k_p30__p_si29 = 178,
        k_p30__he4_al26 = 179,
        k_p31__n_p30 = 180,
        k_p31__p_si30 = 181,
        k_p31__he4_al27 = 182,
        k_p32__n_p31 = 183,
        k_p32__p_si31 = 184,
        k_p33__n_p32 = 185,
        k_p33__p_si32 = 186,
        k_s32__p_p31 = 187,
        k_s32__he4_si28 = 188,
        k_s33__n_s32 = 189,
        k_s33__p_p32 = 190,
        k_s33__he4_si29 = 191,
        k_s34__n_s33 = 192,
        k_s34__p_p33 = 193,
        k_s34__he4_si30 = 194,
        k_s35__n_s34 = 195,
        k_s35__he4_si31 = 196,
        k_s36__n_s35 = 197,
        k_s36__he4_si32 = 198,
        k_cl33__p_s32 = 199,
        k_cl33__he4_p29 = 200,
        k_cl34__n_cl33 = 201,
        k_cl34__p_s33 = 202,
        k_cl34__he4_p30 = 203,
        k_cl35__n_cl34 = 204,
        k_cl35__p_s34 = 205,
        k_cl35__he4_p31 = 206,
        k_cl36__n_cl35 = 207,
        k_cl36__p_s35 = 208,
        k_cl36__he4_p32 = 209,
        k_cl37__n_cl36 = 210,
        k_cl37__p_s36 = 211,
        k_cl37__he4_p33 = 212,
        k_ar36__p_cl35 = 213,
        k_ar36__he4_s32 = 214,
        k_ar37__n_ar36 = 215,
        k_ar37__p_cl36 = 216,
        k_ar37__he4_s33 = 217,
        k_ar38__n_ar37 = 218,
        k_ar38__p_cl37 = 219,
        k_ar38__he4_s34 = 220,
        k_ar39__n_ar38 = 221,
        k_ar39__he4_s35 = 222,
        k_ar40__n_ar39 = 223,
        k_ar40__he4_s36 = 224,
        k_k37__p_ar36 = 225,
        k_k37__he4_cl33 = 226,
        k_k38__n_k37 = 227,
        k_k38__p_ar37 = 228,
        k_k38__he4_cl34 = 229,
        k_k39__n_k38 = 230,
        k_k39__p_ar38 = 231,
        k_k39__he4_cl35 = 232,
        k_k40__n_k39 = 233,
        k_k40__p_ar39 = 234,
        k_k40__he4_cl36 = 235,
        k_k41__n_k40 = 236,
        k_k41__p_ar40 = 237,
        k_k41__he4_cl37 = 238,
        k_ca40__p_k39 = 239,
        k_ca40__he4_ar36 = 240,
        k_ca41__n_ca40 = 241,
        k_ca41__p_k40 = 242,
        k_ca41__he4_ar37 = 243,
        k_ca42__n_ca41 = 244,
        k_ca42__p_k41 = 245,
        k_ca42__he4_ar38 = 246,
        k_ca43__n_ca42 = 247,
        k_ca43__he4_ar39 = 248,
        k_ca44__n_ca43 = 249,
        k_ca44__he4_ar40 = 250,
        k_ca45__n_ca44 = 251,
        k_ca46__n_ca45 = 252,
        k_ca47__n_ca46 = 253,
        k_ca48__n_ca47 = 254,
        k_sc43__p_ca42 = 255,
        k_sc43__he4_k39 = 256,
        k_sc44__n_sc43 = 257,
        k_sc44__p_ca43 = 258,
        k_sc44__he4_k40 = 259,
        k_sc45__n_sc44 = 260,
        k_sc45__p_ca44 = 261,
        k_sc45__he4_k41 = 262,
        k_sc46__n_sc45 = 263,
        k_sc46__p_ca45 = 264,
        k_sc47__n_sc46 = 265,
        k_sc47__p_ca46 = 266,
        k_sc48__n_sc47 = 267,
        k_sc48__p_ca47 = 268,
        k_sc49__n_sc48 = 269,
        k_sc49__p_ca48 = 270,
        k_ti44__p_sc43 = 271,
        k_ti44__he4_ca40 = 272,
        k_ti45__n_ti44 = 273,
        k_ti45__p_sc44 = 274,
        k_ti45__he4_ca41 = 275,
        k_ti46__n_ti45 = 276,
        k_ti46__p_sc45 = 277,
        k_ti46__he4_ca42 = 278,
        k_ti47__n_ti46 = 279,
        k_ti47__p_sc46 = 280,
        k_ti47__he4_ca43 = 281,
        k_ti48__n_ti47 = 282,
        k_ti48__p_sc47 = 283,
        k_ti48__he4_ca44 = 284,
        k_ti49__n_ti48 = 285,
        k_ti49__p_sc48 = 286,
        k_ti49__he4_ca45 = 287,
        k_ti50__n_ti49 = 288,
        k_ti50__p_sc49 = 289,
        k_ti50__he4_ca46 = 290,
        k_ti51__n_ti50 = 291,
        k_ti51__he4_ca47 = 292,
        k_v46__p_ti45 = 293,
        k_v47__n_v46 = 294,
        k_v47__p_ti46 = 295,
        k_v47__he4_sc43 = 296,
        k_v48__n_v47 = 297,
        k_v48__p_ti47 = 298,
        k_v48__he4_sc44 = 299,
        k_v49__n_v48 = 300,
        k_v49__p_ti48 = 301,
        k_v49__he4_sc45 = 302,
        k_v50__n_v49 = 303,
        k_v50__p_ti49 = 304,
        k_v50__he4_sc46 = 305,
        k_v51__n_v50 = 306,
        k_v51__p_ti50 = 307,
        k_v51__he4_sc47 = 308,
        k_v52__n_v51 = 309,
        k_v52__p_ti51 = 310,
        k_v52__he4_sc48 = 311,
        k_cr48__p_v47 = 312,
        k_cr48__he4_ti44 = 313,
        k_cr49__n_cr48 = 314,
        k_cr49__p_v48 = 315,
        k_cr49__he4_ti45 = 316,
        k_cr50__n_cr49 = 317,
        k_cr50__p_v49 = 318,
        k_cr50__he4_ti46 = 319,
        k_cr51__n_cr50 = 320,
        k_cr51__p_v50 = 321,
        k_cr51__he4_ti47 = 322,
        k_cr52__n_cr51 = 323,
        k_cr52__p_v51 = 324,
        k_cr52__he4_ti48 = 325,
        k_cr53__n_cr52 = 326,
        k_cr53__p_v52 = 327,
        k_cr53__he4_ti49 = 328,
        k_cr54__n_cr53 = 329,
        k_cr54__he4_ti50 = 330,
        k_mn50__p_cr49 = 331,
        k_mn50__he4_v46 = 332,
        k_mn51__n_mn50 = 333,
        k_mn51__p_cr50 = 334,
        k_mn51__he4_v47 = 335,
        k_mn52__n_mn51 = 336,
        k_mn52__p_cr51 = 337,
        k_mn52__he4_v48 = 338,
        k_mn53__n_mn52 = 339,
        k_mn53__p_cr52 = 340,
        k_mn53__he4_v49 = 341,
        k_mn54__n_mn53 = 342,
        k_mn54__p_cr53 = 343,
        k_mn54__he4_v50 = 344,
        k_mn55__n_mn54 = 345,
        k_mn55__p_cr54 = 346,
        k_mn55__he4_v51 = 347,
        k_fe52__p_mn51 = 348,
        k_fe52__he4_cr48 = 349,
        k_fe53__n_fe52 = 350,
        k_fe53__p_mn52 = 351,
        k_fe53__he4_cr49 = 352,
        k_fe54__n_fe53 = 353,
        k_fe54__p_mn53 = 354,
        k_fe54__he4_cr50 = 355,
        k_fe55__n_fe54 = 356,
        k_fe55__p_mn54 = 357,
        k_fe55__he4_cr51 = 358,
        k_fe56__n_fe55 = 359,
        k_fe56__p_mn55 = 360,
        k_fe56__he4_cr52 = 361,
        k_fe57__n_fe56 = 362,
        k_fe57__he4_cr53 = 363,
        k_fe58__n_fe57 = 364,
        k_fe58__he4_cr54 = 365,
        k_co53__p_fe52 = 366,
        k_co54__n_co53 = 367,
        k_co54__p_fe53 = 368,
        k_co54__he4_mn50 = 369,
        k_co55__n_co54 = 370,
        k_co55__p_fe54 = 371,
        k_co55__he4_mn51 = 372,
        k_co56__n_co55 = 373,
        k_co56__p_fe55 = 374,
        k_co56__he4_mn52 = 375,
        k_co57__n_co56 = 376,
        k_co57__p_fe56 = 377,
        k_co57__he4_mn53 = 378,
        k_co58__n_co57 = 379,
        k_co58__p_fe57 = 380,
        k_co58__he4_mn54 = 381,
        k_co59__n_co58 = 382,
        k_co59__p_fe58 = 383,
        k_co59__he4_mn55 = 384,
        k_ni56__p_co55 = 385,
        k_ni56__he4_fe52 = 386,
        k_ni57__n_ni56 = 387,
        k_ni57__p_co56 = 388,
        k_ni57__he4_fe53 = 389,
        k_ni58__n_ni57 = 390,
        k_ni58__p_co57 = 391,
        k_ni58__he4_fe54 = 392,
        k_ni59__n_ni58 = 393,
        k_ni59__p_co58 = 394,
        k_ni59__he4_fe55 = 395,
        k_ni60__n_ni59 = 396,
        k_ni60__p_co59 = 397,
        k_ni60__he4_fe56 = 398,
        k_ni61__n_ni60 = 399,
        k_ni61__he4_fe57 = 400,
        k_ni62__n_ni61 = 401,
        k_ni62__he4_fe58 = 402,
        k_ni63__n_ni62 = 403,
        k_ni64__n_ni63 = 404,
        k_cu57__p_ni56 = 405,
        k_cu57__he4_co53 = 406,
        k_cu58__n_cu57 = 407,
        k_cu58__p_ni57 = 408,
        k_cu58__he4_co54 = 409,
        k_cu59__n_cu58 = 410,
        k_cu59__p_ni58 = 411,
        k_cu59__he4_co55 = 412,
        k_cu60__n_cu59 = 413,
        k_cu60__p_ni59 = 414,
        k_cu60__he4_co56 = 415,
        k_cu61__n_cu60 = 416,
        k_cu61__p_ni60 = 417,
        k_cu61__he4_co57 = 418,
        k_cu62__n_cu61 = 419,
        k_cu62__p_ni61 = 420,
        k_cu62__he4_co58 = 421,
        k_cu63__n_cu62 = 422,
        k_cu63__p_ni62 = 423,
        k_cu63__he4_co59 = 424,
        k_cu64__n_cu63 = 425,
        k_cu64__p_ni63 = 426,
        k_cu65__n_cu64 = 427,
        k_cu65__p_ni64 = 428,
        k_zn59__p_cu58 = 429,
        k_zn59__p_ni58__weak__wc12 = 430,
        k_zn60__n_zn59 = 431,
        k_zn60__p_cu59 = 432,
        k_zn60__he4_ni56 = 433,
        k_zn61__n_zn60 = 434,
        k_zn61__p_cu60 = 435,
        k_zn61__he4_ni57 = 436,
        k_zn62__n_zn61 = 437,
        k_zn62__p_cu61 = 438,
        k_zn62__he4_ni58 = 439,
        k_zn63__n_zn62 = 440,
        k_zn63__p_cu62 = 441,
        k_zn63__he4_ni59 = 442,
        k_zn64__n_zn63 = 443,
        k_zn64__p_cu63 = 444,
        k_zn64__he4_ni60 = 445,
        k_zn65__n_zn64 = 446,
        k_zn65__p_cu64 = 447,
        k_zn65__he4_ni61 = 448,
        k_zn66__n_zn65 = 449,
        k_zn66__p_cu65 = 450,
        k_zn66__he4_ni62 = 451,
        k_ga62__p_zn61 = 452,
        k_ga62__he4_cu58 = 453,
        k_ga63__n_ga62 = 454,
        k_ga63__p_zn62 = 455,
        k_ga63__he4_cu59 = 456,
        k_ga64__n_ga63 = 457,
        k_ga64__p_zn63 = 458,
        k_ga64__he4_cu60 = 459,
        k_ge63__p_ga62 = 460,
        k_ge63__he4_zn59 = 461,
        k_ge64__n_ge63 = 462,
        k_ge64__p_ga63 = 463,
        k_ge64__he4_zn60 = 464,
        k_li6__n_p_he4 = 465,
        k_be9__n_he4_he4 = 466,
        k_c12__he4_he4_he4 = 467,
        k_n_p__d = 468,
        k_p_p__d__weak__bet_pos_ = 469,
        k_p_p__d__weak__electron_capture = 470,
        k_p_d__he3 = 471,
        k_d_d__he4 = 472,
        k_he4_d__li6 = 473,
        k_n_he3__he4 = 474,
        k_p_he3__he4__weak__bet_pos_ = 475,
        k_he4_he3__be7 = 476,
        k_n_li6__li7 = 477,
        k_p_li6__be7 = 478,
        k_he4_li6__b10 = 479,
        k_he4_li7__b11 = 480,
        k_p_be7__b8 = 481,
        k_p_be9__b10 = 482,
        k_n_b10__b11 = 483,
        k_p_b11__c12 = 484,
        k_n_c12__c13 = 485,
        k_p_c12__n13 = 486,
        k_he4_c12__o16 = 487,
        k_n_c13__c14 = 488,
        k_p_c13__n14 = 489,
        k_p_c14__n15 = 490,
        k_he4_c14__o18 = 491,
        k_n_n13__n14 = 492,
        k_p_n13__o14 = 493,
        k_n_n14__n15 = 494,
        k_p_n14__o15 = 495,
        k_he4_n14__f18 = 496,
        k_p_n15__o16 = 497,
        k_he4_n15__f19 = 498,
        k_n_o14__o15 = 499,
        k_he4_o14__ne18 = 500,
        k_n_o15__o16 = 501,
        k_he4_o15__ne19 = 502,
        k_n_o16__o17 = 503,
        k_p_o16__f17 = 504,
        k_he4_o16__ne20 = 505,
        k_n_o17__o18 = 506,
        k_p_o17__f18 = 507,
        k_he4_o17__ne21 = 508,
        k_p_o18__f19 = 509,
        k_he4_o18__ne22 = 510,
        k_n_f17__f18 = 511,
        k_p_f17__ne18 = 512,
        k_he4_f17__na21 = 513,
        k_n_f18__f19 = 514,
        k_p_f18__ne19 = 515,
        k_he4_f18__na22 = 516,
        k_p_f19__ne20 = 517,
        k_he4_f19__na23 = 518,
        k_n_ne18__ne19 = 519,
        k_n_ne19__ne20 = 520,
        k_he4_ne19__mg23 = 521,
        k_n_ne20__ne21 = 522,
        k_p_ne20__na21 = 523,
        k_he4_ne20__mg24 = 524,
        k_n_ne21__ne22 = 525,
        k_p_ne21__na22 = 526,
        k_he4_ne21__mg25 = 527,
        k_p_ne22__na23 = 528,
        k_he4_ne22__mg26 = 529,
        k_n_na21__na22 = 530,
        k_he4_na21__al25 = 531,
        k_n_na22__na23 = 532,
        k_p_na22__mg23 = 533,
        k_he4_na22__al26 = 534,
        k_p_na23__mg24 = 535,
        k_he4_na23__al27 = 536,
        k_n_mg23__mg24 = 537,
        k_n_mg24__mg25 = 538,
        k_p_mg24__al25 = 539,
        k_he4_mg24__si28 = 540,
        k_n_mg25__mg26 = 541,
        k_p_mg25__al26 = 542,
        k_he4_mg25__si29 = 543,
        k_p_mg26__al27 = 544,
        k_he4_mg26__si30 = 545,
        k_n_al25__al26 = 546,
        k_he4_al25__p29 = 547,
        k_n_al26__al27 = 548,
        k_he4_al26__p30 = 549,
        k_p_al27__si28 = 550,
        k_he4_al27__p31 = 551,
        k_n_si28__si29 = 552,
        k_p_si28__p29 = 553,
        k_he4_si28__s32 = 554,
        k_n_si29__si30 = 555,
        k_p_si29__p30 = 556,
        k_he4_si29__s33 = 557,
        k_n_si30__si31 = 558,
        k_p_si30__p31 = 559,
        k_he4_si30__s34 = 560,
        k_n_si31__si32 = 561,
        k_p_si31__p32 = 562,
        k_he4_si31__s35 = 563,
        k_p_si32__p33 = 564,
        k_he4_si32__s36 = 565,
        k_n_p29__p30 = 566,
        k_he4_p29__cl33 = 567,
        k_n_p30__p31 = 568,
        k_he4_p30__cl34 = 569,
        k_n_p31__p32 = 570,
        k_p_p31__s32 = 571,
        k_he4_p31__cl35 = 572,
        k_n_p32__p33 = 573,
        k_p_p32__s33 = 574,
        k_he4_p32__cl36 = 575,
        k_p_p33__s34 = 576,
        k_he4_p33__cl37 = 577,
        k_n_s32__s33 = 578,
        k_p_s32__cl33 = 579,
        k_he4_s32__ar36 = 580,
        k_n_s33__s34 = 581,
        k_p_s33__cl34 = 582,
        k_he4_s33__ar37 = 583,
        k_n_s34__s35 = 584,
        k_p_s34__cl35 = 585,
        k_he4_s34__ar38 = 586,
        k_n_s35__s36 = 587,
        k_p_s35__cl36 = 588,
        k_he4_s35__ar39 = 589,
        k_p_s36__cl37 = 590,
        k_he4_s36__ar40 = 591,
        k_n_cl33__cl34 = 592,
        k_he4_cl33__k37 = 593,
        k_n_cl34__cl35 = 594,
        k_he4_cl34__k38 = 595,
        k_n_cl35__cl36 = 596,
        k_p_cl35__ar36 = 597,
        k_he4_cl35__k39 = 598,
        k_n_cl36__cl37 = 599,
        k_p_cl36__ar37 = 600,
        k_he4_cl36__k40 = 601,
        k_p_cl37__ar38 = 602,
        k_he4_cl37__k41 = 603,
        k_n_ar36__ar37 = 604,
        k_p_ar36__k37 = 605,
        k_he4_ar36__ca40 = 606,
        k_n_ar37__ar38 = 607,
        k_p_ar37__k38 = 608,
        k_he4_ar37__ca41 = 609,
        k_n_ar38__ar39 = 610,
        k_p_ar38__k39 = 611,
        k_he4_ar38__ca42 = 612,
        k_n_ar39__ar40 = 613,
        k_p_ar39__k40 = 614,
        k_he4_ar39__ca43 = 615,
        k_p_ar40__k41 = 616,
        k_he4_ar40__ca44 = 617,
        k_n_k37__k38 = 618,
        k_n_k38__k39 = 619,
        k_n_k39__k40 = 620,
        k_p_k39__ca40 = 621,
        k_he4_k39__sc43 = 622,
        k_n_k40__k41 = 623,
        k_p_k40__ca41 = 624,
        k_he4_k40__sc44 = 625,
        k_p_k41__ca42 = 626,
        k_he4_k41__sc45 = 627,
        k_n_ca40__ca41 = 628,
        k_he4_ca40__ti44 = 629,
        k_n_ca41__ca42 = 630,
        k_he4_ca41__ti45 = 631,
        k_n_ca42__ca43 = 632,
        k_p_ca42__sc43 = 633,
        k_he4_ca42__ti46 = 634,
        k_n_ca43__ca44 = 635,
        k_p_ca43__sc44 = 636,
        k_he4_ca43__ti47 = 637,
        k_n_ca44__ca45 = 638,
        k_p_ca44__sc45 = 639,
        k_he4_ca44__ti48 = 640,
        k_n_ca45__ca46 = 641,
        k_p_ca45__sc46 = 642,
        k_he4_ca45__ti49 = 643,
        k_n_ca46__ca47 = 644,
        k_p_ca46__sc47 = 645,
        k_he4_ca46__ti50 = 646,
        k_n_ca47__ca48 = 647,
        k_p_ca47__sc48 = 648,
        k_he4_ca47__ti51 = 649,
        k_p_ca48__sc49 = 650,
        k_n_sc43__sc44 = 651,
        k_p_sc43__ti44 = 652,
        k_he4_sc43__v47 = 653,
        k_n_sc44__sc45 = 654,
        k_p_sc44__ti45 = 655,
        k_he4_sc44__v48 = 656,
        k_n_sc45__sc46 = 657,
        k_p_sc45__ti46 = 658,
        k_he4_sc45__v49 = 659,
        k_n_sc46__sc47 = 660,
        k_p_sc46__ti47 = 661,
        k_he4_sc46__v50 = 662,
        k_n_sc47__sc48 = 663,
        k_p_sc47__ti48 = 664,
        k_he4_sc47__v51 = 665,
        k_n_sc48__sc49 = 666,
        k_p_sc48__ti49 = 667,
        k_he4_sc48__v52 = 668,
        k_p_sc49__ti50 = 669,
        k_n_ti44__ti45 = 670,
        k_he4_ti44__cr48 = 671,
        k_n_ti45__ti46 = 672,
        k_p_ti45__v46 = 673,
        k_he4_ti45__cr49 = 674,
        k_n_ti46__ti47 = 675,
        k_p_ti46__v47 = 676,
        k_he4_ti46__cr50 = 677,
        k_n_ti47__ti48 = 678,
        k_p_ti47__v48 = 679,
        k_he4_ti47__cr51 = 680,
        k_n_ti48__ti49 = 681,
        k_p_ti48__v49 = 682,
        k_he4_ti48__cr52 = 683,
        k_n_ti49__ti50 = 684,
        k_p_ti49__v50 = 685,
        k_he4_ti49__cr53 = 686,
        k_n_ti50__ti51 = 687,
        k_p_ti50__v51 = 688,
        k_he4_ti50__cr54 = 689,
        k_p_ti51__v52 = 690,
        k_n_v46__v47 = 691,
        k_he4_v46__mn50 = 692,
        k_n_v47__v48 = 693,
        k_p_v47__cr48 = 694,
        k_he4_v47__mn51 = 695,
        k_n_v48__v49 = 696,
        k_p_v48__cr49 = 697,
        k_he4_v48__mn52 = 698,
        k_n_v49__v50 = 699,
        k_p_v49__cr50 = 700,
        k_he4_v49__mn53 = 701,
        k_n_v50__v51 = 702,
        k_p_v50__cr51 = 703,
        k_he4_v50__mn54 = 704,
        k_n_v51__v52 = 705,
        k_p_v51__cr52 = 706,
        k_he4_v51__mn55 = 707,
        k_p_v52__cr53 = 708,
        k_n_cr48__cr49 = 709,
        k_he4_cr48__fe52 = 710,
        k_n_cr49__cr50 = 711,
        k_p_cr49__mn50 = 712,
        k_he4_cr49__fe53 = 713,
        k_n_cr50__cr51 = 714,
        k_p_cr50__mn51 = 715,
        k_he4_cr50__fe54 = 716,
        k_n_cr51__cr52 = 717,
        k_p_cr51__mn52 = 718,
        k_he4_cr51__fe55 = 719,
        k_n_cr52__cr53 = 720,
        k_p_cr52__mn53 = 721,
        k_he4_cr52__fe56 = 722,
        k_n_cr53__cr54 = 723,
        k_p_cr53__mn54 = 724,
        k_he4_cr53__fe57 = 725,
        k_p_cr54__mn55 = 726,
        k_he4_cr54__fe58 = 727,
        k_n_mn50__mn51 = 728,
        k_he4_mn50__co54 = 729,
        k_n_mn51__mn52 = 730,
        k_p_mn51__fe52 = 731,
        k_he4_mn51__co55 = 732,
        k_n_mn52__mn53 = 733,
        k_p_mn52__fe53 = 734,
        k_he4_mn52__co56 = 735,
        k_n_mn53__mn54 = 736,
        k_p_mn53__fe54 = 737,
        k_he4_mn53__co57 = 738,
        k_n_mn54__mn55 = 739,
        k_p_mn54__fe55 = 740,
        k_he4_mn54__co58 = 741,
        k_p_mn55__fe56 = 742,
        k_he4_mn55__co59 = 743,
        k_n_fe52__fe53 = 744,
        k_p_fe52__co53 = 745,
        k_he4_fe52__ni56 = 746,
        k_n_fe53__fe54 = 747,
        k_p_fe53__co54 = 748,
        k_he4_fe53__ni57 = 749,
        k_n_fe54__fe55 = 750,
        k_p_fe54__co55 = 751,
        k_he4_fe54__ni58 = 752,
        k_n_fe55__fe56 = 753,
        k_p_fe55__co56 = 754,
        k_he4_fe55__ni59 = 755,
        k_n_fe56__fe57 = 756,
        k_p_fe56__co57 = 757,
        k_he4_fe56__ni60 = 758,
        k_n_fe57__fe58 = 759,
        k_p_fe57__co58 = 760,
        k_he4_fe57__ni61 = 761,
        k_p_fe58__co59 = 762,
        k_he4_fe58__ni62 = 763,
        k_n_co53__co54 = 764,
        k_he4_co53__cu57 = 765,
        k_n_co54__co55 = 766,
        k_he4_co54__cu58 = 767,
        k_n_co55__co56 = 768,
        k_p_co55__ni56 = 769,
        k_he4_co55__cu59 = 770,
        k_n_co56__co57 = 771,
        k_p_co56__ni57 = 772,
        k_he4_co56__cu60 = 773,
        k_n_co57__co58 = 774,
        k_p_co57__ni58 = 775,
        k_he4_co57__cu61 = 776,
        k_n_co58__co59 = 777,
        k_p_co58__ni59 = 778,
        k_he4_co58__cu62 = 779,
        k_p_co59__ni60 = 780,
        k_he4_co59__cu63 = 781,
        k_n_ni56__ni57 = 782,
        k_p_ni56__cu57 = 783,
        k_he4_ni56__zn60 = 784,
        k_n_ni57__ni58 = 785,
        k_p_ni57__cu58 = 786,
        k_he4_ni57__zn61 = 787,
        k_n_ni58__ni59 = 788,
        k_p_ni58__cu59 = 789,
        k_he4_ni58__zn62 = 790,
        k_n_ni59__ni60 = 791,
        k_p_ni59__cu60 = 792,
        k_he4_ni59__zn63 = 793,
        k_n_ni60__ni61 = 794,
        k_p_ni60__cu61 = 795,
        k_he4_ni60__zn64 = 796,
        k_n_ni61__ni62 = 797,
        k_p_ni61__cu62 = 798,
        k_he4_ni61__zn65 = 799,
        k_n_ni62__ni63 = 800,
        k_p_ni62__cu63 = 801,
        k_he4_ni62__zn66 = 802,
        k_n_ni63__ni64 = 803,
        k_p_ni63__cu64 = 804,
        k_p_ni64__cu65 = 805,
        k_n_cu57__cu58 = 806,
        k_n_cu58__cu59 = 807,
        k_p_cu58__zn59 = 808,
        k_he4_cu58__ga62 = 809,
        k_n_cu59__cu60 = 810,
        k_p_cu59__zn60 = 811,
        k_he4_cu59__ga63 = 812,
        k_n_cu60__cu61 = 813,
        k_p_cu60__zn61 = 814,
        k_he4_cu60__ga64 = 815,
        k_n_cu61__cu62 = 816,
        k_p_cu61__zn62 = 817,
        k_n_cu62__cu63 = 818,
        k_p_cu62__zn63 = 819,
        k_n_cu63__cu64 = 820,
        k_p_cu63__zn64 = 821,
        k_n_cu64__cu65 = 822,
        k_p_cu64__zn65 = 823,
        k_p_cu65__zn66 = 824,
        k_n_zn59__zn60 = 825,
        k_he4_zn59__ge63 = 826,
        k_n_zn60__zn61 = 827,
        k_he4_zn60__ge64 = 828,
        k_n_zn61__zn62 = 829,
        k_p_zn61__ga62 = 830,
        k_n_zn62__zn63 = 831,
        k_p_zn62__ga63 = 832,
        k_n_zn63__zn64 = 833,
        k_p_zn63__ga64 = 834,
        k_n_zn64__zn65 = 835,
        k_n_zn65__zn66 = 836,
        k_n_ga62__ga63 = 837,
        k_p_ga62__ge63 = 838,
        k_n_ga63__ga64 = 839,
        k_p_ga63__ge64 = 840,
        k_n_ge63__ge64 = 841,
        k_d_d__n_he3 = 842,
        k_n_he3__d_d = 843,
        k_d_he3__p_he4 = 844,
        k_he4_he3__p_li6 = 845,
        k_p_he4__d_he3 = 846,
        k_he4_he4__n_be7 = 847,
        k_he4_he4__p_li7 = 848,
        k_p_li6__he4_he3 = 849,
        k_d_li6__n_be7 = 850,
        k_d_li6__p_li7 = 851,
        k_he4_li6__p_be9 = 852,
        k_p_li7__n_be7 = 853,
        k_p_li7__d_li6 = 854,
        k_p_li7__he4_he4 = 855,
        k_he4_li7__n_b10 = 856,
        k_n_be7__p_li7 = 857,
        k_n_be7__d_li6 = 858,
        k_n_be7__he4_he4 = 859,
        k_he4_be7__p_b10 = 860,
        k_p_be9__he4_li6 = 861,
        k_he4_be9__n_c12 = 862,
        k_n_b10__he4_li7 = 863,
        k_p_b10__he4_be7 = 864,
        k_he4_b10__n_n13 = 865,
        k_he4_b10__p_c13 = 866,
        k_he4_b11__n_n14 = 867,
        k_he4_b11__p_c14 = 868,
        k_n_c12__he4_be9 = 869,
        k_he4_c12__n_o15 = 870,
        k_he4_c12__p_n15 = 871,
        k_c12_c12__n_mg23 = 872,
        k_c12_c12__p_na23 = 873,
        k_c12_c12__he4_ne20 = 874,
        k_p_c13__n_n13 = 875,
        k_p_c13__he4_b10 = 876,
        k_d_c13__n_n14 = 877,
        k_he4_c13__n_o16 = 878,
        k_p_c14__n_n14 = 879,
        k_p_c14__he4_b11 = 880,
        k_d_c14__n_n15 = 881,
        k_he4_c14__n_o17 = 882,
        k_n_n13__p_c13 = 883,
        k_n_n13__he4_b10 = 884,
        k_he4_n13__p_o16 = 885,
        k_n_n14__p_c14 = 886,
        k_n_n14__d_c13 = 887,
        k_n_n14__he4_b11 = 888,
        k_p_n14__n_o14 = 889,
        k_he4_n14__n_f17 = 890,
        k_he4_n14__p_o17 = 891,
        k_n_n15__d_c14 = 892,
        k_p_n15__n_o15 = 893,
        k_p_n15__he4_c12 = 894,
        k_he4_n15__n_f18 = 895,
        k_he4_n15__p_o18 = 896,
        k_n_o14__p_n14 = 897,
        k_he4_o14__p_f17 = 898,
        k_n_o15__p_n15 = 899,
        k_n_o15__he4_c12 = 900,
        k_he4_o15__n_ne18 = 901,
        k_he4_o15__p_f18 = 902,
        k_n_o16__he4_c13 = 903,
        k_p_o16__he4_n13 = 904,
        k_he4_o16__n_ne19 = 905,
        k_he4_o16__p_f19 = 906,
        k_c12_o16__p_al27 = 907,
        k_c12_o16__he4_mg24 = 908,
        k_o16_o16__p_p31 = 909,
        k_o16_o16__he4_si28 = 910,
        k_n_o17__he4_c14 = 911,
        k_p_o17__n_f17 = 912,
        k_p_o17__he4_n14 = 913,
        k_he4_o17__n_ne20 = 914,
        k_p_o18__n_f18 = 915,
        k_p_o18__he4_n15 = 916,
        k_he4_o18__n_ne21 = 917,
        k_n_f17__p_o17 = 918,
        k_n_f17__he4_n14 = 919,
        k_p_f17__he4_o14 = 920,
        k_he4_f17__p_ne20 = 921,
        k_n_f18__p_o18 = 922,
        k_n_f18__he4_n15 = 923,
        k_p_f18__n_ne18 = 924,
        k_p_f18__he4_o15 = 925,
        k_he4_f18__n_na21 = 926,
        k_he4_f18__p_ne21 = 927,
        k_p_f19__n_ne19 = 928,
        k_p_f19__he4_o16 = 929,
        k_he4_f19__n_na22 = 930,
        k_he4_f19__p_ne22 = 931,
        k_n_ne18__p_f18 = 932,
        k_n_ne18__he4_o15 = 933,
        k_he4_ne18__p_na21 = 934,
        k_n_ne19__p_f19 = 935,
        k_n_ne19__he4_o16 = 936,
        k_he4_ne19__p_na22 = 937,
        k_n_ne20__he4_o17 = 938,
        k_p_ne20__he4_f17 = 939,
        k_he4_ne20__n_mg23 = 940,
        k_he4_ne20__p_na23 = 941,
        k_he4_ne20__c12_c12 = 942,
        k_c12_ne20__p_p31 = 943,
        k_c12_ne20__he4_si28 = 944,
        k_n_ne21__he4_o18 = 945,
        k_p_ne21__n_na21 = 946,
        k_p_ne21__he4_f18 = 947,
        k_he4_ne21__n_mg24 = 948,
        k_p_ne22__n_na22 = 949,
        k_p_ne22__he4_f19 = 950,
        k_he4_ne22__n_mg25 = 951,
        k_n_na21__p_ne21 = 952,
        k_n_na21__he4_f18 = 953,
        k_p_na21__he4_ne18 = 954,
        k_he4_na21__p_mg24 = 955,
        k_n_na22__p_ne22 = 956,
        k_n_na22__he4_f19 = 957,
        k_p_na22__he4_ne19 = 958,
        k_he4_na22__n_al25 = 959,
        k_he4_na22__p_mg25 = 960,
        k_p_na23__n_mg23 = 961,
        k_p_na23__he4_ne20 = 962,
        k_p_na23__c12_c12 = 963,
        k_he4_na23__n_al26 = 964,
        k_he4_na23__p_mg26 = 965,
        k_n_mg23__p_na23 = 966,
        k_n_mg23__he4_ne20 = 967,
        k_n_mg23__c12_c12 = 968,
        k_he4_mg23__p_al26 = 969,
        k_n_mg24__he4_ne21 = 970,
        k_p_mg24__he4_na21 = 971,
        k_he4_mg24__p_al27 = 972,
        k_he4_mg24__c12_o16 = 973,
        k_n_mg25__he4_ne22 = 974,
        k_p_mg25__n_al25 = 975,
        k_p_mg25__he4_na22 = 976,
        k_he4_mg25__n_si28 = 977,
        k_p_mg26__n_al26 = 978,
        k_p_mg26__he4_na23 = 979,
        k_he4_mg26__n_si29 = 980,
        k_n_al25__p_mg25 = 981,
        k_n_al25__he4_na22 = 982,
        k_he4_al25__p_si28 = 983,
        k_n_al26__p_mg26 = 984,
        k_n_al26__he4_na23 = 985,
        k_p_al26__he4_mg23 = 986,
        k_he4_al26__n_p29 = 987,
        k_he4_al26__p_si29 = 988,
        k_p_al27__he4_mg24 = 989,
        k_p_al27__c12_o16 = 990,
        k_he4_al27__n_p30 = 991,
        k_he4_al27__p_si30 = 992,
        k_n_si28__he4_mg25 = 993,
        k_p_si28__he4_al25 = 994,
        k_he4_si28__p_p31 = 995,
        k_he4_si28__c12_ne20 = 996,
        k_he4_si28__o16_o16 = 997,
        k_n_si29__he4_mg26 = 998,
        k_p_si29__n_p29 = 999,
        k_p_si29__he4_al26 = 1000,
        k_he4_si29__n_s32 = 1001,
        k_he4_si29__p_p32 = 1002,
        k_p_si30__n_p30 = 1003,
        k_p_si30__he4_al27 = 1004,
        k_he4_si30__n_s33 = 1005,
        k_he4_si30__p_p33 = 1006,
        k_p_si31__n_p31 = 1007,
        k_he4_si31__n_s34 = 1008,
        k_p_si32__n_p32 = 1009,
        k_he4_si32__n_s35 = 1010,
        k_n_p29__p_si29 = 1011,
        k_n_p29__he4_al26 = 1012,
        k_he4_p29__p_s32 = 1013,
        k_n_p30__p_si30 = 1014,
        k_n_p30__he4_al27 = 1015,
        k_he4_p30__n_cl33 = 1016,
        k_he4_p30__p_s33 = 1017,
        k_n_p31__p_si31 = 1018,
        k_p_p31__he4_si28 = 1019,
        k_p_p31__c12_ne20 = 1020,
        k_p_p31__o16_o16 = 1021,
        k_he4_p31__n_cl34 = 1022,
        k_he4_p31__p_s34 = 1023,
        k_n_p32__p_si32 = 1024,
        k_p_p32__n_s32 = 1025,
        k_p_p32__he4_si29 = 1026,
        k_he4_p32__n_cl35 = 1027,
        k_he4_p32__p_s35 = 1028,
        k_p_p33__n_s33 = 1029,
        k_p_p33__he4_si30 = 1030,
        k_he4_p33__n_cl36 = 1031,
        k_he4_p33__p_s36 = 1032,
        k_n_s32__p_p32 = 1033,
        k_n_s32__he4_si29 = 1034,
        k_p_s32__he4_p29 = 1035,
        k_he4_s32__p_cl35 = 1036,
        k_n_s33__p_p33 = 1037,
        k_n_s33__he4_si30 = 1038,
        k_p_s33__n_cl33 = 1039,
        k_p_s33__he4_p30 = 1040,
        k_he4_s33__n_ar36 = 1041,
        k_he4_s33__p_cl36 = 1042,
        k_n_s34__he4_si31 = 1043,
        k_p_s34__n_cl34 = 1044,
        k_p_s34__he4_p31 = 1045,
        k_he4_s34__n_ar37 = 1046,
        k_he4_s34__p_cl37 = 1047,
        k_n_s35__he4_si32 = 1048,
        k_p_s35__n_cl35 = 1049,
        k_p_s35__he4_p32 = 1050,
        k_he4_s35__n_ar38 = 1051,
        k_p_s36__n_cl36 = 1052,
        k_p_s36__he4_p33 = 1053,
        k_he4_s36__n_ar39 = 1054,
        k_n_cl33__p_s33 = 1055,
        k_n_cl33__he4_p30 = 1056,
        k_he4_cl33__p_ar36 = 1057,
        k_n_cl34__p_s34 = 1058,
        k_n_cl34__he4_p31 = 1059,
        k_he4_cl34__n_k37 = 1060,
        k_he4_cl34__p_ar37 = 1061,
        k_n_cl35__p_s35 = 1062,
        k_n_cl35__he4_p32 = 1063,
        k_p_cl35__he4_s32 = 1064,
        k_he4_cl35__n_k38 = 1065,
        k_he4_cl35__p_ar38 = 1066,
        k_n_cl36__p_s36 = 1067,
        k_n_cl36__he4_p33 = 1068,
        k_p_cl36__n_ar36 = 1069,
        k_p_cl36__he4_s33 = 1070,
        k_he4_cl36__n_k39 = 1071,
        k_he4_cl36__p_ar39 = 1072,
        k_p_cl37__n_ar37 = 1073,
        k_p_cl37__he4_s34 = 1074,
        k_he4_cl37__n_k40 = 1075,
        k_he4_cl37__p_ar40 = 1076,
        k_n_ar36__p_cl36 = 1077,
        k_n_ar36__he4_s33 = 1078,
        k_p_ar36__he4_cl33 = 1079,
        k_he4_ar36__p_k39 = 1080,
        k_n_ar37__p_cl37 = 1081,
        k_n_ar37__he4_s34 = 1082,
        k_p_ar37__n_k37 = 1083,
        k_p_ar37__he4_cl34 = 1084,
        k_he4_ar37__n_ca40 = 1085,
        k_he4_ar37__p_k40 = 1086,
        k_n_ar38__he4_s35 = 1087,
        k_p_ar38__n_k38 = 1088,
        k_p_ar38__he4_cl35 = 1089,
        k_he4_ar38__n_ca41 = 1090,
        k_he4_ar38__p_k41 = 1091,
        k_n_ar39__he4_s36 = 1092,
        k_p_ar39__n_k39 = 1093,
        k_p_ar39__he4_cl36 = 1094,
        k_he4_ar39__n_ca42 = 1095,
        k_p_ar40__n_k40 = 1096,
        k_p_ar40__he4_cl37 = 1097,
        k_he4_ar40__n_ca43 = 1098,
        k_n_k37__p_ar37 = 1099,
        k_n_k37__he4_cl34 = 1100,
        k_he4_k37__p_ca40 = 1101,
        k_n_k38__p_ar38 = 1102,
        k_n_k38__he4_cl35 = 1103,
        k_he4_k38__p_ca41 = 1104,
        k_n_k39__p_ar39 = 1105,
        k_n_k39__he4_cl36 = 1106,
        k_p_k39__he4_ar36 = 1107,
        k_he4_k39__p_ca42 = 1108,
        k_n_k40__p_ar40 = 1109,
        k_n_k40__he4_cl37 = 1110,
        k_p_k40__n_ca40 = 1111,
        k_p_k40__he4_ar37 = 1112,
        k_he4_k40__n_sc43 = 1113,
        k_he4_k40__p_ca43 = 1114,
        k_p_k41__n_ca41 = 1115,
        k_p_k41__he4_ar38 = 1116,
        k_he4_k41__n_sc44 = 1117,
        k_he4_k41__p_ca44 = 1118,
        k_n_ca40__p_k40 = 1119,
        k_n_ca40__he4_ar37 = 1120,
        k_p_ca40__he4_k37 = 1121,
        k_he4_ca40__p_sc43 = 1122,
        k_n_ca41__p_k41 = 1123,
        k_n_ca41__he4_ar38 = 1124,
        k_p_ca41__he4_k38 = 1125,
        k_he4_ca41__n_ti44 = 1126,
        k_he4_ca41__p_sc44 = 1127,
        k_n_ca42__he4_ar39 = 1128,
        k_p_ca42__he4_k39 = 1129,
        k_he4_ca42__n_ti45 = 1130,
        k_he4_ca42__p_sc45 = 1131,
        k_n_ca43__he4_ar40 = 1132,
        k_p_ca43__n_sc43 = 1133,
        k_p_ca43__he4_k40 = 1134,
        k_he4_ca43__n_ti46 = 1135,
        k_he4_ca43__p_sc46 = 1136,
        k_p_ca44__n_sc44 = 1137,
        k_p_ca44__he4_k41 = 1138,
        k_he4_ca44__n_ti47 = 1139,
        k_he4_ca44__p_sc47 = 1140,
        k_p_ca45__n_sc45 = 1141,
        k_he4_ca45__n_ti48 = 1142,
        k_he4_ca45__p_sc48 = 1143,
        k_p_ca46__n_sc46 = 1144,
        k_he4_ca46__n_ti49 = 1145,
        k_he4_ca46__p_sc49 = 1146,
        k_p_ca47__n_sc47 = 1147,
        k_he4_ca47__n_ti50 = 1148,
        k_p_ca48__n_sc48 = 1149,
        k_he4_ca48__n_ti51 = 1150,
        k_n_sc43__p_ca43 = 1151,
        k_n_sc43__he4_k40 = 1152,
        k_p_sc43__he4_ca40 = 1153,
        k_he4_sc43__n_v46 = 1154,
        k_he4_sc43__p_ti46 = 1155,
        k_n_sc44__p_ca44 = 1156,
        k_n_sc44__he4_k41 = 1157,
        k_p_sc44__n_ti44 = 1158,
        k_p_sc44__he4_ca41 = 1159,
        k_he4_sc44__n_v47 = 1160,
        k_he4_sc44__p_ti47 = 1161,
        k_n_sc45__p_ca45 = 1162,
        k_p_sc45__n_ti45 = 1163,
        k_p_sc45__he4_ca42 = 1164,
        k_he4_sc45__n_v48 = 1165,
        k_he4_sc45__p_ti48 = 1166,
        k_n_sc46__p_ca46 = 1167,
        k_p_sc46__n_ti46 = 1168,
        k_p_sc46__he4_ca43 = 1169,
        k_he4_sc46__n_v49 = 1170,
        k_he4_sc46__p_ti49 = 1171,
        k_n_sc47__p_ca47 = 1172,
        k_p_sc47__n_ti47 = 1173,
        k_p_sc47__he4_ca44 = 1174,
        k_he4_sc47__n_v50 = 1175,
        k_he4_sc47__p_ti50 = 1176,
        k_n_sc48__p_ca48 = 1177,
        k_p_sc48__n_ti48 = 1178,
        k_p_sc48__he4_ca45 = 1179,
        k_he4_sc48__n_v51 = 1180,
        k_he4_sc48__p_ti51 = 1181,
        k_p_sc49__n_ti49 = 1182,
        k_p_sc49__he4_ca46 = 1183,
        k_he4_sc49__n_v52 = 1184,
        k_n_ti44__p_sc44 = 1185,
        k_n_ti44__he4_ca41 = 1186,
        k_he4_ti44__p_v47 = 1187,
        k_n_ti45__p_sc45 = 1188,
        k_n_ti45__he4_ca42 = 1189,
        k_he4_ti45__n_cr48 = 1190,
        k_he4_ti45__p_v48 = 1191,
        k_n_ti46__p_sc46 = 1192,
        k_n_ti46__he4_ca43 = 1193,
        k_p_ti46__n_v46 = 1194,
        k_p_ti46__he4_sc43 = 1195,
        k_he4_ti46__n_cr49 = 1196,
        k_he4_ti46__p_v49 = 1197,
        k_n_ti47__p_sc47 = 1198,
        k_n_ti47__he4_ca44 = 1199,
        k_p_ti47__n_v47 = 1200,
        k_p_ti47__he4_sc44 = 1201,
        k_he4_ti47__n_cr50 = 1202,
        k_he4_ti47__p_v50 = 1203,
        k_n_ti48__p_sc48 = 1204,
        k_n_ti48__he4_ca45 = 1205,
        k_p_ti48__n_v48 = 1206,
        k_p_ti48__he4_sc45 = 1207,
        k_he4_ti48__n_cr51 = 1208,
        k_he4_ti48__p_v51 = 1209,
        k_n_ti49__p_sc49 = 1210,
        k_n_ti49__he4_ca46 = 1211,
        k_p_ti49__n_v49 = 1212,
        k_p_ti49__he4_sc46 = 1213,
        k_he4_ti49__n_cr52 = 1214,
        k_he4_ti49__p_v52 = 1215,
        k_n_ti50__he4_ca47 = 1216,
        k_p_ti50__n_v50 = 1217,
        k_p_ti50__he4_sc47 = 1218,
        k_he4_ti50__n_cr53 = 1219,
        k_n_ti51__he4_ca48 = 1220,
        k_p_ti51__n_v51 = 1221,
        k_p_ti51__he4_sc48 = 1222,
        k_he4_ti51__n_cr54 = 1223,
        k_n_v46__p_ti46 = 1224,
        k_n_v46__he4_sc43 = 1225,
        k_he4_v46__p_cr49 = 1226,
        k_n_v47__p_ti47 = 1227,
        k_n_v47__he4_sc44 = 1228,
        k_p_v47__he4_ti44 = 1229,
        k_he4_v47__n_mn50 = 1230,
        k_he4_v47__p_cr50 = 1231,
        k_n_v48__p_ti48 = 1232,
        k_n_v48__he4_sc45 = 1233,
        k_p_v48__n_cr48 = 1234,
        k_p_v48__he4_ti45 = 1235,
        k_he4_v48__n_mn51 = 1236,
        k_he4_v48__p_cr51 = 1237,
        k_n_v49__p_ti49 = 1238,
        k_n_v49__he4_sc46 = 1239,
        k_p_v49__n_cr49 = 1240,
        k_p_v49__he4_ti46 = 1241,
        k_he4_v49__n_mn52 = 1242,
        k_he4_v49__p_cr52 = 1243,
        k_n_v50__p_ti50 = 1244,
        k_n_v50__he4_sc47 = 1245,
        k_p_v50__n_cr50 = 1246,
        k_p_v50__he4_ti47 = 1247,
        k_he4_v50__n_mn53 = 1248,
        k_he4_v50__p_cr53 = 1249,
        k_n_v51__p_ti51 = 1250,
        k_n_v51__he4_sc48 = 1251,
        k_p_v51__n_cr51 = 1252,
        k_p_v51__he4_ti48 = 1253,
        k_he4_v51__n_mn54 = 1254,
        k_he4_v51__p_cr54 = 1255,
        k_n_v52__he4_sc49 = 1256,
        k_p_v52__n_cr52 = 1257,
        k_p_v52__he4_ti49 = 1258,
        k_he4_v52__n_mn55 = 1259,
        k_n_cr48__p_v48 = 1260,
        k_n_cr48__he4_ti45 = 1261,
        k_he4_cr48__p_mn51 = 1262,
        k_n_cr49__p_v49 = 1263,
        k_n_cr49__he4_ti46 = 1264,
        k_p_cr49__he4_v46 = 1265,
        k_he4_cr49__n_fe52 = 1266,
        k_he4_cr49__p_mn52 = 1267,
        k_n_cr50__p_v50 = 1268,
        k_n_cr50__he4_ti47 = 1269,
        k_p_cr50__n_mn50 = 1270,
        k_p_cr50__he4_v47 = 1271,
        k_he4_cr50__n_fe53 = 1272,
        k_he4_cr50__p_mn53 = 1273,
        k_n_cr51__p_v51 = 1274,
        k_n_cr51__he4_ti48 = 1275,
        k_p_cr51__n_mn51 = 1276,
        k_p_cr51__he4_v48 = 1277,
        k_he4_cr51__n_fe54 = 1278,
        k_he4_cr51__p_mn54 = 1279,
        k_n_cr52__p_v52 = 1280,
        k_n_cr52__he4_ti49 = 1281,
        k_p_cr52__n_mn52 = 1282,
        k_p_cr52__he4_v49 = 1283,
        k_he4_cr52__n_fe55 = 1284,
        k_he4_cr52__p_mn55 = 1285,
        k_n_cr53__he4_ti50 = 1286,
        k_p_cr53__n_mn53 = 1287,
        k_p_cr53__he4_v50 = 1288,
        k_he4_cr53__n_fe56 = 1289,
        k_n_cr54__he4_ti51 = 1290,
        k_p_cr54__n_mn54 = 1291,
        k_p_cr54__he4_v51 = 1292,
        k_he4_cr54__n_fe57 = 1293,
        k_n_mn50__p_cr50 = 1294,
        k_n_mn50__he4_v47 = 1295,
        k_he4_mn50__n_co53 = 1296,
        k_he4_mn50__p_fe53 = 1297,
        k_n_mn51__p_cr51 = 1298,
        k_n_mn51__he4_v48 = 1299,
        k_p_mn51__he4_cr48 = 1300,
        k_he4_mn51__n_co54 = 1301,
        k_he4_mn51__p_fe54 = 1302,
        k_n_mn52__p_cr52 = 1303,
        k_n_mn52__he4_v49 = 1304,
        k_p_mn52__n_fe52 = 1305,
        k_p_mn52__he4_cr49 = 1306,
        k_he4_mn52__n_co55 = 1307,
        k_he4_mn52__p_fe55 = 1308,
        k_n_mn53__p_cr53 = 1309,
        k_n_mn53__he4_v50 = 1310,
        k_p_mn53__n_fe53 = 1311,
        k_p_mn53__he4_cr50 = 1312,
        k_he4_mn53__n_co56 = 1313,
        k_he4_mn53__p_fe56 = 1314,
        k_n_mn54__p_cr54 = 1315,
        k_n_mn54__he4_v51 = 1316,
        k_p_mn54__n_fe54 = 1317,
        k_p_mn54__he4_cr51 = 1318,
        k_he4_mn54__n_co57 = 1319,
        k_he4_mn54__p_fe57 = 1320,
        k_n_mn55__he4_v52 = 1321,
        k_p_mn55__n_fe55 = 1322,
        k_p_mn55__he4_cr52 = 1323,
        k_he4_mn55__n_co58 = 1324,
        k_he4_mn55__p_fe58 = 1325,
        k_n_fe52__p_mn52 = 1326,
        k_n_fe52__he4_cr49 = 1327,
        k_he4_fe52__p_co55 = 1328,
        k_n_fe53__p_mn53 = 1329,
        k_n_fe53__he4_cr50 = 1330,
        k_p_fe53__n_co53 = 1331,
        k_p_fe53__he4_mn50 = 1332,
        k_he4_fe53__n_ni56 = 1333,
        k_he4_fe53__p_co56 = 1334,
        k_n_fe54__p_mn54 = 1335,
        k_n_fe54__he4_cr51 = 1336,
        k_p_fe54__n_co54 = 1337,
        k_p_fe54__he4_mn51 = 1338,
        k_he4_fe54__n_ni57 = 1339,
        k_he4_fe54__p_co57 = 1340,
        k_n_fe55__p_mn55 = 1341,
        k_n_fe55__he4_cr52 = 1342,
        k_p_fe55__n_co55 = 1343,
        k_p_fe55__he4_mn52 = 1344,
        k_he4_fe55__n_ni58 = 1345,
        k_he4_fe55__p_co58 = 1346,
        k_n_fe56__he4_cr53 = 1347,
        k_p_fe56__n_co56 = 1348,
        k_p_fe56__he4_mn53 = 1349,
        k_he4_fe56__n_ni59 = 1350,
        k_he4_fe56__p_co59 = 1351,
        k_n_fe57__he4_cr54 = 1352,
        k_p_fe57__n_co57 = 1353,
        k_p_fe57__he4_mn54 = 1354,
        k_he4_fe57__n_ni60 = 1355,
        k_p_fe58__n_co58 = 1356,
        k_p_fe58__he4_mn55 = 1357,
        k_he4_fe58__n_ni61 = 1358,
        k_n_co53__p_fe53 = 1359,
        k_n_co53__he4_mn50 = 1360,
        k_he4_co53__p_ni56 = 1361,
        k_n_co54__p_fe54 = 1362,
        k_n_co54__he4_mn51 = 1363,
        k_he4_co54__n_cu57 = 1364,
        k_he4_co54__p_ni57 = 1365,
        k_n_co55__p_fe55 = 1366,
        k_n_co55__he4_mn52 = 1367,
        k_p_co55__he4_fe52 = 1368,
        k_he4_co55__n_cu58 = 1369,
        k_he4_co55__p_ni58 = 1370,
        k_n_co56__p_fe56 = 1371,
        k_n_co56__he4_mn53 = 1372,
        k_p_co56__n_ni56 = 1373,
        k_p_co56__he4_fe53 = 1374,
        k_he4_co56__n_cu59 = 1375,
        k_he4_co56__p_ni59 = 1376,
        k_n_co57__p_fe57 = 1377,
        k_n_co57__he4_mn54 = 1378,
        k_p_co57__n_ni57 = 1379,
        k_p_co57__he4_fe54 = 1380,
        k_he4_co57__n_cu60 = 1381,
        k_he4_co57__p_ni60 = 1382,
        k_n_co58__p_fe58 = 1383,
        k_n_co58__he4_mn55 = 1384,
        k_p_co58__n_ni58 = 1385,
        k_p_co58__he4_fe55 = 1386,
        k_he4_co58__n_cu61 = 1387,
        k_he4_co58__p_ni61 = 1388,
        k_p_co59__n_ni59 = 1389,
        k_p_co59__he4_fe56 = 1390,
        k_he4_co59__n_cu62 = 1391,
        k_he4_co59__p_ni62 = 1392,
        k_n_ni56__p_co56 = 1393,
        k_n_ni56__he4_fe53 = 1394,
        k_p_ni56__he4_co53 = 1395,
        k_he4_ni56__n_zn59 = 1396,
        k_he4_ni56__p_cu59 = 1397,
        k_n_ni57__p_co57 = 1398,
        k_n_ni57__he4_fe54 = 1399,
        k_p_ni57__n_cu57 = 1400,
        k_p_ni57__he4_co54 = 1401,
        k_he4_ni57__n_zn60 = 1402,
        k_he4_ni57__p_cu60 = 1403,
        k_n_ni58__p_co58 = 1404,
        k_n_ni58__he4_fe55 = 1405,
        k_p_ni58__n_cu58 = 1406,
        k_p_ni58__he4_co55 = 1407,
        k_he4_ni58__n_zn61 = 1408,
        k_he4_ni58__p_cu61 = 1409,
        k_n_ni59__p_co59 = 1410,
        k_n_ni59__he4_fe56 = 1411,
        k_p_ni59__n_cu59 = 1412,
        k_p_ni59__he4_co56 = 1413,
        k_he4_ni59__n_zn62 = 1414,
        k_he4_ni59__p_cu62 = 1415,
        k_n_ni60__he4_fe57 = 1416,
        k_p_ni60__n_cu60 = 1417,
        k_p_ni60__he4_co57 = 1418,
        k_he4_ni60__n_zn63 = 1419,
        k_he4_ni60__p_cu63 = 1420,
        k_n_ni61__he4_fe58 = 1421,
        k_p_ni61__n_cu61 = 1422,
        k_p_ni61__he4_co58 = 1423,
        k_he4_ni61__n_zn64 = 1424,
        k_he4_ni61__p_cu64 = 1425,
        k_p_ni62__n_cu62 = 1426,
        k_p_ni62__he4_co59 = 1427,
        k_he4_ni62__n_zn65 = 1428,
        k_he4_ni62__p_cu65 = 1429,
        k_p_ni63__n_cu63 = 1430,
        k_he4_ni63__n_zn66 = 1431,
        k_p_ni64__n_cu64 = 1432,
        k_n_cu57__p_ni57 = 1433,
        k_n_cu57__he4_co54 = 1434,
        k_he4_cu57__p_zn60 = 1435,
        k_n_cu58__p_ni58 = 1436,
        k_n_cu58__he4_co55 = 1437,
        k_he4_cu58__p_zn61 = 1438,
        k_n_cu59__p_ni59 = 1439,
        k_n_cu59__he4_co56 = 1440,
        k_p_cu59__n_zn59 = 1441,
        k_p_cu59__he4_ni56 = 1442,
        k_he4_cu59__n_ga62 = 1443,
        k_he4_cu59__p_zn62 = 1444,
        k_n_cu60__p_ni60 = 1445,
        k_n_cu60__he4_co57 = 1446,
        k_p_cu60__n_zn60 = 1447,
        k_p_cu60__he4_ni57 = 1448,
        k_he4_cu60__n_ga63 = 1449,
        k_he4_cu60__p_zn63 = 1450,
        k_n_cu61__p_ni61 = 1451,
        k_n_cu61__he4_co58 = 1452,
        k_p_cu61__n_zn61 = 1453,
        k_p_cu61__he4_ni58 = 1454,
        k_he4_cu61__n_ga64 = 1455,
        k_he4_cu61__p_zn64 = 1456,
        k_n_cu62__p_ni62 = 1457,
        k_n_cu62__he4_co59 = 1458,
        k_p_cu62__n_zn62 = 1459,
        k_p_cu62__he4_ni59 = 1460,
        k_he4_cu62__p_zn65 = 1461,
        k_n_cu63__p_ni63 = 1462,
        k_p_cu63__n_zn63 = 1463,
        k_p_cu63__he4_ni60 = 1464,
        k_he4_cu63__p_zn66 = 1465,
        k_n_cu64__p_ni64 = 1466,
        k_p_cu64__n_zn64 = 1467,
        k_p_cu64__he4_ni61 = 1468,
        k_p_cu65__n_zn65 = 1469,
        k_p_cu65__he4_ni62 = 1470,
        k_n_zn59__p_cu59 = 1471,
        k_n_zn59__he4_ni56 = 1472,
        k_he4_zn59__p_ga62 = 1473,
        k_n_zn60__p_cu60 = 1474,
        k_n_zn60__he4_ni57 = 1475,
        k_p_zn60__he4_cu57 = 1476,
        k_he4_zn60__n_ge63 = 1477,
        k_he4_zn60__p_ga63 = 1478,
        k_n_zn61__p_cu61 = 1479,
        k_n_zn61__he4_ni58 = 1480,
        k_p_zn61__he4_cu58 = 1481,
        k_he4_zn61__n_ge64 = 1482,
        k_he4_zn61__p_ga64 = 1483,
        k_n_zn62__p_cu62 = 1484,
        k_n_zn62__he4_ni59 = 1485,
        k_p_zn62__n_ga62 = 1486,
        k_p_zn62__he4_cu59 = 1487,
        k_n_zn63__p_cu63 = 1488,
        k_n_zn63__he4_ni60 = 1489,
        k_p_zn63__n_ga63 = 1490,
        k_p_zn63__he4_cu60 = 1491,
        k_n_zn64__p_cu64 = 1492,
        k_n_zn64__he4_ni61 = 1493,
        k_p_zn64__n_ga64 = 1494,
        k_p_zn64__he4_cu61 = 1495,
        k_n_zn65__p_cu65 = 1496,
        k_n_zn65__he4_ni62 = 1497,
        k_p_zn65__he4_cu62 = 1498,
        k_n_zn66__he4_ni63 = 1499,
        k_p_zn66__he4_cu63 = 1500,
        k_n_ga62__p_zn62 = 1501,
        k_n_ga62__he4_cu59 = 1502,
        k_p_ga62__he4_zn59 = 1503,
        k_n_ga63__p_zn63 = 1504,
        k_n_ga63__he4_cu60 = 1505,
        k_p_ga63__n_ge63 = 1506,
        k_p_ga63__he4_zn60 = 1507,
        k_n_ga64__p_zn64 = 1508,
        k_n_ga64__he4_cu61 = 1509,
        k_p_ga64__n_ge64 = 1510,
        k_p_ga64__he4_zn61 = 1511,
        k_n_ge63__p_ga63 = 1512,
        k_n_ge63__he4_zn60 = 1513,
        k_n_ge64__p_ga64 = 1514,
        k_n_ge64__he4_zn61 = 1515,
        k_p_d__n_p_p = 1516,
        k_he3_he3__p_p_he4 = 1517,
        k_d_li7__n_he4_he4 = 1518,
        k_d_be7__p_he4_he4 = 1519,
        k_p_be9__d_he4_he4 = 1520,
        k_n_b8__p_he4_he4 = 1521,
        k_p_b11__he4_he4_he4 = 1522,
        k_he3_li7__n_p_he4_he4 = 1523,
        k_he3_be7__p_p_he4_he4 = 1524,
        k_p_be9__n_p_he4_he4 = 1525,
        k_n_p_he4__li6 = 1526,
        k_n_he4_he4__be9 = 1527,
        k_he4_he4_he4__c12 = 1528,
        k_n_p_p__p_d = 1529,
        k_p_p_he4__he3_he3 = 1530,
        k_n_he4_he4__d_li7 = 1531,
        k_p_he4_he4__n_b8 = 1532,
        k_p_he4_he4__d_be7 = 1533,
        k_d_he4_he4__p_be9 = 1534,
        k_he4_he4_he4__p_b11 = 1535,
        k_n_p_he4_he4__he3_li7 = 1536,
        k_n_p_he4_he4__p_be9 = 1537,
        k_p_p_he4_he4__he3_be7 = 1538,
        NumRates = k_p_p_he4_he4__he3_be7
    };

    // number of reaclib rates

    const int NrateReaclib = 1538;
    const int NumReaclibSets = 1982;

    // number of tabular rates

    const int NrateTabular = 0;

    // rate names -- note: the rates are 1-based, not zero-based, so we pad
    // this vector with rate_names[0] = "" so the indices line up with the
    // NetworkRates enum

    static const std::vector<std::string> rate_names = {
        "",   // 0
        "n__p__weak__wc12",  // 1,
        "be7__li7__weak__electron_capture",  // 2,
        "c14__n14__weak__wc12",  // 3,
        "n13__c13__weak__wc12",  // 4,
        "o14__n14__weak__wc12",  // 5,
        "o15__n15__weak__wc12",  // 6,
        "f17__o17__weak__wc12",  // 7,
        "f18__o18__weak__wc12",  // 8,
        "ne18__f18__weak__wc12",  // 9,
        "ne19__f19__weak__wc12",  // 10,
        "na21__ne21__weak__wc12",  // 11,
        "na22__ne22__weak__wc12",  // 12,
        "mg23__na23__weak__wc12",  // 13,
        "al25__mg25__weak__wc12",  // 14,
        "al26__mg26__weak__wc12",  // 15,
        "si31__p31__weak__wc12",  // 16,
        "si32__p32__weak__wc12",  // 17,
        "p29__si29__weak__wc12",  // 18,
        "p30__si30__weak__wc12",  // 19,
        "p32__s32__weak__wc12",  // 20,
        "p33__s33__weak__wc12",  // 21,
        "s35__cl35__weak__wc12",  // 22,
        "cl33__s33__weak__wc12",  // 23,
        "cl34__s34__weak__wc12",  // 24,
        "cl36__ar36__weak__wc12",  // 25,
        "cl36__s36__weak__wc12",  // 26,
        "ar37__cl37__weak__wc12",  // 27,
        "ar39__k39__weak__wc12",  // 28,
        "k37__ar37__weak__wc12",  // 29,
        "k38__ar38__weak__wc12",  // 30,
        "k40__ca40__weak__wc12",  // 31,
        "k40__ar40__weak__wc12",  // 32,
        "ca41__k41__weak__wc12",  // 33,
        "ca45__sc45__weak__wc12",  // 34,
        "ca47__sc47__weak__wc12",  // 35,
        "ca48__sc48__weak__mo03",  // 36,
        "sc43__ca43__weak__wc12",  // 37,
        "sc44__ca44__weak__wc12",  // 38,
        "sc46__ti46__weak__wc12",  // 39,
        "sc47__ti47__weak__wc12",  // 40,
        "sc48__ti48__weak__wc12",  // 41,
        "sc49__ti49__weak__wc12",  // 42,
        "ti44__sc44__weak__wc12",  // 43,
        "ti45__sc45__weak__wc12",  // 44,
        "ti51__v51__weak__wc12",  // 45,
        "v46__ti46__weak__wc12",  // 46,
        "v47__ti47__weak__wc12",  // 47,
        "v48__ti48__weak__wc12",  // 48,
        "v49__ti49__weak__wc12",  // 49,
        "v50__ti50__weak__mo03",  // 50,
        "v52__cr52__weak__wc12",  // 51,
        "cr48__v48__weak__wc12",  // 52,
        "cr49__v49__weak__wc12",  // 53,
        "cr51__v51__weak__wc12",  // 54,
        "mn50__cr50__weak__wc12",  // 55,
        "mn51__cr51__weak__wc12",  // 56,
        "mn52__cr52__weak__wc12",  // 57,
        "mn53__cr53__weak__wc12",  // 58,
        "mn54__cr54__weak__wc12",  // 59,
        "fe52__mn52__weak__wc12",  // 60,
        "fe53__mn53__weak__wc12",  // 61,
        "fe55__mn55__weak__wc12",  // 62,
        "co53__fe53__weak__wc12",  // 63,
        "co54__fe54__weak__wc12",  // 64,
        "co55__fe55__weak__wc12",  // 65,
        "co56__fe56__weak__wc12",  // 66,
        "co57__fe57__weak__wc12",  // 67,
        "co58__fe58__weak__wc12",  // 68,
        "ni56__co56__weak__wc12",  // 69,
        "ni57__co57__weak__wc12",  // 70,
        "ni59__co59__weak__wc12",  // 71,
        "ni63__cu63__weak__wc12",  // 72,
        "cu57__ni57__weak__wc12",  // 73,
        "cu58__ni58__weak__wc12",  // 74,
        "cu59__ni59__weak__wc12",  // 75,
        "cu60__ni60__weak__wc12",  // 76,
        "cu61__ni61__weak__wc12",  // 77,
        "cu62__ni62__weak__wc12",  // 78,
        "cu64__ni64__weak__wc12",  // 79,
        "cu64__zn64__weak__wc12",  // 80,
        "zn59__cu59__weak__wc12",  // 81,
        "zn60__cu60__weak__wc12",  // 82,
        "zn61__cu61__weak__wc12",  // 83,
        "zn62__cu62__weak__wc12",  // 84,
        "zn63__cu63__weak__wc12",  // 85,
        "zn65__cu65__weak__wc12",  // 86,
        "ga62__zn62__weak__wc12",  // 87,
        "ga63__zn63__weak__wc12",  // 88,
        "ga64__zn64__weak__wc12",  // 89,
        "ge63__ga63__weak__wc12",  // 90,
        "ge64__ga64__weak__wc12",  // 91,
        "d__n_p",  // 92,
        "he3__p_d",  // 93,
        "he4__n_he3",  // 94,
        "he4__d_d",  // 95,
        "li6__he4_d",  // 96,
        "li7__n_li6",  // 97,
        "be7__p_li6",  // 98,
        "be7__he4_he3",  // 99,
        "b8__p_be7",  // 100,
        "b8__he4_he4__weak__wc12",  // 101,
        "b10__p_be9",  // 102,
        "b10__he4_li6",  // 103,
        "b11__n_b10",  // 104,
        "b11__he4_li7",  // 105,
        "c12__p_b11",  // 106,
        "c13__n_c12",  // 107,
        "c14__n_c13",  // 108,
        "n13__p_c12",  // 109,
        "n14__n_n13",  // 110,
        "n14__p_c13",  // 111,
        "n15__n_n14",  // 112,
        "n15__p_c14",  // 113,
        "o14__p_n13",  // 114,
        "o15__n_o14",  // 115,
        "o15__p_n14",  // 116,
        "o16__n_o15",  // 117,
        "o16__p_n15",  // 118,
        "o16__he4_c12",  // 119,
        "o17__n_o16",  // 120,
        "o18__n_o17",  // 121,
        "o18__he4_c14",  // 122,
        "f17__p_o16",  // 123,
        "f18__n_f17",  // 124,
        "f18__p_o17",  // 125,
        "f18__he4_n14",  // 126,
        "f19__n_f18",  // 127,
        "f19__p_o18",  // 128,
        "f19__he4_n15",  // 129,
        "ne18__p_f17",  // 130,
        "ne18__he4_o14",  // 131,
        "ne19__n_ne18",  // 132,
        "ne19__p_f18",  // 133,
        "ne19__he4_o15",  // 134,
        "ne20__n_ne19",  // 135,
        "ne20__p_f19",  // 136,
        "ne20__he4_o16",  // 137,
        "ne21__n_ne20",  // 138,
        "ne21__he4_o17",  // 139,
        "ne22__n_ne21",  // 140,
        "ne22__he4_o18",  // 141,
        "na21__p_ne20",  // 142,
        "na21__he4_f17",  // 143,
        "na22__n_na21",  // 144,
        "na22__p_ne21",  // 145,
        "na22__he4_f18",  // 146,
        "na23__n_na22",  // 147,
        "na23__p_ne22",  // 148,
        "na23__he4_f19",  // 149,
        "mg23__p_na22",  // 150,
        "mg23__he4_ne19",  // 151,
        "mg24__n_mg23",  // 152,
        "mg24__p_na23",  // 153,
        "mg24__he4_ne20",  // 154,
        "mg25__n_mg24",  // 155,
        "mg25__he4_ne21",  // 156,
        "mg26__n_mg25",  // 157,
        "mg26__he4_ne22",  // 158,
        "al25__p_mg24",  // 159,
        "al25__he4_na21",  // 160,
        "al26__n_al25",  // 161,
        "al26__p_mg25",  // 162,
        "al26__he4_na22",  // 163,
        "al27__n_al26",  // 164,
        "al27__p_mg26",  // 165,
        "al27__he4_na23",  // 166,
        "si28__p_al27",  // 167,
        "si28__he4_mg24",  // 168,
        "si29__n_si28",  // 169,
        "si29__he4_mg25",  // 170,
        "si30__n_si29",  // 171,
        "si30__he4_mg26",  // 172,
        "si31__n_si30",  // 173,
        "si32__n_si31",  // 174,
        "p29__p_si28",  // 175,
        "p29__he4_al25",  // 176,
        "p30__n_p29",  // 177,
        "p30__p_si29",  // 178,
        "p30__he4_al26",  // 179,
        "p31__n_p30",  // 180,
        "p31__p_si30",  // 181,
        "p31__he4_al27",  // 182,
        "p32__n_p31",  // 183,
        "p32__p_si31",  // 184,
        "p33__n_p32",  // 185,
        "p33__p_si32",  // 186,
        "s32__p_p31",  // 187,
        "s32__he4_si28",  // 188,
        "s33__n_s32",  // 189,
        "s33__p_p32",  // 190,
        "s33__he4_si29",  // 191,
        "s34__n_s33",  // 192,
        "s34__p_p33",  // 193,
        "s34__he4_si30",  // 194,
        "s35__n_s34",  // 195,
        "s35__he4_si31",  // 196,
        "s36__n_s35",  // 197,
        "s36__he4_si32",  // 198,
        "cl33__p_s32",  // 199,
        "cl33__he4_p29",  // 200,
        "cl34__n_cl33",  // 201,
        "cl34__p_s33",  // 202,
        "cl34__he4_p30",  // 203,
        "cl35__n_cl34",  // 204,
        "cl35__p_s34",  // 205,
        "cl35__he4_p31",  // 206,
        "cl36__n_cl35",  // 207,
        "cl36__p_s35",  // 208,
        "cl36__he4_p32",  // 209,
        "cl37__n_cl36",  // 210,
        "cl37__p_s36",  // 211,
        "cl37__he4_p33",  // 212,
        "ar36__p_cl35",  // 213,
        "ar36__he4_s32",  // 214,
        "ar37__n_ar36",  // 215,
        "ar37__p_cl36",  // 216,
        "ar37__he4_s33",  // 217,
        "ar38__n_ar37",  // 218,
        "ar38__p_cl37",  // 219,
        "ar38__he4_s34",  // 220,
        "ar39__n_ar38",  // 221,
        "ar39__he4_s35",  // 222,
        "ar40__n_ar39",  // 223,
        "ar40__he4_s36",  // 224,
        "k37__p_ar36",  // 225,
        "k37__he4_cl33",  // 226,
        "k38__n_k37",  // 227,
        "k38__p_ar37",  // 228,
        "k38__he4_cl34",  // 229,
        "k39__n_k38",  // 230,
        "k39__p_ar38",  // 231,
        "k39__he4_cl35",  // 232,
        "k40__n_k39",  // 233,
        "k40__p_ar39",  // 234,
        "k40__he4_cl36",  // 235,
        "k41__n_k40",  // 236,
        "k41__p_ar40",  // 237,
        "k41__he4_cl37",  // 238,
        "ca40__p_k39",  // 239,
        "ca40__he4_ar36",  // 240,
        "ca41__n_ca40",  // 241,
        "ca41__p_k40",  // 242,
        "ca41__he4_ar37",  // 243,
        "ca42__n_ca41",  // 244,
        "ca42__p_k41",  // 245,
        "ca42__he4_ar38",  // 246,
        "ca43__n_ca42",  // 247,
        "ca43__he4_ar39",  // 248,
        "ca44__n_ca43",  // 249,
        "ca44__he4_ar40",  // 250,
        "ca45__n_ca44",  // 251,
        "ca46__n_ca45",  // 252,
        "ca47__n_ca46",  // 253,
        "ca48__n_ca47",  // 254,
        "sc43__p_ca42",  // 255,
        "sc43__he4_k39",  // 256,
        "sc44__n_sc43",  // 257,
        "sc44__p_ca43",  // 258,
        "sc44__he4_k40",  // 259,
        "sc45__n_sc44",  // 260,
        "sc45__p_ca44",  // 261,
        "sc45__he4_k41",  // 262,
        "sc46__n_sc45",  // 263,
        "sc46__p_ca45",  // 264,
        "sc47__n_sc46",  // 265,
        "sc47__p_ca46",  // 266,
        "sc48__n_sc47",  // 267,
        "sc48__p_ca47",  // 268,
        "sc49__n_sc48",  // 269,
        "sc49__p_ca48",  // 270,
        "ti44__p_sc43",  // 271,
        "ti44__he4_ca40",  // 272,
        "ti45__n_ti44",  // 273,
        "ti45__p_sc44",  // 274,
        "ti45__he4_ca41",  // 275,
        "ti46__n_ti45",  // 276,
        "ti46__p_sc45",  // 277,
        "ti46__he4_ca42",  // 278,
        "ti47__n_ti46",  // 279,
        "ti47__p_sc46",  // 280,
        "ti47__he4_ca43",  // 281,
        "ti48__n_ti47",  // 282,
        "ti48__p_sc47",  // 283,
        "ti48__he4_ca44",  // 284,
        "ti49__n_ti48",  // 285,
        "ti49__p_sc48",  // 286,
        "ti49__he4_ca45",  // 287,
        "ti50__n_ti49",  // 288,
        "ti50__p_sc49",  // 289,
        "ti50__he4_ca46",  // 290,
        "ti51__n_ti50",  // 291,
        "ti51__he4_ca47",  // 292,
        "v46__p_ti45",  // 293,
        "v47__n_v46",  // 294,
        "v47__p_ti46",  // 295,
        "v47__he4_sc43",  // 296,
        "v48__n_v47",  // 297,
        "v48__p_ti47",  // 298,
        "v48__he4_sc44",  // 299,
        "v49__n_v48",  // 300,
        "v49__p_ti48",  // 301,
        "v49__he4_sc45",  // 302,
        "v50__n_v49",  // 303,
        "v50__p_ti49",  // 304,
        "v50__he4_sc46",  // 305,
        "v51__n_v50",  // 306,
        "v51__p_ti50",  // 307,
        "v51__he4_sc47",  // 308,
        "v52__n_v51",  // 309,
        "v52__p_ti51",  // 310,
        "v52__he4_sc48",  // 311,
        "cr48__p_v47",  // 312,
        "cr48__he4_ti44",  // 313,
        "cr49__n_cr48",  // 314,
        "cr49__p_v48",  // 315,
        "cr49__he4_ti45",  // 316,
        "cr50__n_cr49",  // 317,
        "cr50__p_v49",  // 318,
        "cr50__he4_ti46",  // 319,
        "cr51__n_cr50",  // 320,
        "cr51__p_v50",  // 321,
        "cr51__he4_ti47",  // 322,
        "cr52__n_cr51",  // 323,
        "cr52__p_v51",  // 324,
        "cr52__he4_ti48",  // 325,
        "cr53__n_cr52",  // 326,
        "cr53__p_v52",  // 327,
        "cr53__he4_ti49",  // 328,
        "cr54__n_cr53",  // 329,
        "cr54__he4_ti50",  // 330,
        "mn50__p_cr49",  // 331,
        "mn50__he4_v46",  // 332,
        "mn51__n_mn50",  // 333,
        "mn51__p_cr50",  // 334,
        "mn51__he4_v47",  // 335,
        "mn52__n_mn51",  // 336,
        "mn52__p_cr51",  // 337,
        "mn52__he4_v48",  // 338,
        "mn53__n_mn52",  // 339,
        "mn53__p_cr52",  // 340,
        "mn53__he4_v49",  // 341,
        "mn54__n_mn53",  // 342,
        "mn54__p_cr53",  // 343,
        "mn54__he4_v50",  // 344,
        "mn55__n_mn54",  // 345,
        "mn55__p_cr54",  // 346,
        "mn55__he4_v51",  // 347,
        "fe52__p_mn51",  // 348,
        "fe52__he4_cr48",  // 349,
        "fe53__n_fe52",  // 350,
        "fe53__p_mn52",  // 351,
        "fe53__he4_cr49",  // 352,
        "fe54__n_fe53",  // 353,
        "fe54__p_mn53",  // 354,
        "fe54__he4_cr50",  // 355,
        "fe55__n_fe54",  // 356,
        "fe55__p_mn54",  // 357,
        "fe55__he4_cr51",  // 358,
        "fe56__n_fe55",  // 359,
        "fe56__p_mn55",  // 360,
        "fe56__he4_cr52",  // 361,
        "fe57__n_fe56",  // 362,
        "fe57__he4_cr53",  // 363,
        "fe58__n_fe57",  // 364,
        "fe58__he4_cr54",  // 365,
        "co53__p_fe52",  // 366,
        "co54__n_co53",  // 367,
        "co54__p_fe53",  // 368,
        "co54__he4_mn50",  // 369,
        "co55__n_co54",  // 370,
        "co55__p_fe54",  // 371,
        "co55__he4_mn51",  // 372,
        "co56__n_co55",  // 373,
        "co56__p_fe55",  // 374,
        "co56__he4_mn52",  // 375,
        "co57__n_co56",  // 376,
        "co57__p_fe56",  // 377,
        "co57__he4_mn53",  // 378,
        "co58__n_co57",  // 379,
        "co58__p_fe57",  // 380,
        "co58__he4_mn54",  // 381,
        "co59__n_co58",  // 382,
        "co59__p_fe58",  // 383,
        "co59__he4_mn55",  // 384,
        "ni56__p_co55",  // 385,
        "ni56__he4_fe52",  // 386,
        "ni57__n_ni56",  // 387,
        "ni57__p_co56",  // 388,
        "ni57__he4_fe53",  // 389,
        "ni58__n_ni57",  // 390,
        "ni58__p_co57",  // 391,
        "ni58__he4_fe54",  // 392,
        "ni59__n_ni58",  // 393,
        "ni59__p_co58",  // 394,
        "ni59__he4_fe55",  // 395,
        "ni60__n_ni59",  // 396,
        "ni60__p_co59",  // 397,
        "ni60__he4_fe56",  // 398,
        "ni61__n_ni60",  // 399,
        "ni61__he4_fe57",  // 400,
        "ni62__n_ni61",  // 401,
        "ni62__he4_fe58",  // 402,
        "ni63__n_ni62",  // 403,
        "ni64__n_ni63",  // 404,
        "cu57__p_ni56",  // 405,
        "cu57__he4_co53",  // 406,
        "cu58__n_cu57",  // 407,
        "cu58__p_ni57",  // 408,
        "cu58__he4_co54",  // 409,
        "cu59__n_cu58",  // 410,
        "cu59__p_ni58",  // 411,
        "cu59__he4_co55",  // 412,
        "cu60__n_cu59",  // 413,
        "cu60__p_ni59",  // 414,
        "cu60__he4_co56",  // 415,
        "cu61__n_cu60",  // 416,
        "cu61__p_ni60",  // 417,
        "cu61__he4_co57",  // 418,
        "cu62__n_cu61",  // 419,
        "cu62__p_ni61",  // 420,
        "cu62__he4_co58",  // 421,
        "cu63__n_cu62",  // 422,
        "cu63__p_ni62",  // 423,
        "cu63__he4_co59",  // 424,
        "cu64__n_cu63",  // 425,
        "cu64__p_ni63",  // 426,
        "cu65__n_cu64",  // 427,
        "cu65__p_ni64",  // 428,
        "zn59__p_cu58",  // 429,
        "zn59__p_ni58__weak__wc12",  // 430,
        "zn60__n_zn59",  // 431,
        "zn60__p_cu59",  // 432,
        "zn60__he4_ni56",  // 433,
        "zn61__n_zn60",  // 434,
        "zn61__p_cu60",  // 435,
        "zn61__he4_ni57",  // 436,
        "zn62__n_zn61",  // 437,
        "zn62__p_cu61",  // 438,
        "zn62__he4_ni58",  // 439,
        "zn63__n_zn62",  // 440,
        "zn63__p_cu62",  // 441,
        "zn63__he4_ni59",  // 442,
        "zn64__n_zn63",  // 443,
        "zn64__p_cu63",  // 444,
        "zn64__he4_ni60",  // 445,
        "zn65__n_zn64",  // 446,
        "zn65__p_cu64",  // 447,
        "zn65__he4_ni61",  // 448,
        "zn66__n_zn65",  // 449,
        "zn66__p_cu65",  // 450,
        "zn66__he4_ni62",  // 451,
        "ga62__p_zn61",  // 452,
        "ga62__he4_cu58",  // 453,
        "ga63__n_ga62",  // 454,
        "ga63__p_zn62",  // 455,
        "ga63__he4_cu59",  // 456,
        "ga64__n_ga63",  // 457,
        "ga64__p_zn63",  // 458,
        "ga64__he4_cu60",  // 459,
        "ge63__p_ga62",  // 460,
        "ge63__he4_zn59",  // 461,
        "ge64__n_ge63",  // 462,
        "ge64__p_ga63",  // 463,
        "ge64__he4_zn60",  // 464,
        "li6__n_p_he4",  // 465,
        "be9__n_he4_he4",  // 466,
        "c12__he4_he4_he4",  // 467,
        "n_p__d",  // 468,
        "p_p__d__weak__bet_pos_",  // 469,
        "p_p__d__weak__electron_capture",  // 470,
        "p_d__he3",  // 471,
        "d_d__he4",  // 472,
        "he4_d__li6",  // 473,
        "n_he3__he4",  // 474,
        "p_he3__he4__weak__bet_pos_",  // 475,
        "he4_he3__be7",  // 476,
        "n_li6__li7",  // 477,
        "p_li6__be7",  // 478,
        "he4_li6__b10",  // 479,
        "he4_li7__b11",  // 480,
        "p_be7__b8",  // 481,
        "p_be9__b10",  // 482,
        "n_b10__b11",  // 483,
        "p_b11__c12",  // 484,
        "n_c12__c13",  // 485,
        "p_c12__n13",  // 486,
        "he4_c12__o16",  // 487,
        "n_c13__c14",  // 488,
        "p_c13__n14",  // 489,
        "p_c14__n15",  // 490,
        "he4_c14__o18",  // 491,
        "n_n13__n14",  // 492,
        "p_n13__o14",  // 493,
        "n_n14__n15",  // 494,
        "p_n14__o15",  // 495,
        "he4_n14__f18",  // 496,
        "p_n15__o16",  // 497,
        "he4_n15__f19",  // 498,
        "n_o14__o15",  // 499,
        "he4_o14__ne18",  // 500,
        "n_o15__o16",  // 501,
        "he4_o15__ne19",  // 502,
        "n_o16__o17",  // 503,
        "p_o16__f17",  // 504,
        "he4_o16__ne20",  // 505,
        "n_o17__o18",  // 506,
        "p_o17__f18",  // 507,
        "he4_o17__ne21",  // 508,
        "p_o18__f19",  // 509,
        "he4_o18__ne22",  // 510,
        "n_f17__f18",  // 511,
        "p_f17__ne18",  // 512,
        "he4_f17__na21",  // 513,
        "n_f18__f19",  // 514,
        "p_f18__ne19",  // 515,
        "he4_f18__na22",  // 516,
        "p_f19__ne20",  // 517,
        "he4_f19__na23",  // 518,
        "n_ne18__ne19",  // 519,
        "n_ne19__ne20",  // 520,
        "he4_ne19__mg23",  // 521,
        "n_ne20__ne21",  // 522,
        "p_ne20__na21",  // 523,
        "he4_ne20__mg24",  // 524,
        "n_ne21__ne22",  // 525,
        "p_ne21__na22",  // 526,
        "he4_ne21__mg25",  // 527,
        "p_ne22__na23",  // 528,
        "he4_ne22__mg26",  // 529,
        "n_na21__na22",  // 530,
        "he4_na21__al25",  // 531,
        "n_na22__na23",  // 532,
        "p_na22__mg23",  // 533,
        "he4_na22__al26",  // 534,
        "p_na23__mg24",  // 535,
        "he4_na23__al27",  // 536,
        "n_mg23__mg24",  // 537,
        "n_mg24__mg25",  // 538,
        "p_mg24__al25",  // 539,
        "he4_mg24__si28",  // 540,
        "n_mg25__mg26",  // 541,
        "p_mg25__al26",  // 542,
        "he4_mg25__si29",  // 543,
        "p_mg26__al27",  // 544,
        "he4_mg26__si30",  // 545,
        "n_al25__al26",  // 546,
        "he4_al25__p29",  // 547,
        "n_al26__al27",  // 548,
        "he4_al26__p30",  // 549,
        "p_al27__si28",  // 550,
        "he4_al27__p31",  // 551,
        "n_si28__si29",  // 552,
        "p_si28__p29",  // 553,
        "he4_si28__s32",  // 554,
        "n_si29__si30",  // 555,
        "p_si29__p30",  // 556,
        "he4_si29__s33",  // 557,
        "n_si30__si31",  // 558,
        "p_si30__p31",  // 559,
        "he4_si30__s34",  // 560,
        "n_si31__si32",  // 561,
        "p_si31__p32",  // 562,
        "he4_si31__s35",  // 563,
        "p_si32__p33",  // 564,
        "he4_si32__s36",  // 565,
        "n_p29__p30",  // 566,
        "he4_p29__cl33",  // 567,
        "n_p30__p31",  // 568,
        "he4_p30__cl34",  // 569,
        "n_p31__p32",  // 570,
        "p_p31__s32",  // 571,
        "he4_p31__cl35",  // 572,
        "n_p32__p33",  // 573,
        "p_p32__s33",  // 574,
        "he4_p32__cl36",  // 575,
        "p_p33__s34",  // 576,
        "he4_p33__cl37",  // 577,
        "n_s32__s33",  // 578,
        "p_s32__cl33",  // 579,
        "he4_s32__ar36",  // 580,
        "n_s33__s34",  // 581,
        "p_s33__cl34",  // 582,
        "he4_s33__ar37",  // 583,
        "n_s34__s35",  // 584,
        "p_s34__cl35",  // 585,
        "he4_s34__ar38",  // 586,
        "n_s35__s36",  // 587,
        "p_s35__cl36",  // 588,
        "he4_s35__ar39",  // 589,
        "p_s36__cl37",  // 590,
        "he4_s36__ar40",  // 591,
        "n_cl33__cl34",  // 592,
        "he4_cl33__k37",  // 593,
        "n_cl34__cl35",  // 594,
        "he4_cl34__k38",  // 595,
        "n_cl35__cl36",  // 596,
        "p_cl35__ar36",  // 597,
        "he4_cl35__k39",  // 598,
        "n_cl36__cl37",  // 599,
        "p_cl36__ar37",  // 600,
        "he4_cl36__k40",  // 601,
        "p_cl37__ar38",  // 602,
        "he4_cl37__k41",  // 603,
        "n_ar36__ar37",  // 604,
        "p_ar36__k37",  // 605,
        "he4_ar36__ca40",  // 606,
        "n_ar37__ar38",  // 607,
        "p_ar37__k38",  // 608,
        "he4_ar37__ca41",  // 609,
        "n_ar38__ar39",  // 610,
        "p_ar38__k39",  // 611,
        "he4_ar38__ca42",  // 612,
        "n_ar39__ar40",  // 613,
        "p_ar39__k40",  // 614,
        "he4_ar39__ca43",  // 615,
        "p_ar40__k41",  // 616,
        "he4_ar40__ca44",  // 617,
        "n_k37__k38",  // 618,
        "n_k38__k39",  // 619,
        "n_k39__k40",  // 620,
        "p_k39__ca40",  // 621,
        "he4_k39__sc43",  // 622,
        "n_k40__k41",  // 623,
        "p_k40__ca41",  // 624,
        "he4_k40__sc44",  // 625,
        "p_k41__ca42",  // 626,
        "he4_k41__sc45",  // 627,
        "n_ca40__ca41",  // 628,
        "he4_ca40__ti44",  // 629,
        "n_ca41__ca42",  // 630,
        "he4_ca41__ti45",  // 631,
        "n_ca42__ca43",  // 632,
        "p_ca42__sc43",  // 633,
        "he4_ca42__ti46",  // 634,
        "n_ca43__ca44",  // 635,
        "p_ca43__sc44",  // 636,
        "he4_ca43__ti47",  // 637,
        "n_ca44__ca45",  // 638,
        "p_ca44__sc45",  // 639,
        "he4_ca44__ti48",  // 640,
        "n_ca45__ca46",  // 641,
        "p_ca45__sc46",  // 642,
        "he4_ca45__ti49",  // 643,
        "n_ca46__ca47",  // 644,
        "p_ca46__sc47",  // 645,
        "he4_ca46__ti50",  // 646,
        "n_ca47__ca48",  // 647,
        "p_ca47__sc48",  // 648,
        "he4_ca47__ti51",  // 649,
        "p_ca48__sc49",  // 650,
        "n_sc43__sc44",  // 651,
        "p_sc43__ti44",  // 652,
        "he4_sc43__v47",  // 653,
        "n_sc44__sc45",  // 654,
        "p_sc44__ti45",  // 655,
        "he4_sc44__v48",  // 656,
        "n_sc45__sc46",  // 657,
        "p_sc45__ti46",  // 658,
        "he4_sc45__v49",  // 659,
        "n_sc46__sc47",  // 660,
        "p_sc46__ti47",  // 661,
        "he4_sc46__v50",  // 662,
        "n_sc47__sc48",  // 663,
        "p_sc47__ti48",  // 664,
        "he4_sc47__v51",  // 665,
        "n_sc48__sc49",  // 666,
        "p_sc48__ti49",  // 667,
        "he4_sc48__v52",  // 668,
        "p_sc49__ti50",  // 669,
        "n_ti44__ti45",  // 670,
        "he4_ti44__cr48",  // 671,
        "n_ti45__ti46",  // 672,
        "p_ti45__v46",  // 673,
        "he4_ti45__cr49",  // 674,
        "n_ti46__ti47",  // 675,
        "p_ti46__v47",  // 676,
        "he4_ti46__cr50",  // 677,
        "n_ti47__ti48",  // 678,
        "p_ti47__v48",  // 679,
        "he4_ti47__cr51",  // 680,
        "n_ti48__ti49",  // 681,
        "p_ti48__v49",  // 682,
        "he4_ti48__cr52",  // 683,
        "n_ti49__ti50",  // 684,
        "p_ti49__v50",  // 685,
        "he4_ti49__cr53",  // 686,
        "n_ti50__ti51",  // 687,
        "p_ti50__v51",  // 688,
        "he4_ti50__cr54",  // 689,
        "p_ti51__v52",  // 690,
        "n_v46__v47",  // 691,
        "he4_v46__mn50",  // 692,
        "n_v47__v48",  // 693,
        "p_v47__cr48",  // 694,
        "he4_v47__mn51",  // 695,
        "n_v48__v49",  // 696,
        "p_v48__cr49",  // 697,
        "he4_v48__mn52",  // 698,
        "n_v49__v50",  // 699,
        "p_v49__cr50",  // 700,
        "he4_v49__mn53",  // 701,
        "n_v50__v51",  // 702,
        "p_v50__cr51",  // 703,
        "he4_v50__mn54",  // 704,
        "n_v51__v52",  // 705,
        "p_v51__cr52",  // 706,
        "he4_v51__mn55",  // 707,
        "p_v52__cr53",  // 708,
        "n_cr48__cr49",  // 709,
        "he4_cr48__fe52",  // 710,
        "n_cr49__cr50",  // 711,
        "p_cr49__mn50",  // 712,
        "he4_cr49__fe53",  // 713,
        "n_cr50__cr51",  // 714,
        "p_cr50__mn51",  // 715,
        "he4_cr50__fe54",  // 716,
        "n_cr51__cr52",  // 717,
        "p_cr51__mn52",  // 718,
        "he4_cr51__fe55",  // 719,
        "n_cr52__cr53",  // 720,
        "p_cr52__mn53",  // 721,
        "he4_cr52__fe56",  // 722,
        "n_cr53__cr54",  // 723,
        "p_cr53__mn54",  // 724,
        "he4_cr53__fe57",  // 725,
        "p_cr54__mn55",  // 726,
        "he4_cr54__fe58",  // 727,
        "n_mn50__mn51",  // 728,
        "he4_mn50__co54",  // 729,
        "n_mn51__mn52",  // 730,
        "p_mn51__fe52",  // 731,
        "he4_mn51__co55",  // 732,
        "n_mn52__mn53",  // 733,
        "p_mn52__fe53",  // 734,
        "he4_mn52__co56",  // 735,
        "n_mn53__mn54",  // 736,
        "p_mn53__fe54",  // 737,
        "he4_mn53__co57",  // 738,
        "n_mn54__mn55",  // 739,
        "p_mn54__fe55",  // 740,
        "he4_mn54__co58",  // 741,
        "p_mn55__fe56",  // 742,
        "he4_mn55__co59",  // 743,
        "n_fe52__fe53",  // 744,
        "p_fe52__co53",  // 745,
        "he4_fe52__ni56",  // 746,
        "n_fe53__fe54",  // 747,
        "p_fe53__co54",  // 748,
        "he4_fe53__ni57",  // 749,
        "n_fe54__fe55",  // 750,
        "p_fe54__co55",  // 751,
        "he4_fe54__ni58",  // 752,
        "n_fe55__fe56",  // 753,
        "p_fe55__co56",  // 754,
        "he4_fe55__ni59",  // 755,
        "n_fe56__fe57",  // 756,
        "p_fe56__co57",  // 757,
        "he4_fe56__ni60",  // 758,
        "n_fe57__fe58",  // 759,
        "p_fe57__co58",  // 760,
        "he4_fe57__ni61",  // 761,
        "p_fe58__co59",  // 762,
        "he4_fe58__ni62",  // 763,
        "n_co53__co54",  // 764,
        "he4_co53__cu57",  // 765,
        "n_co54__co55",  // 766,
        "he4_co54__cu58",  // 767,
        "n_co55__co56",  // 768,
        "p_co55__ni56",  // 769,
        "he4_co55__cu59",  // 770,
        "n_co56__co57",  // 771,
        "p_co56__ni57",  // 772,
        "he4_co56__cu60",  // 773,
        "n_co57__co58",  // 774,
        "p_co57__ni58",  // 775,
        "he4_co57__cu61",  // 776,
        "n_co58__co59",  // 777,
        "p_co58__ni59",  // 778,
        "he4_co58__cu62",  // 779,
        "p_co59__ni60",  // 780,
        "he4_co59__cu63",  // 781,
        "n_ni56__ni57",  // 782,
        "p_ni56__cu57",  // 783,
        "he4_ni56__zn60",  // 784,
        "n_ni57__ni58",  // 785,
        "p_ni57__cu58",  // 786,
        "he4_ni57__zn61",  // 787,
        "n_ni58__ni59",  // 788,
        "p_ni58__cu59",  // 789,
        "he4_ni58__zn62",  // 790,
        "n_ni59__ni60",  // 791,
        "p_ni59__cu60",  // 792,
        "he4_ni59__zn63",  // 793,
        "n_ni60__ni61",  // 794,
        "p_ni60__cu61",  // 795,
        "he4_ni60__zn64",  // 796,
        "n_ni61__ni62",  // 797,
        "p_ni61__cu62",  // 798,
        "he4_ni61__zn65",  // 799,
        "n_ni62__ni63",  // 800,
        "p_ni62__cu63",  // 801,
        "he4_ni62__zn66",  // 802,
        "n_ni63__ni64",  // 803,
        "p_ni63__cu64",  // 804,
        "p_ni64__cu65",  // 805,
        "n_cu57__cu58",  // 806,
        "n_cu58__cu59",  // 807,
        "p_cu58__zn59",  // 808,
        "he4_cu58__ga62",  // 809,
        "n_cu59__cu60",  // 810,
        "p_cu59__zn60",  // 811,
        "he4_cu59__ga63",  // 812,
        "n_cu60__cu61",  // 813,
        "p_cu60__zn61",  // 814,
        "he4_cu60__ga64",  // 815,
        "n_cu61__cu62",  // 816,
        "p_cu61__zn62",  // 817,
        "n_cu62__cu63",  // 818,
        "p_cu62__zn63",  // 819,
        "n_cu63__cu64",  // 820,
        "p_cu63__zn64",  // 821,
        "n_cu64__cu65",  // 822,
        "p_cu64__zn65",  // 823,
        "p_cu65__zn66",  // 824,
        "n_zn59__zn60",  // 825,
        "he4_zn59__ge63",  // 826,
        "n_zn60__zn61",  // 827,
        "he4_zn60__ge64",  // 828,
        "n_zn61__zn62",  // 829,
        "p_zn61__ga62",  // 830,
        "n_zn62__zn63",  // 831,
        "p_zn62__ga63",  // 832,
        "n_zn63__zn64",  // 833,
        "p_zn63__ga64",  // 834,
        "n_zn64__zn65",  // 835,
        "n_zn65__zn66",  // 836,
        "n_ga62__ga63",  // 837,
        "p_ga62__ge63",  // 838,
        "n_ga63__ga64",  // 839,
        "p_ga63__ge64",  // 840,
        "n_ge63__ge64",  // 841,
        "d_d__n_he3",  // 842,
        "n_he3__d_d",  // 843,
        "d_he3__p_he4",  // 844,
        "he4_he3__p_li6",  // 845,
        "p_he4__d_he3",  // 846,
        "he4_he4__n_be7",  // 847,
        "he4_he4__p_li7",  // 848,
        "p_li6__he4_he3",  // 849,
        "d_li6__n_be7",  // 850,
        "d_li6__p_li7",  // 851,
        "he4_li6__p_be9",  // 852,
        "p_li7__n_be7",  // 853,
        "p_li7__d_li6",  // 854,
        "p_li7__he4_he4",  // 855,
        "he4_li7__n_b10",  // 856,
        "n_be7__p_li7",  // 857,
        "n_be7__d_li6",  // 858,
        "n_be7__he4_he4",  // 859,
        "he4_be7__p_b10",  // 860,
        "p_be9__he4_li6",  // 861,
        "he4_be9__n_c12",  // 862,
        "n_b10__he4_li7",  // 863,
        "p_b10__he4_be7",  // 864,
        "he4_b10__n_n13",  // 865,
        "he4_b10__p_c13",  // 866,
        "he4_b11__n_n14",  // 867,
        "he4_b11__p_c14",  // 868,
        "n_c12__he4_be9",  // 869,
        "he4_c12__n_o15",  // 870,
        "he4_c12__p_n15",  // 871,
        "c12_c12__n_mg23",  // 872,
        "c12_c12__p_na23",  // 873,
        "c12_c12__he4_ne20",  // 874,
        "p_c13__n_n13",  // 875,
        "p_c13__he4_b10",  // 876,
        "d_c13__n_n14",  // 877,
        "he4_c13__n_o16",  // 878,
        "p_c14__n_n14",  // 879,
        "p_c14__he4_b11",  // 880,
        "d_c14__n_n15",  // 881,
        "he4_c14__n_o17",  // 882,
        "n_n13__p_c13",  // 883,
        "n_n13__he4_b10",  // 884,
        "he4_n13__p_o16",  // 885,
        "n_n14__p_c14",  // 886,
        "n_n14__d_c13",  // 887,
        "n_n14__he4_b11",  // 888,
        "p_n14__n_o14",  // 889,
        "he4_n14__n_f17",  // 890,
        "he4_n14__p_o17",  // 891,
        "n_n15__d_c14",  // 892,
        "p_n15__n_o15",  // 893,
        "p_n15__he4_c12",  // 894,
        "he4_n15__n_f18",  // 895,
        "he4_n15__p_o18",  // 896,
        "n_o14__p_n14",  // 897,
        "he4_o14__p_f17",  // 898,
        "n_o15__p_n15",  // 899,
        "n_o15__he4_c12",  // 900,
        "he4_o15__n_ne18",  // 901,
        "he4_o15__p_f18",  // 902,
        "n_o16__he4_c13",  // 903,
        "p_o16__he4_n13",  // 904,
        "he4_o16__n_ne19",  // 905,
        "he4_o16__p_f19",  // 906,
        "c12_o16__p_al27",  // 907,
        "c12_o16__he4_mg24",  // 908,
        "o16_o16__p_p31",  // 909,
        "o16_o16__he4_si28",  // 910,
        "n_o17__he4_c14",  // 911,
        "p_o17__n_f17",  // 912,
        "p_o17__he4_n14",  // 913,
        "he4_o17__n_ne20",  // 914,
        "p_o18__n_f18",  // 915,
        "p_o18__he4_n15",  // 916,
        "he4_o18__n_ne21",  // 917,
        "n_f17__p_o17",  // 918,
        "n_f17__he4_n14",  // 919,
        "p_f17__he4_o14",  // 920,
        "he4_f17__p_ne20",  // 921,
        "n_f18__p_o18",  // 922,
        "n_f18__he4_n15",  // 923,
        "p_f18__n_ne18",  // 924,
        "p_f18__he4_o15",  // 925,
        "he4_f18__n_na21",  // 926,
        "he4_f18__p_ne21",  // 927,
        "p_f19__n_ne19",  // 928,
        "p_f19__he4_o16",  // 929,
        "he4_f19__n_na22",  // 930,
        "he4_f19__p_ne22",  // 931,
        "n_ne18__p_f18",  // 932,
        "n_ne18__he4_o15",  // 933,
        "he4_ne18__p_na21",  // 934,
        "n_ne19__p_f19",  // 935,
        "n_ne19__he4_o16",  // 936,
        "he4_ne19__p_na22",  // 937,
        "n_ne20__he4_o17",  // 938,
        "p_ne20__he4_f17",  // 939,
        "he4_ne20__n_mg23",  // 940,
        "he4_ne20__p_na23",  // 941,
        "he4_ne20__c12_c12",  // 942,
        "c12_ne20__p_p31",  // 943,
        "c12_ne20__he4_si28",  // 944,
        "n_ne21__he4_o18",  // 945,
        "p_ne21__n_na21",  // 946,
        "p_ne21__he4_f18",  // 947,
        "he4_ne21__n_mg24",  // 948,
        "p_ne22__n_na22",  // 949,
        "p_ne22__he4_f19",  // 950,
        "he4_ne22__n_mg25",  // 951,
        "n_na21__p_ne21",  // 952,
        "n_na21__he4_f18",  // 953,
        "p_na21__he4_ne18",  // 954,
        "he4_na21__p_mg24",  // 955,
        "n_na22__p_ne22",  // 956,
        "n_na22__he4_f19",  // 957,
        "p_na22__he4_ne19",  // 958,
        "he4_na22__n_al25",  // 959,
        "he4_na22__p_mg25",  // 960,
        "p_na23__n_mg23",  // 961,
        "p_na23__he4_ne20",  // 962,
        "p_na23__c12_c12",  // 963,
        "he4_na23__n_al26",  // 964,
        "he4_na23__p_mg26",  // 965,
        "n_mg23__p_na23",  // 966,
        "n_mg23__he4_ne20",  // 967,
        "n_mg23__c12_c12",  // 968,
        "he4_mg23__p_al26",  // 969,
        "n_mg24__he4_ne21",  // 970,
        "p_mg24__he4_na21",  // 971,
        "he4_mg24__p_al27",  // 972,
        "he4_mg24__c12_o16",  // 973,
        "n_mg25__he4_ne22",  // 974,
        "p_mg25__n_al25",  // 975,
        "p_mg25__he4_na22",  // 976,
        "he4_mg25__n_si28",  // 977,
        "p_mg26__n_al26",  // 978,
        "p_mg26__he4_na23",  // 979,
        "he4_mg26__n_si29",  // 980,
        "n_al25__p_mg25",  // 981,
        "n_al25__he4_na22",  // 982,
        "he4_al25__p_si28",  // 983,
        "n_al26__p_mg26",  // 984,
        "n_al26__he4_na23",  // 985,
        "p_al26__he4_mg23",  // 986,
        "he4_al26__n_p29",  // 987,
        "he4_al26__p_si29",  // 988,
        "p_al27__he4_mg24",  // 989,
        "p_al27__c12_o16",  // 990,
        "he4_al27__n_p30",  // 991,
        "he4_al27__p_si30",  // 992,
        "n_si28__he4_mg25",  // 993,
        "p_si28__he4_al25",  // 994,
        "he4_si28__p_p31",  // 995,
        "he4_si28__c12_ne20",  // 996,
        "he4_si28__o16_o16",  // 997,
        "n_si29__he4_mg26",  // 998,
        "p_si29__n_p29",  // 999,
        "p_si29__he4_al26",  // 1000,
        "he4_si29__n_s32",  // 1001,
        "he4_si29__p_p32",  // 1002,
        "p_si30__n_p30",  // 1003,
        "p_si30__he4_al27",  // 1004,
        "he4_si30__n_s33",  // 1005,
        "he4_si30__p_p33",  // 1006,
        "p_si31__n_p31",  // 1007,
        "he4_si31__n_s34",  // 1008,
        "p_si32__n_p32",  // 1009,
        "he4_si32__n_s35",  // 1010,
        "n_p29__p_si29",  // 1011,
        "n_p29__he4_al26",  // 1012,
        "he4_p29__p_s32",  // 1013,
        "n_p30__p_si30",  // 1014,
        "n_p30__he4_al27",  // 1015,
        "he4_p30__n_cl33",  // 1016,
        "he4_p30__p_s33",  // 1017,
        "n_p31__p_si31",  // 1018,
        "p_p31__he4_si28",  // 1019,
        "p_p31__c12_ne20",  // 1020,
        "p_p31__o16_o16",  // 1021,
        "he4_p31__n_cl34",  // 1022,
        "he4_p31__p_s34",  // 1023,
        "n_p32__p_si32",  // 1024,
        "p_p32__n_s32",  // 1025,
        "p_p32__he4_si29",  // 1026,
        "he4_p32__n_cl35",  // 1027,
        "he4_p32__p_s35",  // 1028,
        "p_p33__n_s33",  // 1029,
        "p_p33__he4_si30",  // 1030,
        "he4_p33__n_cl36",  // 1031,
        "he4_p33__p_s36",  // 1032,
        "n_s32__p_p32",  // 1033,
        "n_s32__he4_si29",  // 1034,
        "p_s32__he4_p29",  // 1035,
        "he4_s32__p_cl35",  // 1036,
        "n_s33__p_p33",  // 1037,
        "n_s33__he4_si30",  // 1038,
        "p_s33__n_cl33",  // 1039,
        "p_s33__he4_p30",  // 1040,
        "he4_s33__n_ar36",  // 1041,
        "he4_s33__p_cl36",  // 1042,
        "n_s34__he4_si31",  // 1043,
        "p_s34__n_cl34",  // 1044,
        "p_s34__he4_p31",  // 1045,
        "he4_s34__n_ar37",  // 1046,
        "he4_s34__p_cl37",  // 1047,
        "n_s35__he4_si32",  // 1048,
        "p_s35__n_cl35",  // 1049,
        "p_s35__he4_p32",  // 1050,
        "he4_s35__n_ar38",  // 1051,
        "p_s36__n_cl36",  // 1052,
        "p_s36__he4_p33",  // 1053,
        "he4_s36__n_ar39",  // 1054,
        "n_cl33__p_s33",  // 1055,
        "n_cl33__he4_p30",  // 1056,
        "he4_cl33__p_ar36",  // 1057,
        "n_cl34__p_s34",  // 1058,
        "n_cl34__he4_p31",  // 1059,
        "he4_cl34__n_k37",  // 1060,
        "he4_cl34__p_ar37",  // 1061,
        "n_cl35__p_s35",  // 1062,
        "n_cl35__he4_p32",  // 1063,
        "p_cl35__he4_s32",  // 1064,
        "he4_cl35__n_k38",  // 1065,
        "he4_cl35__p_ar38",  // 1066,
        "n_cl36__p_s36",  // 1067,
        "n_cl36__he4_p33",  // 1068,
        "p_cl36__n_ar36",  // 1069,
        "p_cl36__he4_s33",  // 1070,
        "he4_cl36__n_k39",  // 1071,
        "he4_cl36__p_ar39",  // 1072,
        "p_cl37__n_ar37",  // 1073,
        "p_cl37__he4_s34",  // 1074,
        "he4_cl37__n_k40",  // 1075,
        "he4_cl37__p_ar40",  // 1076,
        "n_ar36__p_cl36",  // 1077,
        "n_ar36__he4_s33",  // 1078,
        "p_ar36__he4_cl33",  // 1079,
        "he4_ar36__p_k39",  // 1080,
        "n_ar37__p_cl37",  // 1081,
        "n_ar37__he4_s34",  // 1082,
        "p_ar37__n_k37",  // 1083,
        "p_ar37__he4_cl34",  // 1084,
        "he4_ar37__n_ca40",  // 1085,
        "he4_ar37__p_k40",  // 1086,
        "n_ar38__he4_s35",  // 1087,
        "p_ar38__n_k38",  // 1088,
        "p_ar38__he4_cl35",  // 1089,
        "he4_ar38__n_ca41",  // 1090,
        "he4_ar38__p_k41",  // 1091,
        "n_ar39__he4_s36",  // 1092,
        "p_ar39__n_k39",  // 1093,
        "p_ar39__he4_cl36",  // 1094,
        "he4_ar39__n_ca42",  // 1095,
        "p_ar40__n_k40",  // 1096,
        "p_ar40__he4_cl37",  // 1097,
        "he4_ar40__n_ca43",  // 1098,
        "n_k37__p_ar37",  // 1099,
        "n_k37__he4_cl34",  // 1100,
        "he4_k37__p_ca40",  // 1101,
        "n_k38__p_ar38",  // 1102,
        "n_k38__he4_cl35",  // 1103,
        "he4_k38__p_ca41",  // 1104,
        "n_k39__p_ar39",  // 1105,
        "n_k39__he4_cl36",  // 1106,
        "p_k39__he4_ar36",  // 1107,
        "he4_k39__p_ca42",  // 1108,
        "n_k40__p_ar40",  // 1109,
        "n_k40__he4_cl37",  // 1110,
        "p_k40__n_ca40",  // 1111,
        "p_k40__he4_ar37",  // 1112,
        "he4_k40__n_sc43",  // 1113,
        "he4_k40__p_ca43",  // 1114,
        "p_k41__n_ca41",  // 1115,
        "p_k41__he4_ar38",  // 1116,
        "he4_k41__n_sc44",  // 1117,
        "he4_k41__p_ca44",  // 1118,
        "n_ca40__p_k40",  // 1119,
        "n_ca40__he4_ar37",  // 1120,
        "p_ca40__he4_k37",  // 1121,
        "he4_ca40__p_sc43",  // 1122,
        "n_ca41__p_k41",  // 1123,
        "n_ca41__he4_ar38",  // 1124,
        "p_ca41__he4_k38",  // 1125,
        "he4_ca41__n_ti44",  // 1126,
        "he4_ca41__p_sc44",  // 1127,
        "n_ca42__he4_ar39",  // 1128,
        "p_ca42__he4_k39",  // 1129,
        "he4_ca42__n_ti45",  // 1130,
        "he4_ca42__p_sc45",  // 1131,
        "n_ca43__he4_ar40",  // 1132,
        "p_ca43__n_sc43",  // 1133,
        "p_ca43__he4_k40",  // 1134,
        "he4_ca43__n_ti46",  // 1135,
        "he4_ca43__p_sc46",  // 1136,
        "p_ca44__n_sc44",  // 1137,
        "p_ca44__he4_k41",  // 1138,
        "he4_ca44__n_ti47",  // 1139,
        "he4_ca44__p_sc47",  // 1140,
        "p_ca45__n_sc45",  // 1141,
        "he4_ca45__n_ti48",  // 1142,
        "he4_ca45__p_sc48",  // 1143,
        "p_ca46__n_sc46",  // 1144,
        "he4_ca46__n_ti49",  // 1145,
        "he4_ca46__p_sc49",  // 1146,
        "p_ca47__n_sc47",  // 1147,
        "he4_ca47__n_ti50",  // 1148,
        "p_ca48__n_sc48",  // 1149,
        "he4_ca48__n_ti51",  // 1150,
        "n_sc43__p_ca43",  // 1151,
        "n_sc43__he4_k40",  // 1152,
        "p_sc43__he4_ca40",  // 1153,
        "he4_sc43__n_v46",  // 1154,
        "he4_sc43__p_ti46",  // 1155,
        "n_sc44__p_ca44",  // 1156,
        "n_sc44__he4_k41",  // 1157,
        "p_sc44__n_ti44",  // 1158,
        "p_sc44__he4_ca41",  // 1159,
        "he4_sc44__n_v47",  // 1160,
        "he4_sc44__p_ti47",  // 1161,
        "n_sc45__p_ca45",  // 1162,
        "p_sc45__n_ti45",  // 1163,
        "p_sc45__he4_ca42",  // 1164,
        "he4_sc45__n_v48",  // 1165,
        "he4_sc45__p_ti48",  // 1166,
        "n_sc46__p_ca46",  // 1167,
        "p_sc46__n_ti46",  // 1168,
        "p_sc46__he4_ca43",  // 1169,
        "he4_sc46__n_v49",  // 1170,
        "he4_sc46__p_ti49",  // 1171,
        "n_sc47__p_ca47",  // 1172,
        "p_sc47__n_ti47",  // 1173,
        "p_sc47__he4_ca44",  // 1174,
        "he4_sc47__n_v50",  // 1175,
        "he4_sc47__p_ti50",  // 1176,
        "n_sc48__p_ca48",  // 1177,
        "p_sc48__n_ti48",  // 1178,
        "p_sc48__he4_ca45",  // 1179,
        "he4_sc48__n_v51",  // 1180,
        "he4_sc48__p_ti51",  // 1181,
        "p_sc49__n_ti49",  // 1182,
        "p_sc49__he4_ca46",  // 1183,
        "he4_sc49__n_v52",  // 1184,
        "n_ti44__p_sc44",  // 1185,
        "n_ti44__he4_ca41",  // 1186,
        "he4_ti44__p_v47",  // 1187,
        "n_ti45__p_sc45",  // 1188,
        "n_ti45__he4_ca42",  // 1189,
        "he4_ti45__n_cr48",  // 1190,
        "he4_ti45__p_v48",  // 1191,
        "n_ti46__p_sc46",  // 1192,
        "n_ti46__he4_ca43",  // 1193,
        "p_ti46__n_v46",  // 1194,
        "p_ti46__he4_sc43",  // 1195,
        "he4_ti46__n_cr49",  // 1196,
        "he4_ti46__p_v49",  // 1197,
        "n_ti47__p_sc47",  // 1198,
        "n_ti47__he4_ca44",  // 1199,
        "p_ti47__n_v47",  // 1200,
        "p_ti47__he4_sc44",  // 1201,
        "he4_ti47__n_cr50",  // 1202,
        "he4_ti47__p_v50",  // 1203,
        "n_ti48__p_sc48",  // 1204,
        "n_ti48__he4_ca45",  // 1205,
        "p_ti48__n_v48",  // 1206,
        "p_ti48__he4_sc45",  // 1207,
        "he4_ti48__n_cr51",  // 1208,
        "he4_ti48__p_v51",  // 1209,
        "n_ti49__p_sc49",  // 1210,
        "n_ti49__he4_ca46",  // 1211,
        "p_ti49__n_v49",  // 1212,
        "p_ti49__he4_sc46",  // 1213,
        "he4_ti49__n_cr52",  // 1214,
        "he4_ti49__p_v52",  // 1215,
        "n_ti50__he4_ca47",  // 1216,
        "p_ti50__n_v50",  // 1217,
        "p_ti50__he4_sc47",  // 1218,
        "he4_ti50__n_cr53",  // 1219,
        "n_ti51__he4_ca48",  // 1220,
        "p_ti51__n_v51",  // 1221,
        "p_ti51__he4_sc48",  // 1222,
        "he4_ti51__n_cr54",  // 1223,
        "n_v46__p_ti46",  // 1224,
        "n_v46__he4_sc43",  // 1225,
        "he4_v46__p_cr49",  // 1226,
        "n_v47__p_ti47",  // 1227,
        "n_v47__he4_sc44",  // 1228,
        "p_v47__he4_ti44",  // 1229,
        "he4_v47__n_mn50",  // 1230,
        "he4_v47__p_cr50",  // 1231,
        "n_v48__p_ti48",  // 1232,
        "n_v48__he4_sc45",  // 1233,
        "p_v48__n_cr48",  // 1234,
        "p_v48__he4_ti45",  // 1235,
        "he4_v48__n_mn51",  // 1236,
        "he4_v48__p_cr51",  // 1237,
        "n_v49__p_ti49",  // 1238,
        "n_v49__he4_sc46",  // 1239,
        "p_v49__n_cr49",  // 1240,
        "p_v49__he4_ti46",  // 1241,
        "he4_v49__n_mn52",  // 1242,
        "he4_v49__p_cr52",  // 1243,
        "n_v50__p_ti50",  // 1244,
        "n_v50__he4_sc47",  // 1245,
        "p_v50__n_cr50",  // 1246,
        "p_v50__he4_ti47",  // 1247,
        "he4_v50__n_mn53",  // 1248,
        "he4_v50__p_cr53",  // 1249,
        "n_v51__p_ti51",  // 1250,
        "n_v51__he4_sc48",  // 1251,
        "p_v51__n_cr51",  // 1252,
        "p_v51__he4_ti48",  // 1253,
        "he4_v51__n_mn54",  // 1254,
        "he4_v51__p_cr54",  // 1255,
        "n_v52__he4_sc49",  // 1256,
        "p_v52__n_cr52",  // 1257,
        "p_v52__he4_ti49",  // 1258,
        "he4_v52__n_mn55",  // 1259,
        "n_cr48__p_v48",  // 1260,
        "n_cr48__he4_ti45",  // 1261,
        "he4_cr48__p_mn51",  // 1262,
        "n_cr49__p_v49",  // 1263,
        "n_cr49__he4_ti46",  // 1264,
        "p_cr49__he4_v46",  // 1265,
        "he4_cr49__n_fe52",  // 1266,
        "he4_cr49__p_mn52",  // 1267,
        "n_cr50__p_v50",  // 1268,
        "n_cr50__he4_ti47",  // 1269,
        "p_cr50__n_mn50",  // 1270,
        "p_cr50__he4_v47",  // 1271,
        "he4_cr50__n_fe53",  // 1272,
        "he4_cr50__p_mn53",  // 1273,
        "n_cr51__p_v51",  // 1274,
        "n_cr51__he4_ti48",  // 1275,
        "p_cr51__n_mn51",  // 1276,
        "p_cr51__he4_v48",  // 1277,
        "he4_cr51__n_fe54",  // 1278,
        "he4_cr51__p_mn54",  // 1279,
        "n_cr52__p_v52",  // 1280,
        "n_cr52__he4_ti49",  // 1281,
        "p_cr52__n_mn52",  // 1282,
        "p_cr52__he4_v49",  // 1283,
        "he4_cr52__n_fe55",  // 1284,
        "he4_cr52__p_mn55",  // 1285,
        "n_cr53__he4_ti50",  // 1286,
        "p_cr53__n_mn53",  // 1287,
        "p_cr53__he4_v50",  // 1288,
        "he4_cr53__n_fe56",  // 1289,
        "n_cr54__he4_ti51",  // 1290,
        "p_cr54__n_mn54",  // 1291,
        "p_cr54__he4_v51",  // 1292,
        "he4_cr54__n_fe57",  // 1293,
        "n_mn50__p_cr50",  // 1294,
        "n_mn50__he4_v47",  // 1295,
        "he4_mn50__n_co53",  // 1296,
        "he4_mn50__p_fe53",  // 1297,
        "n_mn51__p_cr51",  // 1298,
        "n_mn51__he4_v48",  // 1299,
        "p_mn51__he4_cr48",  // 1300,
        "he4_mn51__n_co54",  // 1301,
        "he4_mn51__p_fe54",  // 1302,
        "n_mn52__p_cr52",  // 1303,
        "n_mn52__he4_v49",  // 1304,
        "p_mn52__n_fe52",  // 1305,
        "p_mn52__he4_cr49",  // 1306,
        "he4_mn52__n_co55",  // 1307,
        "he4_mn52__p_fe55",  // 1308,
        "n_mn53__p_cr53",  // 1309,
        "n_mn53__he4_v50",  // 1310,
        "p_mn53__n_fe53",  // 1311,
        "p_mn53__he4_cr50",  // 1312,
        "he4_mn53__n_co56",  // 1313,
        "he4_mn53__p_fe56",  // 1314,
        "n_mn54__p_cr54",  // 1315,
        "n_mn54__he4_v51",  // 1316,
        "p_mn54__n_fe54",  // 1317,
        "p_mn54__he4_cr51",  // 1318,
        "he4_mn54__n_co57",  // 1319,
        "he4_mn54__p_fe57",  // 1320,
        "n_mn55__he4_v52",  // 1321,
        "p_mn55__n_fe55",  // 1322,
        "p_mn55__he4_cr52",  // 1323,
        "he4_mn55__n_co58",  // 1324,
        "he4_mn55__p_fe58",  // 1325,
        "n_fe52__p_mn52",  // 1326,
        "n_fe52__he4_cr49",  // 1327,
        "he4_fe52__p_co55",  // 1328,
        "n_fe53__p_mn53",  // 1329,
        "n_fe53__he4_cr50",  // 1330,
        "p_fe53__n_co53",  // 1331,
        "p_fe53__he4_mn50",  // 1332,
        "he4_fe53__n_ni56",  // 1333,
        "he4_fe53__p_co56",  // 1334,
        "n_fe54__p_mn54",  // 1335,
        "n_fe54__he4_cr51",  // 1336,
        "p_fe54__n_co54",  // 1337,
        "p_fe54__he4_mn51",  // 1338,
        "he4_fe54__n_ni57",  // 1339,
        "he4_fe54__p_co57",  // 1340,
        "n_fe55__p_mn55",  // 1341,
        "n_fe55__he4_cr52",  // 1342,
        "p_fe55__n_co55",  // 1343,
        "p_fe55__he4_mn52",  // 1344,
        "he4_fe55__n_ni58",  // 1345,
        "he4_fe55__p_co58",  // 1346,
        "n_fe56__he4_cr53",  // 1347,
        "p_fe56__n_co56",  // 1348,
        "p_fe56__he4_mn53",  // 1349,
        "he4_fe56__n_ni59",  // 1350,
        "he4_fe56__p_co59",  // 1351,
        "n_fe57__he4_cr54",  // 1352,
        "p_fe57__n_co57",  // 1353,
        "p_fe57__he4_mn54",  // 1354,
        "he4_fe57__n_ni60",  // 1355,
        "p_fe58__n_co58",  // 1356,
        "p_fe58__he4_mn55",  // 1357,
        "he4_fe58__n_ni61",  // 1358,
        "n_co53__p_fe53",  // 1359,
        "n_co53__he4_mn50",  // 1360,
        "he4_co53__p_ni56",  // 1361,
        "n_co54__p_fe54",  // 1362,
        "n_co54__he4_mn51",  // 1363,
        "he4_co54__n_cu57",  // 1364,
        "he4_co54__p_ni57",  // 1365,
        "n_co55__p_fe55",  // 1366,
        "n_co55__he4_mn52",  // 1367,
        "p_co55__he4_fe52",  // 1368,
        "he4_co55__n_cu58",  // 1369,
        "he4_co55__p_ni58",  // 1370,
        "n_co56__p_fe56",  // 1371,
        "n_co56__he4_mn53",  // 1372,
        "p_co56__n_ni56",  // 1373,
        "p_co56__he4_fe53",  // 1374,
        "he4_co56__n_cu59",  // 1375,
        "he4_co56__p_ni59",  // 1376,
        "n_co57__p_fe57",  // 1377,
        "n_co57__he4_mn54",  // 1378,
        "p_co57__n_ni57",  // 1379,
        "p_co57__he4_fe54",  // 1380,
        "he4_co57__n_cu60",  // 1381,
        "he4_co57__p_ni60",  // 1382,
        "n_co58__p_fe58",  // 1383,
        "n_co58__he4_mn55",  // 1384,
        "p_co58__n_ni58",  // 1385,
        "p_co58__he4_fe55",  // 1386,
        "he4_co58__n_cu61",  // 1387,
        "he4_co58__p_ni61",  // 1388,
        "p_co59__n_ni59",  // 1389,
        "p_co59__he4_fe56",  // 1390,
        "he4_co59__n_cu62",  // 1391,
        "he4_co59__p_ni62",  // 1392,
        "n_ni56__p_co56",  // 1393,
        "n_ni56__he4_fe53",  // 1394,
        "p_ni56__he4_co53",  // 1395,
        "he4_ni56__n_zn59",  // 1396,
        "he4_ni56__p_cu59",  // 1397,
        "n_ni57__p_co57",  // 1398,
        "n_ni57__he4_fe54",  // 1399,
        "p_ni57__n_cu57",  // 1400,
        "p_ni57__he4_co54",  // 1401,
        "he4_ni57__n_zn60",  // 1402,
        "he4_ni57__p_cu60",  // 1403,
        "n_ni58__p_co58",  // 1404,
        "n_ni58__he4_fe55",  // 1405,
        "p_ni58__n_cu58",  // 1406,
        "p_ni58__he4_co55",  // 1407,
        "he4_ni58__n_zn61",  // 1408,
        "he4_ni58__p_cu61",  // 1409,
        "n_ni59__p_co59",  // 1410,
        "n_ni59__he4_fe56",  // 1411,
        "p_ni59__n_cu59",  // 1412,
        "p_ni59__he4_co56",  // 1413,
        "he4_ni59__n_zn62",  // 1414,
        "he4_ni59__p_cu62",  // 1415,
        "n_ni60__he4_fe57",  // 1416,
        "p_ni60__n_cu60",  // 1417,
        "p_ni60__he4_co57",  // 1418,
        "he4_ni60__n_zn63",  // 1419,
        "he4_ni60__p_cu63",  // 1420,
        "n_ni61__he4_fe58",  // 1421,
        "p_ni61__n_cu61",  // 1422,
        "p_ni61__he4_co58",  // 1423,
        "he4_ni61__n_zn64",  // 1424,
        "he4_ni61__p_cu64",  // 1425,
        "p_ni62__n_cu62",  // 1426,
        "p_ni62__he4_co59",  // 1427,
        "he4_ni62__n_zn65",  // 1428,
        "he4_ni62__p_cu65",  // 1429,
        "p_ni63__n_cu63",  // 1430,
        "he4_ni63__n_zn66",  // 1431,
        "p_ni64__n_cu64",  // 1432,
        "n_cu57__p_ni57",  // 1433,
        "n_cu57__he4_co54",  // 1434,
        "he4_cu57__p_zn60",  // 1435,
        "n_cu58__p_ni58",  // 1436,
        "n_cu58__he4_co55",  // 1437,
        "he4_cu58__p_zn61",  // 1438,
        "n_cu59__p_ni59",  // 1439,
        "n_cu59__he4_co56",  // 1440,
        "p_cu59__n_zn59",  // 1441,
        "p_cu59__he4_ni56",  // 1442,
        "he4_cu59__n_ga62",  // 1443,
        "he4_cu59__p_zn62",  // 1444,
        "n_cu60__p_ni60",  // 1445,
        "n_cu60__he4_co57",  // 1446,
        "p_cu60__n_zn60",  // 1447,
        "p_cu60__he4_ni57",  // 1448,
        "he4_cu60__n_ga63",  // 1449,
        "he4_cu60__p_zn63",  // 1450,
        "n_cu61__p_ni61",  // 1451,
        "n_cu61__he4_co58",  // 1452,
        "p_cu61__n_zn61",  // 1453,
        "p_cu61__he4_ni58",  // 1454,
        "he4_cu61__n_ga64",  // 1455,
        "he4_cu61__p_zn64",  // 1456,
        "n_cu62__p_ni62",  // 1457,
        "n_cu62__he4_co59",  // 1458,
        "p_cu62__n_zn62",  // 1459,
        "p_cu62__he4_ni59",  // 1460,
        "he4_cu62__p_zn65",  // 1461,
        "n_cu63__p_ni63",  // 1462,
        "p_cu63__n_zn63",  // 1463,
        "p_cu63__he4_ni60",  // 1464,
        "he4_cu63__p_zn66",  // 1465,
        "n_cu64__p_ni64",  // 1466,
        "p_cu64__n_zn64",  // 1467,
        "p_cu64__he4_ni61",  // 1468,
        "p_cu65__n_zn65",  // 1469,
        "p_cu65__he4_ni62",  // 1470,
        "n_zn59__p_cu59",  // 1471,
        "n_zn59__he4_ni56",  // 1472,
        "he4_zn59__p_ga62",  // 1473,
        "n_zn60__p_cu60",  // 1474,
        "n_zn60__he4_ni57",  // 1475,
        "p_zn60__he4_cu57",  // 1476,
        "he4_zn60__n_ge63",  // 1477,
        "he4_zn60__p_ga63",  // 1478,
        "n_zn61__p_cu61",  // 1479,
        "n_zn61__he4_ni58",  // 1480,
        "p_zn61__he4_cu58",  // 1481,
        "he4_zn61__n_ge64",  // 1482,
        "he4_zn61__p_ga64",  // 1483,
        "n_zn62__p_cu62",  // 1484,
        "n_zn62__he4_ni59",  // 1485,
        "p_zn62__n_ga62",  // 1486,
        "p_zn62__he4_cu59",  // 1487,
        "n_zn63__p_cu63",  // 1488,
        "n_zn63__he4_ni60",  // 1489,
        "p_zn63__n_ga63",  // 1490,
        "p_zn63__he4_cu60",  // 1491,
        "n_zn64__p_cu64",  // 1492,
        "n_zn64__he4_ni61",  // 1493,
        "p_zn64__n_ga64",  // 1494,
        "p_zn64__he4_cu61",  // 1495,
        "n_zn65__p_cu65",  // 1496,
        "n_zn65__he4_ni62",  // 1497,
        "p_zn65__he4_cu62",  // 1498,
        "n_zn66__he4_ni63",  // 1499,
        "p_zn66__he4_cu63",  // 1500,
        "n_ga62__p_zn62",  // 1501,
        "n_ga62__he4_cu59",  // 1502,
        "p_ga62__he4_zn59",  // 1503,
        "n_ga63__p_zn63",  // 1504,
        "n_ga63__he4_cu60",  // 1505,
        "p_ga63__n_ge63",  // 1506,
        "p_ga63__he4_zn60",  // 1507,
        "n_ga64__p_zn64",  // 1508,
        "n_ga64__he4_cu61",  // 1509,
        "p_ga64__n_ge64",  // 1510,
        "p_ga64__he4_zn61",  // 1511,
        "n_ge63__p_ga63",  // 1512,
        "n_ge63__he4_zn60",  // 1513,
        "n_ge64__p_ga64",  // 1514,
        "n_ge64__he4_zn61",  // 1515,
        "p_d__n_p_p",  // 1516,
        "he3_he3__p_p_he4",  // 1517,
        "d_li7__n_he4_he4",  // 1518,
        "d_be7__p_he4_he4",  // 1519,
        "p_be9__d_he4_he4",  // 1520,
        "n_b8__p_he4_he4",  // 1521,
        "p_b11__he4_he4_he4",  // 1522,
        "he3_li7__n_p_he4_he4",  // 1523,
        "he3_be7__p_p_he4_he4",  // 1524,
        "p_be9__n_p_he4_he4",  // 1525,
        "n_p_he4__li6",  // 1526,
        "n_he4_he4__be9",  // 1527,
        "he4_he4_he4__c12",  // 1528,
        "n_p_p__p_d",  // 1529,
        "p_p_he4__he3_he3",  // 1530,
        "n_he4_he4__d_li7",  // 1531,
        "p_he4_he4__n_b8",  // 1532,
        "p_he4_he4__d_be7",  // 1533,
        "d_he4_he4__p_be9",  // 1534,
        "he4_he4_he4__p_b11",  // 1535,
        "n_p_he4_he4__he3_li7",  // 1536,
        "n_p_he4_he4__p_be9",  // 1537,
        "p_p_he4_he4__he3_be7"  // 1538,
    };

}

#endif
