library(splines) 
library(R.matlab)
library(dplyr)


 dd<-readMat("crop_reg.mat")
   '%&%' <- function(x,y) paste0(x,y)
  
  data  <-data.frame( freq = as.vector(dd$crop.reg[,1]), yield = as.vector(dd$crop.reg[,2]), pro = as.vector(dd$crop.reg[,3]),  site =   (as.vector(dd$crop.reg[,4])),  year =   as.vector(dd$crop.reg[,5]),year_sq =   as.vector(dd$crop.reg[,5]*dd$crop.reg[,5])  ,prcp  = as.vector(dd$crop.reg[,6]),   tmean = as.vector(dd$crop.reg[,7]) ,weight = as.vector(dd$crop.reg[,8]),  irri_rate = as.vector(dd$crop.reg[,9]), fert = as.vector(dd$crop.reg[,10])/400,   fdd_s= as.vector(dd$crop.reg[,11]),  gdd1_s=  as.vector(dd$crop.reg[,12]),gdd2_s= as.vector(dd$crop.reg[,13]),gdd3_s= as.vector(dd$crop.reg[,14]),edd_s= as.vector(dd$crop.reg[,15]))

 
 data1  <- na.omit(data )  #  na.omit
 
 
  
 

	  
b_1 <- lm(  yield ~     poly(prcp ,2,raw=T)+ poly(tmean ,2,raw=T)+  irri_rate:tmean  +irri_rate:prcp  -1 +fert+   year:as.factor(site)+ year_sq:as.factor(site)  +  factor(site)     ,data = data1,weights= sqrt(data1$weight) )


 

b_rcs <- lm(  yield ~    poly(prcp ,2,raw=T)+ ns(tmean, df=5) + irri_rate:tmean  +irri_rate:prcp  -1 +fert+   year:as.factor(site)+ year_sq:as.factor(site)  +  factor(site)   ,data = data1,weights= sqrt(data1$weight) )
  
b_gdd <- lm(  yield ~   poly(prcp ,2,raw=T)+ fdd_s+gdd1_s+gdd2_s+gdd3_s+edd_s  + irri_rate:gdd1_s+irri_rate:gdd2_s+ irri_rate:gdd3_s+ irri_rate:edd_s  +irri_rate:prcp   +fert+   year:as.factor(site)+ year_sq:as.factor(site)  + factor(site)    ,data = data1,weights= sqrt(data1$weight) )
	  
 
 
	   
	     
   
      b_felm <- lfe::felm(  freq ~  fdd+ prcp+edd+gdd+  irri_rate:prcp  +irri_rate:edd  +irri_rate-1+ year:as.factor(site)+ year_sq:as.factor(site)+ factor(site)+factor(year)   ,data = data1,weights= sqrt(data1$weight) )
   
   
   
   b <- lfe::felm(  freq ~    prcp+ tmean    +irri_rate:prcp  +irri_rate:tmean -1+  as.factor(year)+  as.factor(site)+ year:as.factor(site)+ year_sq:as.factor(site)   ,data = data1,weights= sqrt(data1$weight) )
	  
	  
	   
  
     
   