function y=Model_trajectory(T,f,g,h,pre_f,pre_g,pre_h)

% T = number of time steps
% f = list of rescaled step sizes
% g = list of rescaled turn angles
% h = list of rescaled wait times
% pref_f = prefactor of step size
% pref_g = prefactor of turn angle
% pref_h = prefactor of wait times
% outputs: y(times, x-coords, y-coords, z-coords)

Lf=length(f);
Lg=length(g);
Lh=length(h);

f_list = pre_f * f(ceil(Lf*rand(T,1)));
g_list = pre_g * g(ceil(Lg*rand(T,1)));
h_list = pre_h * h(ceil(Lh*rand(T,1)));

time=zeros(T,1);
R=zeros(T,3);
time(2)=h_list(1);
R(2,:)=[0,0,f_list(1)];
for k=3:T
    time(k)=time(k-1)+h_list(k);
    r=R(k-1,:)-R(k-2,:);
    e3=r/norm(r);
    if abs(e3(1))<.99
        u1=[1 0 0];
    else 
        u1=[0 1 0];
    end
    e1=u1-dot(u1,e3)*e3;
    e1=e1/norm(e1);
    e2=cross(e3, e1); 
    phi=2*pi*rand;
    R(k,:)=R(k-1,:)+f_list(k)*(cos(g_list(k))*e3+sin(g_list(k))*(cos(phi)*e1+sin(phi)*e2));
end

y=[time R];
    
    
    
    
    
    


