world_defaults = {
    'base'        : {
        'name'                                : 'unknown_world_base_type',
        'store_tides_config_in_world'         : True,
        'force_spin_sync'                     : True,
        'equilibrium_insolation_model'        : 'williams',  # Options are no_eccentricity, williams, or mendez
        'fraction_internal_heating_to_surface': 1.0,
        'emissivity'                          : 0.9,
        'albedo'                              : 0.3,
        'use_real_moi'                        : True,
        'surface_pressure'                    : 0.,
        'slices'                              : 40,
        },
    'simple_tidal': {
        'name'                                : 'unknown_world_simple_tide_type',
        'store_tides_config_in_world'         : True,
        'force_spin_sync'                     : True,
        'equilibrium_insolation_model'        : 'williams',
        'fraction_internal_heating_to_surface': 1.0,
        'emissivity'                          : 0.9,
        'albedo'                              : 0.3,
        'use_real_moi'                        : True,
        'tides_on'                            : True,
        'surface_pressure'                    : 0.,
        'slices'                              : 40,
        },
    'gas_giant'   : {
        'name'                                : 'unknown_world_gas_giant_type',
        'store_tides_config_in_world'         : True,
        'force_spin_sync'                     : True,
        'equilibrium_insolation_model'        : 'williams',
        'fraction_internal_heating_to_surface': 1.0,
        'emissivity'                          : 0.9,
        'albedo'                              : 0.3,
        'use_real_moi'                        : True,
        'tides_on'                            : True,
        'surface_pressure'                    : 0.,
        'slices'                              : 40,
        },
    'star'        : {
        'name'                                : 'unknown_world_star_type',
        'store_tides_config_in_world'         : True,
        'force_spin_sync'                     : True,
        'equilibrium_insolation_model'        : 'williams',
        'fraction_internal_heating_to_surface': 1.0,
        'emissivity'                          : 0.9,
        'albedo'                              : 0.3,
        'use_real_moi'                        : True,
        'tides_on'                            : False,
        'surface_pressure'                    : 0.,
        'slices'                              : 40,
        },
    'layered'     : {
        'name'                                : 'unknown_world_layered_type',
        'store_tides_config_in_world'         : True,
        'force_spin_sync'                     : True,
        'equilibrium_insolation_model'        : 'williams',
        'fraction_internal_heating_to_surface': 1.0,
        'emissivity'                          : 0.9,
        'albedo'                              : 0.3,
        'use_real_moi'                        : True,
        'tides_on'                            : True,
        'surface_pressure'                    : 0.,
        'slices'                              : None
        },
    'burnman'     : {
        'name'                                : 'unknown_world_burnman_type',
        'store_tides_config_in_world'         : True,
        'force_spin_sync'                     : True,
        'equilibrium_insolation_model'        : 'williams',
        'fraction_internal_heating_to_surface': 1.0,
        'emissivity'                          : 0.9,
        'albedo'                              : 0.3,
        'use_real_moi'                        : True,
        'tides_on'                            : True,
        'surface_pressure'                    : 0.,
        'slices'                              : None
        }
    }
