from scipy.constants import G, Stefan_Boltzmann, au, pi

# Mathematics
ppm = 1.e-6
ppb = 1.e-9

# Sun
mass_solar = 1.988435e30  # [kg]
radius_solar = 6.957e8  # [m]
luminosity_solar = 3.848e26  # [Watts]

# TRAPPIST-1
mass_trap1 = 2.0e29  # [kg]
radius_trap1 = 8.3e7  # [m]
luminosity_trap1 = 2.1e23  # [Watts]

# Earth
mass_earth = 5.9721986e24  # [kg]
radius_earth = 6.371008e6  # [m]

# Jupiter
mass_jupiter = 1.89813e27  # [kg]
radius_jupiter = 6.9911e7  # [m]

# Pluto
mass_pluto = 1.309e22  # [kg]
radius_pluto = 1.1899e6  # [m]

# Io
mass_io = 8.9298e22  # [kg]
radius_io = 1.82149e6  # [m]

# Alias Names
Au = au
sbc = Stefan_Boltzmann
SBC = sbc
newtons_constant = G

M_sol = mass_solar
M_earth = mass_earth
M_jup = mass_jupiter
M_pluto = mass_pluto

R_sol = radius_solar
R_earth = radius_earth
R_jup = radius_jupiter
R_pluto = radius_pluto

L_sol = luminosity_solar
