/*!
 *  \file simple_mapped_source.cpp
 *
 *  \copyright Copyright (c) 2014 Franco "Sensei" Milicchio. All rights reserved.
 *
 *  \license BSD Licensed.
 */

#include "source.h"

using namespace boost;
using namespace seq;
using namespace std;

simple_mapped_source::simple_mapped_source (const char * filename)
{
    open (filename);
}

void simple_mapped_source::open (const char * filename)
{
    mfs_.open (filename);
}

bool simple_mapped_source::good () noexcept
{
    return mfs_.size () != 0 and processed_ != mfs_.size ();
}

void simple_mapped_source::read (simple_mapped_source::element_type ** s,
                                 simple_mapped_source::size_type count)
{
    gcount_ = min (count, static_cast<long> (mfs_.size ()) - processed_);
    *s = const_cast<simple_mapped_source::element_type *> (mfs_.data ()) + processed_;
    processed_ += gcount_;
}

simple_mapped_source::size_type simple_mapped_source::gcount () const noexcept
{
    return gcount_;
}
