/*!
 *  \file region_mapped_source.cpp
 *
 *  \copyright Copyright (c) 2014 Franco "Sensei" Milicchio. All rights reserved.
 *
 *  \license BSD Licensed.
 */


#include <boost/filesystem.hpp>
#include "source.h"

using namespace boost;
using namespace seq;
using namespace std;

region_mapped_source::region_mapped_source (const char * filename)
{
    open (filename);
}

void region_mapped_source::open (const char * filename)
{
    filename_ = filename;
    file_size_ = filesystem::file_size (filename_);
}

bool region_mapped_source::good () noexcept
{
    return processed_ < file_size_;
}
#include <iostream>
void region_mapped_source::read (region_mapped_source::element_type ** s,
                                 region_mapped_source::size_type count)
{
    if (count % iostreams::mapped_file_source::alignment () != 0) {
        throw source_error ("expected a multiple of OS virtual memory granularity!");
    }

    old_mfs_.close ();
    swap (old_mfs_, mfs_);
    gcount_ = min (count, file_size_ - processed_);
    mfs_.open (filename_, gcount_, processed_);
    *s = const_cast<region_mapped_source::element_type *> (mfs_.data ());
    processed_ += gcount_;
}

region_mapped_source::size_type region_mapped_source::gcount () const noexcept
{
    return gcount_;
}
