//
//  revcomp.cpp
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#include <iostream>
#include <string>
#include <string_view>
#include <cmath>
#include <iomanip>

#include <x86intrin.h>

#include "gatb/gatb_core.hpp"

#include "../libseq/accelerator_sse.hpp"
#include "../libseq/timer.hpp"

////////////////////////////////////////////////////////////////////////////////
std::string random_string( size_t length )
{
    // I'm lazy for this, see: https://stackoverflow.com/questions/440133/how-do-i-create-a-random-alpha-numeric-string-in-c
    auto randchar = []() -> char
    {
        const char charset[] = "ATCG";
        const size_t max_index = (sizeof(charset) - 1);
        return charset[ rand() % max_index ];
    };
    std::string str(length,0);
    std::generate_n( str.begin(), length, randchar );
    return str;
}

int main(int argc, const char * argv[])
{
//    dummy_testing1 d1;
//    dummy_testing2 d2;
//
//    test_inherit(d1);
//    test_inherit(d2);
    
    // Kmer
    std::size_t k = 8;

    // Test string
    std::string t("ATCGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");

    libseq::accelerator_sse acc;
    
    std::string_view s(t.data(), k);
    
    
    
    
    auto rrr = acc.to_canonical(s);
    
    
    
    
    auto r = acc.to_revcomp(s);
    
    auto q = acc.to_string(r, k);
    
    std::cout << "end" << std::endl;
    
#if 0
    

    Kmer<65>::Type from;
    Data data((char*)t.data());
    
    
    Kmer<65>::ModelDirect model_direct(k);
    Kmer<65>::ModelDirect::Iterator it_direct(model_direct);
    it_direct.setData(data);
    it_direct.first();
    from = it_direct->value();
    std::cout << "DIR " << from.toString(k) << std::endl;
    
    
    Kmer<65>::ModelCanonical model_canonical(k);
    Kmer<65>::ModelCanonical::Iterator it_canonical(model_canonical);
    it_canonical.setData(data);
    it_canonical.first();
    from = it_canonical->value();
    std::cout << "CAN " << from.toString(k) << std::endl;
    std::cout << "CAN " << model_canonical.toString(it_canonical->value()) << std::endl;
    std::cout << "CAN " << model_canonical.toString(it_canonical->forward()) << std::endl;
    std::cout << "CAN " << model_canonical.toString(it_canonical->revcomp()) << std::endl;
    std::cout << "CAN " << model_canonical.toString(it_canonical->strand()) << std::endl;
#endif


#if 1
    
    std::string w = random_string(2000);
    
    // TEST
    for (k = 1; k <= 64; k++)
    {
        std::size_t nsubstrings = w.length() - k + 1;
        
        // For every kmer
        for (int i = 0; i < nsubstrings; i++)
        {
            auto kmer = std::string_view(w.data() + i, k);
            
            auto fwd = acc.to_forward(kmer);
            auto rev = acc.to_revcomp(kmer);
            auto to  = acc.to_string(rev, k);
            
            std::string revcomp;
            
            for (char q : kmer)
            {
                switch (q)
                {
                    case 'A':
                        revcomp = std::string("T") + revcomp;
                        break;
                        
                    case 'T':
                        revcomp = std::string("A") + revcomp;
                        break;
                        
                    case 'C':
                        revcomp = std::string("G") + revcomp;
                        break;
                        
                    case 'G':
                        revcomp = std::string("C") + revcomp;
                        break;
                        
                    default:
                        throw std::domain_error("WAT");
                }
            }
            
            std::cout << "kmer " << kmer << " sse " << to << " str " << revcomp << " -> ";
            
            if (revcomp != to)
                std::cout << "F" << std::endl;
            else
                std::cout << "s" << std::endl;
        }
    }
#endif
    
//    std::cout << "forward value  is: " << kmer.forward()                    << std::endl;
//    std::cout << "forward string is: " << model.toString(kmer.forward())    << std::endl;
//    std::cout << "revcomp value  is: " << kmer.revcomp()                    << std::endl;
//    std::cout << "revcomp string is: " << model.toString(kmer.revcomp())    << std::endl;
//    std::cout << "used strand is:    " << toString(kmer.strand())           << std::endl;
    return 0;
}

