//
//  timer.hpp
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#ifndef timer_hpp
#define timer_hpp

#include <chrono>

namespace libseq
{

    /// High-precision timing class
    class timer
    {
    public:
        
        /// Constructor (starts the timer)
        timer();
        
        /// Reset timer and return the current elapsed time
        template <typename T = std::chrono::milliseconds>
        double reset()
        {
            auto d = elapsed<T>();
            begin_ = clock_::now();
            return d;
        }
        
        /// Return the elapsed time (in milliseconds by default) using current time, without affecting the timing
        template <typename T = std::chrono::milliseconds>
        inline double elapsed() const
        {
            return std::chrono::duration_cast<T>(clock_::now() - begin_).count();
        }
        
    private:
        
        /// Handy typedef for C++ standard clock
        typedef std::chrono::high_resolution_clock clock_;

        /// Beginning of time measurement
        std::chrono::time_point<clock_> begin_;
    };
    
}

#endif /* timer_hpp */
