//
//  precomputed.h
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#ifndef precomputed_hpp
#define precomputed_hpp

namespace libseq
{
    /// Class used to find the little endianness of a system
    class is_little_endian
    {
    public:
        static const bool value = (1 & 0xFFFFFFFF) == 0x00000001;
    };
    
    /// This class holds numeric values corresponding to genomic bases (now, only ATCG)
    class bases_values
    {
        
        /// Precomputed values of ATCG
        static const unsigned char table_value_[26];
        
        /// ASCII values
        static const unsigned char table_ascii_[4];
        
    public:

        /// Return the integer value of a genomic base
        inline static char value(char c)
        {
            return table_value_[c - 'A'];
        }
        
        /// Return the ASCII char of an integer value
        inline static char ascii(char c)
        {
            return table_ascii_[c];
        }
    };
    
    /// This class holds numeric values corresponding to reverse genomic bases (now, only ATCG)
    class bases_reverse
    {
        /// Precomputed values of ATCG
        static const unsigned char table_value_[26];
        
    public:
        
        /// Return the integer value of a genomic base
        inline static char value(char c)
        {
            return table_value_[c - 'A'];
        }

    };
}

#endif /* precomputed_hpp */
