//
//  logger.cpp
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#include "logger.hpp"

using namespace libseq;

////////////////////////////////////////////////////////////////////////////////
std::unique_ptr<logger::details> logger::instance_;

////////////////////////////////////////////////////////////////////////////////
void logger::init(const std::string &logfile)
{
    // Init the global logger
    if (instance_ != nullptr)
        throw std::logic_error("You have initialized the logger more than once.");
    
    // Create the logger
    instance_ = std::make_unique<details>();
    
    instance_->logfilename_ = logfile;
    
    // Format
    spdlog::set_pattern("[%H:%M:%S] %v");
    
    // Queue size
    std::size_t q_size = 4096;
    
    // Asynchronous file logging
    spdlog::set_async_mode(q_size);
    
    // Init file and console logging
    instance_->logfile_ = spdlog::basic_logger_mt("logfile", instance_->logfilename_);
    instance_->console_ = spdlog::stdout_logger_mt("console");
    
    info("Logger initialized");
}

////////////////////////////////////////////////////////////////////////////////
const std::string& logger::get_log_file()
{
    // Check for a valid logger initialization
    check();
    
    return instance_->logfilename_;
}

