//
//  file_mmap.hpp
//
//  Copyright 2018 Franco Milicchio and Marco Oliva. All rights reserved.
//


#ifndef file_mmap_hpp
#define file_mmap_hpp

#include <mio/mmap.hpp>
#include <atomic>

#include "file.hpp"


namespace libseq
{
    
    class file_mmap : public file<file_mmap>
    {

    public:
    
        /// Actual name of the class
        static constexpr char name_[] = "file_mmap";
        
        /// Construct a memory mapped file
        file_mmap(path& p);
    
        /// Append a value to this file
        template <typename storage_type>
        void append_(const storage_type& s)
        {
        if (byte_index_ == size_)
                throw std::runtime_error("Attempting to write out of file" + file_path_.absolute_path());
        
        ::memcpy(mmap_.data() + byte_index_, &s, sizeof(storage_type));
        byte_index_ += sizeof(storage_type);
        }
    
        /// Flush changes to disk
        void close_();
        
    private:
    
        /// Memory-mapped file, rw
        mio::mmap_sink mmap_;
        
        /// Atomic index to enable safe concurrency
        std::atomic<std::size_t> byte_index_;
        
        /// Actual file path
        path file_path_;
        
        /// File size
        std::size_t size_;
    
    };
    
}


#endif //file_mmap_hpp
