//
//  file.hpp
//
//  Copyright 2018 Franco Milicchio and Marco Oliva. All rights reserved.
//

#ifndef file_hpp
#define file_hpp

#include "inherit.hpp"
#include "path.hpp"
#include "logger.hpp"

namespace libseq
{
    /// File base class 
    template <typename Derived>
    class file : public inherit<Derived>
    {
    public:
        
        /// Return the name of the derived class
        inline const char* name() const
        {
            return this->self().name_;
        }
    
        /// Append a value to this file
        template <typename storage_type>
        void append(const storage_type &s)
        {
            this->self().append(s);
        }
        
        /// Close, flush changes to disk
        void close()
        {
            return this->self().close();
        }
    
    };
    
}


#endif //file_hpp
