//
//  accelerator_integer.hpp
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#include "accelerator_uint128.hpp"


using namespace libseq;

using storage_type = accelerator_uint128::storage_type;

////////////////////////////////////////////////////////////////////////////////
storage_type accelerator_uint128::to_forward(const std::string_view &s) const
{
    // Fake 128-bit register
    storage_type ymm;
    
    std::size_t substringlength = s.length();
    
    std::fill(std::begin(ymm), std::end(ymm), 0);
    
    std::size_t i, off, c, v;
    
    // Non-SIMD
    for (i = 0, off = 0; i < substringlength; i++)
    {
        c = libseq::bases_values::value(s[i]); //lookup[s[sub + i] - '0'];
        v = c << ((i - off * 32) * 2);
        
        ymm[off] |= v;
        
        // New offset inside fake AVX register
        off = ((i + 1) % 32 == 0) ? off + 1 : off;
    }
    
    return ymm;
}

////////////////////////////////////////////////////////////////////////////////
std::string accelerator_uint128::to_string(const storage_type &r, std::size_t k) const
{
    std::size_t i, off, c, v;
    
    std::string s;
    
    // Non-SIMD
    for (i = 0, off = 0; i < k; i++)
    {
        // Test
        v = r[off] >> ((i - off * 32) * 2);
        c = v & 3;
        s += libseq::bases_values::ascii(c); //static_cast<char>(uplook[c]);
        
        // New offset inside fake AVX register
        off = ((i + 1) % 32 == 0) ? off + 1 : off;
    }
    
    return s;
}

////////////////////////////////////////////////////////////////////////////////
std::size_t accelerator_uint128::hash(storage_type r) const
{
    hash_storage_type h;
    return h(r);
}

////////////////////////////////////////////////////////////////////////////////
int accelerator_uint128::compare(storage_type r1, storage_type r2) const
{
    return r1 == r2;
}

////////////////////////////////////////////////////////////////////////////////
bool accelerator_uint128::equal(storage_type r1, storage_type r2) const
{
    return r1 == r2;
}
