//
//  benchmarks.cpp
//
//  Copyright 2019 Franco Milicchio. All rights reserved.
//

#include <hayai/hayai_main.hpp>

#include "../libseq/accelerator_string.hpp"
#include "../libseq/accelerator_uint128.hpp"
#include "../libseq/accelerator_sse.hpp"
#include "../libseq/fastq_mmap.hpp"
#include "../libseq/logger.hpp"

#include <gatb/gatb_core.hpp>
#include "kmer.h"

#include "auxbenchfuncs.hpp"

// 30, 35, 47, 55, 63, 64
#define K 47
#define S 102400

/****************************************************************************
 * KMER *********************************************************************
 ****************************************************************************/

#if 1

BENCHMARK(PARSE_KMER, SSE, 100, 1000)
{
    std::string t = random_string(S);
    parse_kmer_can_sse(K, t);
}

BENCHMARK(PARSE_KMER, DSK, 100, 1000)
{
    std::string t = random_string(S);
    parse_kmer_can_dsk(K, t);
}

BENCHMARK(PARSE_KMER, KMC, 100, 1000)
{
    std::string t = random_string(S);
    parse_kmer_can_kmc(K, t);
}

#endif

#if 0

#define FASTQ_FILE "/Users/fm/Downloads/aaa/SRR9691020.fastq"
#define MAX_READS 40000000
// 63, 47
#define K 47

BENCHMARK(USELESS, IGNORE, 1, 1)
{
    libseq::fastq_mmap fastq(FASTQ_FILE);
}

BENCHMARK(PARSE_FILE, SSE, 1, 1)
{
    libseq::fastq_mmap fastq(FASTQ_FILE);
    
    std::size_t count = 0, kmers = 0;

    libseq::accelerator_sse acc;
    
    // Parsed string
    libseq::accelerator_sse::storage_type from;

    for (auto &p : fastq)
    {
        std::size_t nsubstrings = p.length() - K + 1;
        
        // For every kmer
        for (int i = 0; i < nsubstrings; i++)
        {
            from = acc.to_canonical(p.substr(i, K));
            kmers++;
        }
        
        if (count++ > MAX_READS) break;
    }
    std::cout << "count " << count << " kmers " << kmers << std::endl;
}

BENCHMARK(PARSE_FILE, DSK, 1, 1)
{
    std::size_t count = 0, kmers = 0;

    // We open the reference file
    IBank* fasBank = Bank::open(FASTQ_FILE);
        
    Iterator<Sequence>* itFas = fasBank->iterator();

    // Parsed string
    Kmer<65>::Type from;

    for (itFas->first(); !itFas->isDone(); itFas->next())
    {
        std::string s = itFas->item().toString();
                
        Data data(s.data());
        
        // Parse every kmer
        Kmer<65>::ModelCanonical model(K);
        Kmer<65>::ModelCanonical::Iterator it(model);
        it.setData(data);
        
        // Parse every kmer
        for (it.first(); !it.isDone(); it.next())
        {
            from = it->value(0);
            kmers++;
        }
        
        if (count++ > MAX_READS) break;
    }
    std::cout << "count " << count << " kmers " << kmers << std::endl;
}

BENCHMARK(PARSE_FILE, KMC, 1, 1)
{
    libseq::fastq_mmap fastq(FASTQ_FILE);
    
    std::size_t count = 0, kmers = 0;

    CKmer<2> from;

    for (auto &p : fastq)
    {
        std::size_t nsubstrings = p.length() - K + 1;
        
//        std::string s(p);
        
        // For every kmer
        for (int i = 0; i < nsubstrings; i++)
        {
//            std::string_view kmer(s.data() + i, K);
                
//            uchar *tmp = (uchar*) kmer.data();
//            uchar *tmp = (uchar*) (s.data() + i);p.substr(i, K)
            uchar *tmp = (uchar*) (p.substr(i, K).data());

            from.load(tmp, K);
            
            kmers++;
        }
        
        if (count++ > MAX_READS) break;
    }
    std::cout << "count " << count << " kmers " << kmers << std::endl;
}


#endif

/****************************************************************************
 * Run benchmarks ***********************************************************
 ****************************************************************************/

int main(int argc, char** argv)
{
    // Initialize logger
    libseq::path log(".");
    log = log.append("benchmarks.logs");
    libseq::logger::init(log.absolute_path());
    
    // Set up the main runner.
    ::hayai::MainRunner runner;
    
    ::hayai::Console::SetFormattingEnabled(false);
    
    // Parse the arguments.
    int result = runner.ParseArgs(argc, argv);
    if (result)
    {
        return result;
    }
    
    // Execute based on the selected mode.
    return runner.Run();
}
