//
//  auxbenchfuncs.hpp
//
//  Copyright 2022 Franco Milicchio. All rights reserved.
//

#ifndef auxbenchfuncs_hpp
#define auxbenchfuncs_hpp

#include <hayai/hayai_main.hpp>

#include "../libseq/accelerator_string.hpp"
#include "../libseq/accelerator_uint128.hpp"
#include "../libseq/accelerator_sse.hpp"
#include "../libseq/partitioner_hash.hpp"
#include "../libseq/logger.hpp"

#include <gatb/gatb_core.hpp>
#include "kmer.h"

std::string random_string( size_t length );

void parse_kmer_fwd_string(int k, std::string &t);
void parse_kmer_fwd_sse(int k, std::string &t);
void parse_kmer_fwd_dsk(int k, std::string &t);

void parse_kmer_rev_string(int k, std::string &t);
void parse_kmer_rev_sse(int k, std::string &t);

void parse_kmer_can_string(int k, std::string &t);
void parse_kmer_can_sse(int k, std::string &t);
void parse_kmer_can_dsk(int k, std::string &t);
void parse_kmer_can_kmc(int k, std::string &t);

void parse_read_can_string(int k, std::string &t);
void parse_read_can_sse(int k, std::string &t);
void parse_read_can_dsk(int k, std::string &t);
void parse_read_can_kmc(int k, std::string &t);



#endif /* auxbenchfuncs_hpp */
