//
//  reader.h
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#ifndef reader_h
#define reader_h

#include <string_view>

#include "inherit.hpp"
#include "logger.hpp"

namespace libseq
{

    /// Generic reader class to be statically inherited, basically a contract
    template <typename Derived>
    class reader : public inherit<Derived>
    {
    public:
        
        /// Return the beginning of the file iterator
        auto begin() const
        {
            libseq::logger::debug("Started reading input file");
            
            return this->self().begin();
        }

        /// Return the ending of the file iterator
        auto end() const
        {
            libseq::logger::debug("Ended reading input file");

            return this->self().end();
        }
        
        /// Return the size of a file
        auto size() const
        {
            return this->self().size();
        }
        
        /// Return the properties of a read
        auto properties() const
        {
            return this->self().properties();
        }

        /// Return the name of the derived class
        const char* name() const
        {
            return this->self().name();
        }
        
    };
    
}

#endif /* reader_h */
