//
//  filepath.hpp
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#ifndef filepath_hpp
#define filepath_hpp

#include <string>

namespace libseq
{
    /// File path class utilities (waiting for Xcode to include <filesystem>)
    class path
    {
    public:
        
        /// Constructs a file path
        path(const std::string &p);
        
        /// Returns the absolute file path
        std::string absolute_path() const;
        
        /// Returns the file name
        std::string file_name() const;
        
        /// Returns the file path
        std::string file_path() const;
        
        /// Returns if the path is a directory
        bool is_directory() const;
        
        /// Returns if the path is a file
        bool is_file() const;
        
        /// Appends a new item to a path (if a directory)
        path append(const std::string &p) const;
        
        /// Returns the path as a string
        operator std::string();
        
    private:
        
        std::string path_;
    };
}

#endif /* filepath_hpp */
