//
//  inherit.h
//
//  Copyright 2018 Franco Milicchio. All rights reserved.
//

#ifndef inherit_h
#define inherit_h

namespace libseq
{
    
    /// Class that handles CRTP static inheritance (see J. Boccara's blog series)
    template <typename Derived>
    class inherit
    {
    public:
        
        /// Return the underlying class
        Derived& self()
        {
            return static_cast<Derived&>(*this);
        }
        
        /// Return the underlying class (const version)
        Derived const& self() const
        {
            return static_cast<Derived const&>(*this);
        }
    };
    
}

#endif /* inherit_h */
